/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.privilege;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.support.WriteRequestBuilder;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.security.action.privilege.PutPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.privilege.PutPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.privilege.PutPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;

public final class PutPrivilegesRequestBuilder
extends ActionRequestBuilder<PutPrivilegesRequest, PutPrivilegesResponse>
implements WriteRequestBuilder<PutPrivilegesRequestBuilder> {
    public PutPrivilegesRequestBuilder(ElasticsearchClient client) {
        super(client, PutPrivilegesAction.INSTANCE, new PutPrivilegesRequest());
    }

    ApplicationPrivilegeDescriptor parsePrivilege(XContentParser parser, String applicationName, String privilegeName) throws IOException {
        ApplicationPrivilegeDescriptor privilege = ApplicationPrivilegeDescriptor.parse(parser, applicationName, privilegeName, false);
        this.checkPrivilegeName(privilege, applicationName, privilegeName);
        return privilege;
    }

    public PutPrivilegesRequestBuilder source(BytesReference source, XContentType xContentType) throws IOException {
        Objects.requireNonNull(xContentType);
        try (StreamInput stream = source.streamInput();
             XContentParser parser = xContentType.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, stream);){
            XContentParser.Token token = parser.currentToken();
            if (token == null) {
                token = parser.nextToken();
            }
            if (token != XContentParser.Token.START_OBJECT) {
                throw new ElasticsearchParseException("expected object but found {} instead", new Object[]{token});
            }
            ArrayList<ApplicationPrivilegeDescriptor> privileges = new ArrayList<ApplicationPrivilegeDescriptor>();
            while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                token = parser.currentToken();
                assert (token == XContentParser.Token.FIELD_NAME) : "Invalid token " + token;
                String applicationName = parser.currentName();
                token = parser.nextToken();
                if (token != XContentParser.Token.START_OBJECT) {
                    throw new ElasticsearchParseException("expected the value for {} to be an object, but found {} instead", new Object[]{applicationName, token});
                }
                while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                    token = parser.currentToken();
                    assert (token == XContentParser.Token.FIELD_NAME);
                    String privilegeName = parser.currentName();
                    token = parser.nextToken();
                    if (token != XContentParser.Token.START_OBJECT) {
                        throw new ElasticsearchParseException("expected the value for {} to be an object, but found {} instead", new Object[]{applicationName, token});
                    }
                    privileges.add(this.parsePrivilege(parser, applicationName, privilegeName));
                }
            }
            ((PutPrivilegesRequest)this.request).setPrivileges(privileges);
        }
        return this;
    }

    private void checkPrivilegeName(ApplicationPrivilegeDescriptor privilege, String applicationName, String providedName) {
        String privilegeName = privilege.getName();
        if (!Strings.isNullOrEmpty(applicationName) && !applicationName.equals(privilege.getApplication())) {
            throw new IllegalArgumentException("privilege application [" + privilege.getApplication() + "] in source does not match the provided application [" + applicationName + "]");
        }
        if (!Strings.isNullOrEmpty(providedName) && !providedName.equals(privilegeName)) {
            throw new IllegalArgumentException("privilege name [" + privilegeName + "] in source does not match the provided name [" + providedName + "]");
        }
    }
}

