/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.termsenum.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class TermsEnumResponse
extends BroadcastResponse {
    public static final String TERMS_FIELD = "terms";
    public static final String COMPLETE_FIELD = "complete";
    static final ConstructingObjectParser<TermsEnumResponse, Void> PARSER = new ConstructingObjectParser("term_enum_results", true, arg -> {
        BroadcastResponse response = (BroadcastResponse)arg[0];
        return new TermsEnumResponse((List)arg[1], response.getTotalShards(), response.getSuccessfulShards(), response.getFailedShards(), Arrays.asList(response.getShardFailures()), (Boolean)arg[2]);
    });
    private final List<String> terms;
    private boolean complete;

    TermsEnumResponse(StreamInput in) throws IOException {
        super(in);
        this.terms = in.readStringList();
        this.complete = in.readBoolean();
    }

    public TermsEnumResponse(List<String> terms, int totalShards, int successfulShards, int failedShards, List<DefaultShardOperationFailedException> shardFailures, boolean complete) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.terms = terms == null ? Collections.emptyList() : terms;
        this.complete = complete;
    }

    public List<String> getTerms() {
        return this.terms;
    }

    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringCollection(this.terms);
        out.writeBoolean(this.complete);
    }

    @Override
    protected void addCustomXContentFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(TERMS_FIELD);
        if (this.getTerms() != null && !this.getTerms().isEmpty()) {
            for (String term : this.getTerms()) {
                builder.value(term);
            }
        }
        builder.endArray();
        builder.field(COMPLETE_FIELD, this.complete);
    }

    public static TermsEnumResponse fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    static {
        TermsEnumResponse.declareBroadcastFields(PARSER);
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), new ParseField(TERMS_FIELD, new String[0]));
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), new ParseField(COMPLETE_FIELD, new String[0]));
    }
}

