/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql;

import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.ql.QlClientException;
import org.elasticsearch.xpack.ql.tree.Source;

public class ParsingException
extends QlClientException {
    private final int line;
    private final int charPositionInLine;

    public ParsingException(String message, Exception cause, int line, int charPositionInLine) {
        super(message, cause);
        this.line = line;
        this.charPositionInLine = charPositionInLine;
    }

    public ParsingException(String message, Object ... args) {
        this(Source.EMPTY, message, args);
    }

    public ParsingException(Source source, String message, Object ... args) {
        super(message, args);
        this.line = source.source().getLineNumber();
        this.charPositionInLine = source.source().getColumnNumber();
    }

    public ParsingException(Exception cause, Source source, String message, Object ... args) {
        super(cause, message, args);
        this.line = source.source().getLineNumber();
        this.charPositionInLine = source.source().getColumnNumber();
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.charPositionInLine + 1;
    }

    public String getErrorMessage() {
        return super.getMessage();
    }

    @Override
    public RestStatus status() {
        return RestStatus.BAD_REQUEST;
    }

    @Override
    public String getMessage() {
        return LoggerMessageFormat.format("line {}:{}: {}", this.getLineNumber(), this.getColumnNumber(), this.getErrorMessage());
    }
}

