/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.predicate.logical;

import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.Nullability;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.predicate.BinaryOperator;
import org.elasticsearch.xpack.ql.expression.predicate.logical.BinaryLogicPipe;
import org.elasticsearch.xpack.ql.expression.predicate.logical.BinaryLogicProcessor;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public abstract class BinaryLogic
extends BinaryOperator<Boolean, Boolean, Boolean, BinaryLogicProcessor.BinaryLogicOperation> {
    protected BinaryLogic(Source source, Expression left, Expression right, BinaryLogicProcessor.BinaryLogicOperation operation) {
        super(source, left, right, operation);
    }

    @Override
    public DataType dataType() {
        return DataTypes.BOOLEAN;
    }

    @Override
    protected Expression.TypeResolution resolveInputType(Expression e, TypeResolutions.ParamOrdinal paramOrdinal) {
        return TypeResolutions.isBoolean(e, this.sourceText(), paramOrdinal);
    }

    @Override
    protected Pipe makePipe() {
        return new BinaryLogicPipe(this.source(), this, Expressions.pipe(this.left()), Expressions.pipe(this.right()), (BinaryLogicProcessor.BinaryLogicOperation)this.function());
    }

    @Override
    public Nullability nullable() {
        return Nullability.UNKNOWN;
    }

    @Override
    protected boolean isCommutative() {
        return true;
    }
}

