/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.action;

import java.time.Clock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.authc.support.SecondaryAuthentication;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.idp.action.SamlInitiateSingleSignOnRequest;
import org.elasticsearch.xpack.idp.action.SamlInitiateSingleSignOnResponse;
import org.elasticsearch.xpack.idp.privileges.UserPrivilegeResolver;
import org.elasticsearch.xpack.idp.saml.authn.FailedAuthenticationResponseMessageBuilder;
import org.elasticsearch.xpack.idp.saml.authn.SuccessfulAuthenticationResponseMessageBuilder;
import org.elasticsearch.xpack.idp.saml.authn.UserServiceAuthentication;
import org.elasticsearch.xpack.idp.saml.idp.SamlIdentityProvider;
import org.elasticsearch.xpack.idp.saml.sp.SamlServiceProvider;
import org.elasticsearch.xpack.idp.saml.support.SamlAuthenticationState;
import org.elasticsearch.xpack.idp.saml.support.SamlFactory;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.Response;

public class TransportSamlInitiateSingleSignOnAction
extends HandledTransportAction<SamlInitiateSingleSignOnRequest, SamlInitiateSingleSignOnResponse> {
    private final Logger logger = LogManager.getLogger(TransportSamlInitiateSingleSignOnAction.class);
    private final SecurityContext securityContext;
    private final SamlIdentityProvider identityProvider;
    private final SamlFactory samlFactory;
    private final UserPrivilegeResolver privilegeResolver;

    @Inject
    public TransportSamlInitiateSingleSignOnAction(TransportService transportService, ActionFilters actionFilters, SecurityContext securityContext, SamlIdentityProvider idp, SamlFactory factory, UserPrivilegeResolver privilegeResolver) {
        super("cluster:admin/idp/saml/init", transportService, actionFilters, SamlInitiateSingleSignOnRequest::new);
        this.securityContext = securityContext;
        this.identityProvider = idp;
        this.samlFactory = factory;
        this.privilegeResolver = privilegeResolver;
    }

    protected void doExecute(Task task, SamlInitiateSingleSignOnRequest request, ActionListener<SamlInitiateSingleSignOnResponse> listener) {
        SamlAuthenticationState authenticationState = request.getSamlAuthenticationState();
        this.identityProvider.resolveServiceProvider(request.getSpEntityId(), request.getAssertionConsumerService(), false, (ActionListener<SamlServiceProvider>)ActionListener.wrap(sp -> {
            if (null == sp) {
                String message = "Service Provider with Entity ID [" + request.getSpEntityId() + "] and ACS [" + request.getAssertionConsumerService() + "] is not known to this Identity Provider";
                this.possiblyReplyWithSamlFailure(authenticationState, request.getSpEntityId(), request.getAssertionConsumerService(), "urn:oasis:names:tc:SAML:2.0:status:Responder", new IllegalArgumentException(message), listener);
                return;
            }
            SecondaryAuthentication secondaryAuthentication = SecondaryAuthentication.readFromContext((SecurityContext)this.securityContext);
            if (secondaryAuthentication == null) {
                this.possiblyReplyWithSamlFailure(authenticationState, request.getSpEntityId(), request.getAssertionConsumerService(), "urn:oasis:names:tc:SAML:2.0:status:Requester", (Exception)((Object)new ElasticsearchSecurityException("Request is missing secondary authentication", RestStatus.FORBIDDEN, new Object[0])), listener);
                return;
            }
            this.buildUserFromAuthentication(secondaryAuthentication, (SamlServiceProvider)sp, (ActionListener<UserServiceAuthentication>)ActionListener.wrap(user -> {
                if (user == null) {
                    this.possiblyReplyWithSamlFailure(authenticationState, request.getSpEntityId(), request.getAssertionConsumerService(), "urn:oasis:names:tc:SAML:2.0:status:Requester", (Exception)((Object)new ElasticsearchSecurityException("User [{}] is not permitted to access service [{}]", RestStatus.FORBIDDEN, new Object[]{secondaryAuthentication.getUser().principal(), sp.getEntityId()})), listener);
                    return;
                }
                SuccessfulAuthenticationResponseMessageBuilder builder = new SuccessfulAuthenticationResponseMessageBuilder(this.samlFactory, Clock.systemUTC(), this.identityProvider);
                try {
                    Response response = builder.build((UserServiceAuthentication)user, authenticationState);
                    listener.onResponse((Object)new SamlInitiateSingleSignOnResponse(user.getServiceProvider().getEntityId(), user.getServiceProvider().getAssertionConsumerService().toString(), this.samlFactory.getXmlContent((SAMLObject)response), "urn:oasis:names:tc:SAML:2.0:status:Success", null));
                }
                catch (ElasticsearchException e) {
                    listener.onFailure((Exception)((Object)e));
                }
            }, e -> this.possiblyReplyWithSamlFailure(authenticationState, request.getSpEntityId(), request.getAssertionConsumerService(), "urn:oasis:names:tc:SAML:2.0:status:Responder", (Exception)e, listener)));
        }, e -> this.possiblyReplyWithSamlFailure(authenticationState, request.getSpEntityId(), request.getAssertionConsumerService(), "urn:oasis:names:tc:SAML:2.0:status:Responder", (Exception)e, listener)));
    }

    private void buildUserFromAuthentication(SecondaryAuthentication secondaryAuthentication, SamlServiceProvider serviceProvider, ActionListener<UserServiceAuthentication> listener) {
        User user = secondaryAuthentication.getUser();
        secondaryAuthentication.execute(ignore -> {
            ActionListener wrapped = ActionListener.wrap(userPrivileges -> {
                if (!userPrivileges.hasAccess) {
                    listener.onResponse(null);
                } else {
                    this.logger.debug("Resolved [{}] for [{}]", userPrivileges, (Object)user);
                    listener.onResponse((Object)new UserServiceAuthentication(user.principal(), user.fullName(), user.email(), userPrivileges.roles, serviceProvider));
                }
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0));
            this.privilegeResolver.resolve(serviceProvider.getPrivileges(), (ActionListener<UserPrivilegeResolver.UserPrivileges>)wrapped);
            return null;
        });
    }

    private void possiblyReplyWithSamlFailure(SamlAuthenticationState authenticationState, String spEntityId, String acsUrl, String statusCode, Exception e, ActionListener<SamlInitiateSingleSignOnResponse> listener) {
        this.logger.debug("Failed to generate a successful SAML response: ", (Throwable)e);
        if (authenticationState != null) {
            FailedAuthenticationResponseMessageBuilder builder = new FailedAuthenticationResponseMessageBuilder(this.samlFactory, Clock.systemUTC(), this.identityProvider).setInResponseTo(authenticationState.getAuthnRequestId()).setAcsUrl(acsUrl).setPrimaryStatusCode(statusCode);
            Response response = builder.build();
            listener.onResponse((Object)new SamlInitiateSingleSignOnResponse(spEntityId, acsUrl, this.samlFactory.getXmlContent((SAMLObject)response), statusCode, e.getMessage()));
        } else {
            listener.onFailure(e);
        }
    }
}

