/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.saml.authn;

import java.util.Set;
import org.elasticsearch.xpack.idp.authc.AuthenticationMethod;
import org.elasticsearch.xpack.idp.authc.NetworkControl;
import org.elasticsearch.xpack.idp.saml.sp.SamlServiceProvider;

public class UserServiceAuthentication {
    private final String principal;
    private final String name;
    private final String email;
    private final Set<String> roles;
    private final SamlServiceProvider serviceProvider;
    private final Set<AuthenticationMethod> authenticationMethods;
    private final Set<NetworkControl> networkControls;

    public UserServiceAuthentication(String principal, String name, String email, Set<String> roles, SamlServiceProvider serviceProvider, Set<AuthenticationMethod> authenticationMethods, Set<NetworkControl> networkControls) {
        this.principal = principal;
        this.name = name;
        this.email = email;
        this.roles = Set.copyOf(roles);
        this.serviceProvider = serviceProvider;
        this.authenticationMethods = authenticationMethods;
        this.networkControls = networkControls;
    }

    public UserServiceAuthentication(String principal, String name, String email, Set<String> roles, SamlServiceProvider serviceProvider) {
        this(principal, name, email, roles, serviceProvider, Set.of(AuthenticationMethod.PASSWORD), Set.of(NetworkControl.TLS));
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public SamlServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }

    public Set<AuthenticationMethod> getAuthenticationMethods() {
        return this.authenticationMethods;
    }

    public Set<NetworkControl> getNetworkControls() {
        return this.networkControls;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{principal='" + this.principal + "', name='" + this.name + "', email='" + this.email + "', roles=" + this.roles + ", serviceProvider=" + this.serviceProvider + ", authenticationMethods=" + this.authenticationMethods + ", networkControls=" + this.networkControls + "}";
    }
}

