/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.saml.sp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ssl.CertParsingUtils;

public class SamlServiceProviderDocument
implements ToXContentObject,
Writeable {
    public static final String SIGN_AUTHN = "authn";
    public static final String SIGN_LOGOUT = "logout";
    private static final Set<String> ALLOWED_SIGN_MESSAGES = Set.of("authn", "logout");
    @Nullable
    public String docId;
    public String name;
    public String entityId;
    public String acs;
    @Nullable
    public String nameIdFormat;
    public boolean enabled = true;
    public Instant created;
    public Instant lastModified;
    public Set<String> signMessages = Set.of();
    @Nullable
    public Long authenticationExpiryMillis;
    public final Privileges privileges = new Privileges();
    public final AttributeNames attributeNames = new AttributeNames();
    public final Certificates certificates = new Certificates();
    private static final ObjectParser<SamlServiceProviderDocument, SamlServiceProviderDocument> DOC_PARSER = new ObjectParser("service_provider_doc", true, SamlServiceProviderDocument::new);
    private static final ObjectParser<Privileges, Void> PRIVILEGES_PARSER = new ObjectParser("service_provider_priv", true, null);
    private static final ObjectParser<AttributeNames, Void> ATTRIBUTES_PARSER = new ObjectParser("service_provider_attr", true, null);
    private static final ObjectParser<Certificates, Void> CERTIFICATES_PARSER = new ObjectParser("service_provider_cert", true, null);
    private static final BiConsumer<SamlServiceProviderDocument, Object> NULL_CONSUMER = (doc, obj) -> {};

    public SamlServiceProviderDocument() {
    }

    public SamlServiceProviderDocument(StreamInput in) throws IOException {
        this.docId = in.readOptionalString();
        this.name = in.readString();
        this.entityId = in.readString();
        this.acs = in.readString();
        this.enabled = in.readBoolean();
        this.created = in.readInstant();
        this.lastModified = in.readInstant();
        this.nameIdFormat = in.readOptionalString();
        this.authenticationExpiryMillis = in.readOptionalVLong();
        this.privileges.resource = in.readString();
        this.privileges.rolePatterns = new TreeSet<String>(in.readSet(StreamInput::readString));
        this.attributeNames.principal = in.readString();
        this.attributeNames.email = in.readOptionalString();
        this.attributeNames.name = in.readOptionalString();
        this.attributeNames.roles = in.readOptionalString();
        this.certificates.serviceProviderSigning = in.readStringList();
        this.certificates.identityProviderSigning = in.readStringList();
        this.certificates.identityProviderMetadataSigning = in.readStringList();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.docId);
        out.writeString(this.name);
        out.writeString(this.entityId);
        out.writeString(this.acs);
        out.writeBoolean(this.enabled);
        out.writeInstant(this.created);
        out.writeInstant(this.lastModified);
        out.writeOptionalString(this.nameIdFormat);
        out.writeOptionalVLong(this.authenticationExpiryMillis);
        out.writeString(this.privileges.resource);
        out.writeStringCollection(this.privileges.rolePatterns == null ? Set.of() : this.privileges.rolePatterns);
        out.writeString(this.attributeNames.principal);
        out.writeOptionalString(this.attributeNames.email);
        out.writeOptionalString(this.attributeNames.name);
        out.writeOptionalString(this.attributeNames.roles);
        out.writeStringCollection(this.certificates.serviceProviderSigning);
        out.writeStringCollection(this.certificates.identityProviderSigning);
        out.writeStringCollection(this.certificates.identityProviderMetadataSigning);
    }

    public String getDocId() {
        return this.docId;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public void setAcs(String acs) {
        this.acs = acs;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setCreated(Instant created) {
        this.created = created;
    }

    public void setLastModified(Instant lastModified) {
        this.lastModified = lastModified;
    }

    public void setCreatedMillis(Long millis) {
        this.created = Instant.ofEpochMilli(millis);
    }

    public void setLastModifiedMillis(Long millis) {
        this.lastModified = Instant.ofEpochMilli(millis);
    }

    public void setNameIdFormat(String nameIdFormat) {
        this.nameIdFormat = nameIdFormat;
    }

    public void setSignMessages(Collection<String> signMessages) {
        this.signMessages = signMessages == null ? Set.of() : Set.copyOf(signMessages);
    }

    public void setAuthenticationExpiryMillis(Long authenticationExpiryMillis) {
        this.authenticationExpiryMillis = authenticationExpiryMillis;
    }

    public void setAuthenticationExpiry(Duration authnExpiry) {
        this.authenticationExpiryMillis = authnExpiry == null ? null : Long.valueOf(authnExpiry.toMillis());
    }

    public Duration getAuthenticationExpiry() {
        return this.authenticationExpiryMillis == null ? null : Duration.ofMillis(this.authenticationExpiryMillis);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SamlServiceProviderDocument that = (SamlServiceProviderDocument)o;
        return Objects.equals(this.docId, that.docId) && Objects.equals(this.name, that.name) && Objects.equals(this.entityId, that.entityId) && Objects.equals(this.acs, that.acs) && Objects.equals(this.enabled, that.enabled) && Objects.equals(this.created, that.created) && Objects.equals(this.lastModified, that.lastModified) && Objects.equals(this.nameIdFormat, that.nameIdFormat) && Objects.equals(this.authenticationExpiryMillis, that.authenticationExpiryMillis) && Objects.equals(this.certificates, that.certificates) && Objects.equals(this.privileges, that.privileges) && Objects.equals(this.attributeNames, that.attributeNames);
    }

    public int hashCode() {
        return Objects.hash(this.docId, this.name, this.entityId, this.acs, this.enabled, this.created, this.lastModified, this.nameIdFormat, this.authenticationExpiryMillis, this.certificates, this.privileges, this.attributeNames);
    }

    public static SamlServiceProviderDocument fromXContent(String docId, XContentParser parser) throws IOException {
        SamlServiceProviderDocument doc = new SamlServiceProviderDocument();
        doc.setDocId(docId);
        return (SamlServiceProviderDocument)DOC_PARSER.parse(parser, (Object)doc, (Object)doc);
    }

    public ValidationException validate() {
        Set invalidSignOptions;
        ValidationException validation = new ValidationException();
        if (Strings.isNullOrEmpty((String)this.name)) {
            validation.addValidationError("field [" + Fields.NAME + "] is required, but was [" + this.name + "]");
        }
        if (Strings.isNullOrEmpty((String)this.entityId)) {
            validation.addValidationError("field [" + Fields.ENTITY_ID + "] is required, but was [" + this.entityId + "]");
        }
        if (Strings.isNullOrEmpty((String)this.acs)) {
            validation.addValidationError("field [" + Fields.ACS + "] is required, but was [" + this.acs + "]");
        }
        if (this.created == null) {
            validation.addValidationError("field [" + Fields.CREATED_DATE + "] is required, but was [" + this.created + "]");
        }
        if (this.lastModified == null) {
            validation.addValidationError("field [" + Fields.LAST_MODIFIED + "] is required, but was [" + this.lastModified + "]");
        }
        if (!(invalidSignOptions = Sets.difference(this.signMessages, ALLOWED_SIGN_MESSAGES)).isEmpty()) {
            validation.addValidationError("the values [" + invalidSignOptions + "] are not permitted for [" + Fields.SIGN_MSGS + "] - permitted values are [" + ALLOWED_SIGN_MESSAGES + "]");
        }
        if (Strings.isNullOrEmpty((String)this.privileges.resource)) {
            validation.addValidationError("field [" + Fields.PRIVILEGES + "." + Fields.Privileges.RESOURCE + "] is required, but was [" + this.privileges.resource + "]");
        }
        if (Strings.isNullOrEmpty((String)this.attributeNames.principal)) {
            validation.addValidationError("field [" + Fields.ATTRIBUTES + "." + Fields.Attributes.PRINCIPAL + "] is required, but was [" + this.attributeNames.principal + "]");
        }
        if (validation.validationErrors().isEmpty()) {
            return null;
        }
        return validation;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Fields.NAME.getPreferredName(), this.name);
        builder.field(Fields.ENTITY_ID.getPreferredName(), this.entityId);
        builder.field(Fields.ACS.getPreferredName(), this.acs);
        builder.field(Fields.ENABLED.getPreferredName(), this.enabled);
        builder.field(Fields.CREATED_DATE.getPreferredName(), this.created == null ? null : Long.valueOf(this.created.toEpochMilli()));
        builder.field(Fields.LAST_MODIFIED.getPreferredName(), this.lastModified == null ? null : Long.valueOf(this.lastModified.toEpochMilli()));
        builder.field(Fields.NAME_ID.getPreferredName(), this.nameIdFormat);
        builder.field(Fields.SIGN_MSGS.getPreferredName(), this.signMessages == null ? List.of() : this.signMessages);
        builder.field(Fields.AUTHN_EXPIRY.getPreferredName(), this.authenticationExpiryMillis);
        builder.startObject(Fields.PRIVILEGES.getPreferredName());
        builder.field(Fields.Privileges.RESOURCE.getPreferredName(), this.privileges.resource);
        builder.field(Fields.Privileges.ROLES.getPreferredName(), this.privileges.rolePatterns);
        builder.endObject();
        builder.startObject(Fields.ATTRIBUTES.getPreferredName());
        builder.field(Fields.Attributes.PRINCIPAL.getPreferredName(), this.attributeNames.principal);
        builder.field(Fields.Attributes.EMAIL.getPreferredName(), this.attributeNames.email);
        builder.field(Fields.Attributes.NAME.getPreferredName(), this.attributeNames.name);
        builder.field(Fields.Attributes.ROLES.getPreferredName(), this.attributeNames.roles);
        builder.endObject();
        builder.startObject(Fields.CERTIFICATES.getPreferredName());
        builder.field(Fields.Certificates.SP_SIGNING.getPreferredName(), this.certificates.serviceProviderSigning);
        builder.field(Fields.Certificates.IDP_SIGNING.getPreferredName(), this.certificates.identityProviderSigning);
        builder.field(Fields.Certificates.IDP_METADATA.getPreferredName(), this.certificates.identityProviderMetadataSigning);
        builder.endObject();
        return builder.endObject();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{docId=" + this.docId + ", name=" + this.name + ", entityId=" + this.entityId + "}@" + this.hashCode();
    }

    static {
        DOC_PARSER.declareString(SamlServiceProviderDocument::setName, Fields.NAME);
        DOC_PARSER.declareString(SamlServiceProviderDocument::setEntityId, Fields.ENTITY_ID);
        DOC_PARSER.declareString(SamlServiceProviderDocument::setAcs, Fields.ACS);
        DOC_PARSER.declareBoolean(SamlServiceProviderDocument::setEnabled, Fields.ENABLED);
        DOC_PARSER.declareLong(SamlServiceProviderDocument::setCreatedMillis, Fields.CREATED_DATE);
        DOC_PARSER.declareLong(SamlServiceProviderDocument::setLastModifiedMillis, Fields.LAST_MODIFIED);
        DOC_PARSER.declareStringOrNull(SamlServiceProviderDocument::setNameIdFormat, Fields.NAME_ID);
        DOC_PARSER.declareStringArray(SamlServiceProviderDocument::setSignMessages, Fields.SIGN_MSGS);
        DOC_PARSER.declareField(SamlServiceProviderDocument::setAuthenticationExpiryMillis, parser -> parser.currentToken() == XContentParser.Token.VALUE_NULL ? null : Long.valueOf(parser.longValue()), Fields.AUTHN_EXPIRY, ObjectParser.ValueType.LONG_OR_NULL);
        DOC_PARSER.declareObject(NULL_CONSUMER, (parser, doc) -> PRIVILEGES_PARSER.parse(parser, (Object)doc.privileges, null), Fields.PRIVILEGES);
        PRIVILEGES_PARSER.declareString(Privileges::setResource, Fields.Privileges.RESOURCE);
        PRIVILEGES_PARSER.declareStringArray(Privileges::setRolePatterns, Fields.Privileges.ROLES);
        DOC_PARSER.declareObject(NULL_CONSUMER, (p, doc) -> ATTRIBUTES_PARSER.parse(p, (Object)doc.attributeNames, null), Fields.ATTRIBUTES);
        ATTRIBUTES_PARSER.declareString(AttributeNames::setPrincipal, Fields.Attributes.PRINCIPAL);
        ATTRIBUTES_PARSER.declareStringOrNull(AttributeNames::setEmail, Fields.Attributes.EMAIL);
        ATTRIBUTES_PARSER.declareStringOrNull(AttributeNames::setName, Fields.Attributes.NAME);
        ATTRIBUTES_PARSER.declareStringOrNull(AttributeNames::setRoles, Fields.Attributes.ROLES);
        DOC_PARSER.declareObject(NULL_CONSUMER, (p, doc) -> CERTIFICATES_PARSER.parse(p, (Object)doc.certificates, null), Fields.CERTIFICATES);
        CERTIFICATES_PARSER.declareStringArray(Certificates::setServiceProviderSigning, Fields.Certificates.SP_SIGNING);
        CERTIFICATES_PARSER.declareStringArray(Certificates::setIdentityProviderSigning, Fields.Certificates.IDP_SIGNING);
        CERTIFICATES_PARSER.declareStringArray(Certificates::setIdentityProviderMetadataSigning, Fields.Certificates.IDP_METADATA);
    }

    public static class Privileges {
        public String resource;
        public SortedSet<String> rolePatterns = new TreeSet<String>();

        public void setResource(String resource) {
            this.resource = resource;
        }

        public void setRolePatterns(Collection<String> rolePatterns) {
            this.rolePatterns = new TreeSet<String>(rolePatterns);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Privileges that = (Privileges)o;
            return Objects.equals(this.resource, that.resource) && Objects.equals(this.rolePatterns, that.rolePatterns);
        }

        public int hashCode() {
            return Objects.hash(this.resource, this.rolePatterns);
        }
    }

    public static class AttributeNames {
        public String principal;
        @Nullable
        public String email;
        @Nullable
        public String name;
        @Nullable
        public String roles;

        public void setPrincipal(String principal) {
            this.principal = principal;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setRoles(String roles) {
            this.roles = roles;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AttributeNames that = (AttributeNames)o;
            return Objects.equals(this.principal, that.principal) && Objects.equals(this.email, that.email) && Objects.equals(this.name, that.name) && Objects.equals(this.roles, that.roles);
        }

        public int hashCode() {
            return Objects.hash(this.principal, this.email, this.name, this.roles);
        }
    }

    public static class Certificates {
        public List<String> serviceProviderSigning = List.of();
        public List<String> identityProviderSigning = List.of();
        public List<String> identityProviderMetadataSigning = List.of();

        public void setServiceProviderSigning(Collection<String> serviceProviderSigning) {
            this.serviceProviderSigning = serviceProviderSigning == null ? List.of() : List.copyOf(serviceProviderSigning);
        }

        public void setIdentityProviderSigning(Collection<String> identityProviderSigning) {
            this.identityProviderSigning = identityProviderSigning == null ? List.of() : List.copyOf(identityProviderSigning);
        }

        public void setIdentityProviderMetadataSigning(Collection<String> identityProviderMetadataSigning) {
            this.identityProviderMetadataSigning = identityProviderMetadataSigning == null ? List.of() : List.copyOf(identityProviderMetadataSigning);
        }

        public void setServiceProviderX509SigningCertificates(Collection<X509Certificate> certificates) {
            this.serviceProviderSigning = this.encodeCertificates(certificates);
        }

        public List<X509Certificate> getServiceProviderX509SigningCertificates() {
            return this.decodeCertificates(this.serviceProviderSigning);
        }

        public void setIdentityProviderX509SigningCertificates(Collection<X509Certificate> certificates) {
            this.identityProviderSigning = this.encodeCertificates(certificates);
        }

        public List<X509Certificate> getIdentityProviderX509SigningCertificates() {
            return this.decodeCertificates(this.identityProviderSigning);
        }

        public void setIdentityProviderX509MetadataSigningCertificates(Collection<X509Certificate> certificates) {
            this.identityProviderMetadataSigning = this.encodeCertificates(certificates);
        }

        public List<X509Certificate> getIdentityProviderX509MetadataSigningCertificates() {
            return this.decodeCertificates(this.identityProviderMetadataSigning);
        }

        private List<String> encodeCertificates(Collection<X509Certificate> certificates) {
            return certificates == null ? List.of() : certificates.stream().map(cert -> {
                try {
                    return cert.getEncoded();
                }
                catch (CertificateEncodingException e) {
                    throw new ElasticsearchException("Cannot read certificate", (Throwable)e, new Object[0]);
                }
            }).map(Base64.getEncoder()::encodeToString).collect(Collectors.toUnmodifiableList());
        }

        private List<X509Certificate> decodeCertificates(List<String> encodedCertificates) {
            if (encodedCertificates == null || encodedCertificates.isEmpty()) {
                return List.of();
            }
            return encodedCertificates.stream().map(this::decodeCertificate).collect(Collectors.toUnmodifiableList());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private X509Certificate decodeCertificate(String base64Cert) {
            byte[] bytes = base64Cert.getBytes(StandardCharsets.UTF_8);
            try (ByteArrayInputStream stream = new ByteArrayInputStream(bytes);){
                List certificates = CertParsingUtils.readCertificates((InputStream)Base64.getDecoder().wrap(stream));
                if (certificates.size() == 1) {
                    Certificate certificate = (Certificate)certificates.get(0);
                    if (certificate instanceof X509Certificate) {
                        X509Certificate x509Certificate = (X509Certificate)certificate;
                        return x509Certificate;
                    }
                    throw new ElasticsearchException("Certificate ({}) is not a X.509 certificate", new Object[]{certificate.getClass()});
                }
                throw new ElasticsearchException("Expected a single certificate, but found {}", new Object[]{certificates.size()});
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (CertificateException e) {
                throw new ElasticsearchException("Cannot parse certificate(s)", (Throwable)e, new Object[0]);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Certificates that = (Certificates)o;
            return Objects.equals(this.serviceProviderSigning, that.serviceProviderSigning) && Objects.equals(this.identityProviderSigning, that.identityProviderSigning) && Objects.equals(this.identityProviderMetadataSigning, that.identityProviderMetadataSigning);
        }

        public int hashCode() {
            return Objects.hash(this.serviceProviderSigning, this.identityProviderSigning, this.identityProviderMetadataSigning);
        }
    }

    public static interface Fields {
        public static final ParseField NAME = new ParseField("name", new String[0]);
        public static final ParseField ENTITY_ID = new ParseField("entity_id", new String[0]);
        public static final ParseField ACS = new ParseField("acs", new String[0]);
        public static final ParseField ENABLED = new ParseField("enabled", new String[0]);
        public static final ParseField NAME_ID = new ParseField("name_id_format", new String[0]);
        public static final ParseField SIGN_MSGS = new ParseField("sign_messages", new String[0]);
        public static final ParseField AUTHN_EXPIRY = new ParseField("authn_expiry_ms", new String[0]);
        public static final ParseField CREATED_DATE = new ParseField("created", new String[0]);
        public static final ParseField LAST_MODIFIED = new ParseField("last_modified", new String[0]);
        public static final ParseField PRIVILEGES = new ParseField("privileges", new String[0]);
        public static final ParseField ATTRIBUTES = new ParseField("attributes", new String[0]);
        public static final ParseField CERTIFICATES = new ParseField("certificates", new String[0]);

        public static interface Certificates {
            public static final ParseField SP_SIGNING = new ParseField("sp_signing", new String[0]);
            public static final ParseField IDP_SIGNING = new ParseField("idp_signing", new String[0]);
            public static final ParseField IDP_METADATA = new ParseField("idp_metadata", new String[0]);
        }

        public static interface Attributes {
            public static final ParseField PRINCIPAL = new ParseField("principal", new String[0]);
            public static final ParseField EMAIL = new ParseField("email", new String[0]);
            public static final ParseField NAME = new ParseField("name", new String[0]);
            public static final ParseField ROLES = new ParseField("roles", new String[0]);
        }

        public static interface Privileges {
            public static final ParseField RESOURCE = new ParseField("resource", new String[0]);
            public static final ParseField ROLES = new ParseField("roles", new String[0]);
        }
    }
}

