/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic;

import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.BinaryArithmeticOperation;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.SqlArithmeticOperation;
import org.elasticsearch.xpack.sql.type.SqlDataTypeConverter;
import org.elasticsearch.xpack.sql.type.SqlDataTypes;

abstract class DateTimeArithmeticOperation
extends SqlArithmeticOperation {
    DateTimeArithmeticOperation(Source source, Expression left, Expression right, BinaryArithmeticOperation operation) {
        super(source, left, right, operation);
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        DataType l = this.left().dataType();
        DataType r = this.right().dataType();
        if (l.isNumeric() && r.isNumeric()) {
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        if (SqlDataTypes.isInterval(l) || SqlDataTypes.isInterval(r)) {
            if (SqlDataTypeConverter.commonType(l, r) == null) {
                return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"[{}] has arguments with incompatible types [{}] and [{}]", (Object[])new Object[]{this.symbol(), l, r}));
            }
            return this.resolveWithIntervals();
        }
        return super.resolveType();
    }

    protected Expression.TypeResolution resolveWithIntervals() {
        DataType l = this.left().dataType();
        DataType r = this.right().dataType();
        if (!(SqlDataTypes.isDateOrTimeBased(r) || SqlDataTypes.isInterval(r) || DataTypes.isNull((DataType)r)) || !(SqlDataTypes.isDateOrTimeBased(l) || SqlDataTypes.isInterval(l) || DataTypes.isNull((DataType)l))) {
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"[{}] has arguments with incompatible types [{}] and [{}]", (Object[])new Object[]{this.symbol(), l, r}));
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }
}

