/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.planner;

import java.time.Duration;
import java.time.Period;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.ql.execution.search.AggRef;
import org.elasticsearch.xpack.ql.execution.search.FieldExtraction;
import org.elasticsearch.xpack.ql.expression.Alias;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.AttributeMap;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.Foldables;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.expression.Order;
import org.elasticsearch.xpack.ql.expression.ReferenceAttribute;
import org.elasticsearch.xpack.ql.expression.function.Function;
import org.elasticsearch.xpack.ql.expression.function.Functions;
import org.elasticsearch.xpack.ql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.ql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.ql.expression.function.aggregate.InnerAggregate;
import org.elasticsearch.xpack.ql.expression.function.grouping.GroupingFunction;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.AggPathInput;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.UnaryPipe;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.planner.ExpressionTranslators;
import org.elasticsearch.xpack.ql.querydsl.container.AttributeSort;
import org.elasticsearch.xpack.ql.querydsl.container.ScriptSort;
import org.elasticsearch.xpack.ql.querydsl.container.Sort;
import org.elasticsearch.xpack.ql.querydsl.query.Query;
import org.elasticsearch.xpack.ql.rule.Rule;
import org.elasticsearch.xpack.ql.rule.RuleExecutor;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.CollectionUtils;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.function.Score;
import org.elasticsearch.xpack.sql.expression.function.aggregate.CompoundNumericAggregate;
import org.elasticsearch.xpack.sql.expression.function.aggregate.TopHits;
import org.elasticsearch.xpack.sql.expression.function.grouping.Histogram;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeHistogramFunction;
import org.elasticsearch.xpack.sql.expression.literal.interval.IntervalDayTime;
import org.elasticsearch.xpack.sql.expression.literal.interval.IntervalYearMonth;
import org.elasticsearch.xpack.sql.expression.literal.interval.Intervals;
import org.elasticsearch.xpack.sql.plan.logical.Pivot;
import org.elasticsearch.xpack.sql.plan.physical.AggregateExec;
import org.elasticsearch.xpack.sql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.sql.plan.physical.FilterExec;
import org.elasticsearch.xpack.sql.plan.physical.LimitExec;
import org.elasticsearch.xpack.sql.plan.physical.LocalExec;
import org.elasticsearch.xpack.sql.plan.physical.OrderExec;
import org.elasticsearch.xpack.sql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.sql.plan.physical.PivotExec;
import org.elasticsearch.xpack.sql.plan.physical.ProjectExec;
import org.elasticsearch.xpack.sql.planner.FoldingException;
import org.elasticsearch.xpack.sql.planner.QueryTranslator;
import org.elasticsearch.xpack.sql.querydsl.agg.AggFilter;
import org.elasticsearch.xpack.sql.querydsl.agg.Aggs;
import org.elasticsearch.xpack.sql.querydsl.agg.GroupByDateHistogram;
import org.elasticsearch.xpack.sql.querydsl.agg.GroupByKey;
import org.elasticsearch.xpack.sql.querydsl.agg.GroupByNumericHistogram;
import org.elasticsearch.xpack.sql.querydsl.agg.GroupByValue;
import org.elasticsearch.xpack.sql.querydsl.agg.LeafAgg;
import org.elasticsearch.xpack.sql.querydsl.container.AggregateSort;
import org.elasticsearch.xpack.sql.querydsl.container.ComputedRef;
import org.elasticsearch.xpack.sql.querydsl.container.GlobalCountRef;
import org.elasticsearch.xpack.sql.querydsl.container.GroupByRef;
import org.elasticsearch.xpack.sql.querydsl.container.GroupingFunctionSort;
import org.elasticsearch.xpack.sql.querydsl.container.MetricAggRef;
import org.elasticsearch.xpack.sql.querydsl.container.PivotColumnRef;
import org.elasticsearch.xpack.sql.querydsl.container.QueryContainer;
import org.elasticsearch.xpack.sql.querydsl.container.ScoreSort;
import org.elasticsearch.xpack.sql.querydsl.container.TopHitsAggRef;
import org.elasticsearch.xpack.sql.session.EmptyExecutable;
import org.elasticsearch.xpack.sql.type.SqlDataTypeConverter;
import org.elasticsearch.xpack.sql.type.SqlDataTypes;
import org.elasticsearch.xpack.sql.util.Check;
import org.elasticsearch.xpack.sql.util.DateUtils;

class QueryFolder
extends RuleExecutor<PhysicalPlan> {
    QueryFolder() {
    }

    PhysicalPlan fold(PhysicalPlan plan) {
        return (PhysicalPlan)this.execute((Node)plan);
    }

    protected Iterable<RuleExecutor.Batch> batches() {
        RuleExecutor.Batch rollup = new RuleExecutor.Batch((RuleExecutor)this, "Fold queries", new Rule[]{new FoldPivot(), new FoldAggregate(), new FoldProject(), new FoldFilter(), new FoldOrderBy(), new FoldLimit()});
        RuleExecutor.Batch local = new RuleExecutor.Batch((RuleExecutor)this, "Local queries", new Rule[]{new LocalLimit(), new PropagateEmptyLocal()});
        RuleExecutor.Batch finish = new RuleExecutor.Batch((RuleExecutor)this, "Finish query", RuleExecutor.Limiter.ONCE, new Rule[]{new PlanOutputToQueryRef()});
        return Arrays.asList(rollup, local, finish);
    }

    private static class FoldPivot
    extends FoldingRule<PivotExec> {
        private FoldPivot() {
        }

        @Override
        protected PhysicalPlan rule(PivotExec plan) {
            if (plan.child() instanceof EsQueryExec) {
                EsQueryExec exec = (EsQueryExec)plan.child();
                Pivot p = plan.pivot();
                EsQueryExec fold = FoldAggregate.fold(new AggregateExec(plan.source(), exec, new ArrayList(p.groupingSet()), CollectionUtils.combine((Collection[])new Collection[]{p.groupingSet(), p.aggregates()})), exec);
                QueryContainer query = fold.queryContainer();
                ArrayList<Tuple<FieldExtraction, String>> fields = new ArrayList<Tuple<FieldExtraction, String>>(query.fields());
                int startingIndex = fields.size() - p.aggregates().size() - 1;
                Tuple groupTuple = (Tuple)fields.remove(startingIndex);
                AttributeMap<Literal> values = p.valuesToLiterals();
                for (int i = startingIndex; i < fields.size(); ++i) {
                    Tuple tuple = (Tuple)fields.remove(i);
                    for (Map.Entry entry : values.entrySet()) {
                        fields.add((Tuple<FieldExtraction, String>)new Tuple((Object)new PivotColumnRef((FieldExtraction)groupTuple.v1(), (FieldExtraction)tuple.v1(), ((Literal)entry.getValue()).value()), (Object)Expressions.id((Expression)((Expression)entry.getKey()))));
                    }
                    i += values.size();
                }
                return fold.with(new QueryContainer(query.query(), query.aggs(), fields, query.aliases(), query.pseudoFunctions(), query.scalarFunctions(), query.sort(), query.limit(), query.shouldTrackHits(), query.shouldIncludeFrozen(), values.size()));
            }
            return plan;
        }
    }

    static class FoldAggregate
    extends FoldingRule<AggregateExec> {
        FoldAggregate() {
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static GroupingContext groupBy(List<? extends Expression> groupings) {
            if (groupings.isEmpty()) {
                return null;
            }
            LinkedHashMap<Integer, GroupByKey> aggMap = new LinkedHashMap<Integer, GroupByKey>();
            for (Expression expression : groupings) {
                void var4_4;
                Object var4_5 = null;
                Integer hash = expression.hashCode();
                String aggId = Expressions.id((Expression)expression);
                if (expression instanceof FieldAttribute) {
                    FieldAttribute field = (FieldAttribute)expression;
                    field = field.exactAttribute();
                    GroupByValue groupByValue = new GroupByValue(aggId, field.name());
                } else {
                    Expression field;
                    if (!(expression instanceof Function)) throw new SqlIllegalArgumentException("Cannot GROUP BY {}", expression);
                    if (expression instanceof DateTimeHistogramFunction) {
                        DateTimeHistogramFunction dthf = (DateTimeHistogramFunction)expression;
                        field = dthf.field();
                        if (field instanceof FieldAttribute) {
                            if (dthf.calendarInterval() != null) {
                                GroupByDateHistogram groupByDateHistogram = new GroupByDateHistogram(aggId, QueryTranslator.nameOf(expression), dthf.calendarInterval(), dthf.zoneId());
                            } else {
                                GroupByDateHistogram groupByDateHistogram = new GroupByDateHistogram(aggId, QueryTranslator.nameOf(expression), dthf.fixedInterval(), dthf.zoneId());
                            }
                        } else if (field instanceof Function) {
                            ScriptTemplate script = ((Function)field).asScript();
                            if (dthf.calendarInterval() != null) {
                                GroupByDateHistogram groupByDateHistogram = new GroupByDateHistogram(aggId, script, dthf.calendarInterval(), dthf.zoneId());
                            } else {
                                GroupByDateHistogram groupByDateHistogram = new GroupByDateHistogram(aggId, script, dthf.fixedInterval(), dthf.zoneId());
                            }
                        }
                    } else if (expression instanceof ScalarFunction) {
                        ScalarFunction sf = (ScalarFunction)expression;
                        GroupByValue groupByValue = new GroupByValue(aggId, sf.asScript());
                    } else {
                        void var4_23;
                        if (!(expression instanceof GroupingFunction)) throw new SqlIllegalArgumentException("Cannot GROUP BY function {}", expression);
                        if (!(expression instanceof Histogram)) throw new SqlIllegalArgumentException("Unsupproted grouping function {}", expression);
                        Histogram h = (Histogram)expression;
                        field = h.field();
                        if (SqlDataTypes.isDateBased(h.dataType())) {
                            Object value = h.interval().value();
                            if (value instanceof IntervalYearMonth && (((Period)((IntervalYearMonth)value).interval()).equals(Period.ofYears(1)) || ((Period)((IntervalYearMonth)value).interval()).equals(Period.ofMonths(1)))) {
                                String calendarInterval;
                                Period yearMonth = (Period)((IntervalYearMonth)value).interval();
                                String string = calendarInterval = yearMonth.equals(Period.ofYears(1)) ? Histogram.YEAR_INTERVAL : Histogram.MONTH_INTERVAL;
                                if (field instanceof FieldAttribute) {
                                    GroupByDateHistogram groupByDateHistogram = new GroupByDateHistogram(aggId, QueryTranslator.nameOf(field), calendarInterval, h.zoneId());
                                } else if (field instanceof Function) {
                                    GroupByDateHistogram groupByDateHistogram = new GroupByDateHistogram(aggId, ((Function)field).asScript(), calendarInterval, h.zoneId());
                                }
                            } else if (value instanceof IntervalDayTime && ((Duration)((IntervalDayTime)value).interval()).equals(Duration.ofDays(1L))) {
                                if (field instanceof FieldAttribute) {
                                    GroupByDateHistogram groupByDateHistogram = new GroupByDateHistogram(aggId, QueryTranslator.nameOf(field), Histogram.DAY_INTERVAL, h.zoneId());
                                } else if (field instanceof Function) {
                                    GroupByDateHistogram groupByDateHistogram = new GroupByDateHistogram(aggId, ((Function)field).asScript(), Histogram.DAY_INTERVAL, h.zoneId());
                                }
                            } else {
                                long intervalAsMillis = Intervals.inMillis(h.interval());
                                if (h.dataType() == SqlDataTypes.DATE) {
                                    intervalAsMillis = DateUtils.minDayInterval(intervalAsMillis);
                                }
                                if (field instanceof FieldAttribute) {
                                    GroupByDateHistogram groupByDateHistogram = new GroupByDateHistogram(aggId, QueryTranslator.nameOf(field), intervalAsMillis, h.zoneId());
                                } else if (field instanceof Function) {
                                    GroupByDateHistogram groupByDateHistogram = new GroupByDateHistogram(aggId, ((Function)field).asScript(), intervalAsMillis, h.zoneId());
                                }
                            }
                        } else if (field instanceof FieldAttribute || field instanceof Function) {
                            Double interval = (Double)SqlDataTypeConverter.convert(Foldables.valueOf((Expression)h.interval()), DataTypes.DOUBLE);
                            if (field instanceof FieldAttribute) {
                                GroupByNumericHistogram groupByNumericHistogram = new GroupByNumericHistogram(aggId, QueryTranslator.nameOf(field), (double)interval);
                            } else {
                                GroupByNumericHistogram groupByNumericHistogram = new GroupByNumericHistogram(aggId, ((Function)field).asScript(), (double)interval);
                            }
                        }
                        if (var4_23 == null) {
                            throw new SqlIllegalArgumentException("Unsupported histogram field {}", field);
                        }
                    }
                }
                aggMap.put(hash, (GroupByKey)var4_4);
            }
            return new GroupingContext(aggMap);
        }

        @Override
        protected PhysicalPlan rule(AggregateExec a) {
            if (a.child() instanceof EsQueryExec) {
                EsQueryExec exec = (EsQueryExec)a.child();
                return FoldAggregate.fold(a, exec);
            }
            return a;
        }

        static EsQueryExec fold(AggregateExec a, EsQueryExec exec) {
            GroupingContext groupingContext;
            QueryContainer queryC = exec.queryContainer();
            String id = null;
            AttributeMap.Builder aliases = AttributeMap.builder();
            for (NamedExpression namedExpression : a.aggregates()) {
                if (!(namedExpression instanceof Alias)) continue;
                aliases.put(namedExpression.toAttribute(), (Object)((Alias)namedExpression).child());
            }
            if (!aliases.build().isEmpty()) {
                aliases.putAll(queryC.aliases());
                queryC = queryC.withAliases((AttributeMap<Expression>)aliases.build());
            }
            if ((groupingContext = FoldAggregate.groupBy(a.groupings())) != null) {
                queryC = queryC.addGroups(groupingContext.groupMap.values());
            }
            LinkedHashMap<CompoundNumericAggregate, String> linkedHashMap = new LinkedHashMap<CompoundNumericAggregate, String>();
            Iterator<? extends NamedExpression> iterator = a.aggregates().iterator();
            while (iterator.hasNext()) {
                GroupByKey matchingGroup;
                NamedExpression namedExpression;
                NamedExpression target = namedExpression = iterator.next();
                if (namedExpression instanceof Alias) {
                    target = ((Alias)namedExpression).child();
                }
                id = Expressions.id((Expression)target);
                if (target.foldable()) {
                    queryC = queryC.addColumn(namedExpression.toAttribute());
                    continue;
                }
                if (target instanceof Function) {
                    if (target instanceof ScalarFunction) {
                        ScalarFunction f = (ScalarFunction)target;
                        Pipe proc = f.asPipe();
                        AtomicReference<QueryContainer> qC = new AtomicReference<QueryContainer>(queryC);
                        if (!(proc = (Pipe)proc.transformUp(p -> {
                            if (p.resolved()) {
                                return p;
                            }
                            Expression exp = p.expression();
                            GroupByKey matchingGroup = null;
                            if (groupingContext != null) {
                                matchingGroup = groupingContext.groupFor(exp);
                            } else if (exp instanceof ScalarFunction) {
                                throw new FoldingException((Node<?>)exp, "Scalar function " + exp.toString() + " can be used only if included already in grouping", new Object[0]);
                            }
                            if (matchingGroup != null && (exp instanceof Attribute || exp instanceof ScalarFunction || exp instanceof GroupingFunction)) {
                                Processor action = null;
                                boolean isDateBased = SqlDataTypes.isDateBased(exp.dataType());
                                if (exp instanceof DateTimeHistogramFunction) {
                                    action = ((UnaryPipe)p).action();
                                    isDateBased = true;
                                }
                                return new AggPathInput(exp.source(), exp, (AggRef)new GroupByRef(matchingGroup.id(), null, isDateBased), action);
                            }
                            if (Functions.isAggregate((Expression)exp)) {
                                Tuple<QueryContainer, AggPathInput> withFunction = FoldAggregate.addAggFunction(matchingGroup, (AggregateFunction)exp, compoundAggMap, (QueryContainer)qC.get());
                                qC.set((QueryContainer)withFunction.v1());
                                return (Pipe)withFunction.v2();
                            }
                            return p;
                        })).resolved()) {
                            throw new FoldingException((Node<?>)target, "Cannot find grouping for '{}'", Expressions.name((Expression)target));
                        }
                        queryC = qC.get().addColumn(new ComputedRef(proc), id);
                        continue;
                    }
                    matchingGroup = null;
                    if (groupingContext != null) {
                        matchingGroup = groupingContext.groupFor((Expression)target);
                    }
                    if (target instanceof Attribute) {
                        Check.notNull(matchingGroup, "Cannot find group [{}]", Expressions.name((Expression)target));
                        queryC = queryC.addColumn((FieldExtraction)new GroupByRef(matchingGroup.id(), null, SqlDataTypes.isDateBased(target.dataType())), id);
                        continue;
                    }
                    if (target instanceof GroupingFunction) {
                        queryC = queryC.addColumn((FieldExtraction)new GroupByRef(matchingGroup.id(), null, SqlDataTypes.isDateBased(target.dataType())), id);
                        continue;
                    }
                    if (target.foldable()) {
                        queryC = queryC.addColumn(namedExpression.toAttribute());
                        continue;
                    }
                    Check.isTrue(Functions.isAggregate((Expression)target), "Expected aggregate function inside alias; got [{}]", target.nodeString());
                    AggregateFunction af = (AggregateFunction)target;
                    Tuple<QueryContainer, AggPathInput> withAgg = FoldAggregate.addAggFunction(matchingGroup, af, linkedHashMap, queryC);
                    queryC = ((QueryContainer)withAgg.v1()).addColumn((FieldExtraction)((AggPathInput)withAgg.v2()).context(), id);
                    continue;
                }
                matchingGroup = null;
                if (groupingContext != null) {
                    target = (Expression)queryC.aliases().resolve((Object)target, (Object)target);
                    id = Expressions.id((Expression)target);
                    matchingGroup = groupingContext.groupFor((Expression)target);
                    Check.notNull(matchingGroup, "Cannot find group [{}]", Expressions.name((Expression)namedExpression));
                    queryC = queryC.addColumn((FieldExtraction)new GroupByRef(matchingGroup.id(), null, SqlDataTypes.isDateBased(namedExpression.dataType())), id);
                    continue;
                }
                throw new SqlIllegalArgumentException("Cannot fold aggregate {}", namedExpression);
            }
            if (a.aggregates().stream().allMatch(e -> e.anyMatch(Expression::foldable))) {
                for (Expression expression : a.groupings()) {
                    GroupByKey matchingGroup = groupingContext.groupFor(expression);
                    queryC = queryC.addColumn((FieldExtraction)new GroupByRef(matchingGroup.id(), null, false), id);
                }
            }
            return new EsQueryExec(exec.source(), exec.index(), a.output(), queryC);
        }

        private static Tuple<QueryContainer, AggPathInput> addAggFunction(GroupByKey groupingAgg, AggregateFunction f, Map<CompoundNumericAggregate, String> compoundAggMap, QueryContainer queryC) {
            String functionId = Expressions.id((Expression)f);
            if (f instanceof Count) {
                Count c = (Count)f;
                if (c.field().foldable()) {
                    AggRef ref = null;
                    if (groupingAgg == null) {
                        ref = GlobalCountRef.INSTANCE;
                        queryC = queryC.withTrackHits();
                    } else {
                        ref = new GroupByRef(groupingAgg.id(), GroupByRef.Property.COUNT, false);
                    }
                    LinkedHashMap<String, GroupByKey> pseudoFunctions = new LinkedHashMap<String, GroupByKey>(queryC.pseudoFunctions());
                    pseudoFunctions.put(functionId, groupingAgg);
                    return new Tuple((Object)queryC.withPseudoFunctions(pseudoFunctions), (Object)new AggPathInput((Expression)f, ref));
                }
                if (!c.distinct()) {
                    LeafAgg leafAgg = QueryTranslator.toAgg(functionId, (Function)f);
                    AggPathInput a = new AggPathInput((Expression)f, (AggRef)new MetricAggRef(leafAgg.id(), "doc_count", "_count", null));
                    queryC = queryC.with(queryC.aggs().addAgg(leafAgg));
                    return new Tuple((Object)queryC, (Object)a);
                }
            }
            AggPathInput aggInput = null;
            if (f instanceof InnerAggregate) {
                InnerAggregate ia = (InnerAggregate)f;
                CompoundNumericAggregate outer = (CompoundNumericAggregate)ia.outer();
                String cAggPath = compoundAggMap.get((Object)outer);
                if (cAggPath == null) {
                    LeafAgg leafAgg = QueryTranslator.toAgg(Expressions.id((Expression)outer), (Function)outer);
                    cAggPath = leafAgg.id();
                    compoundAggMap.put(outer, cAggPath);
                    queryC = queryC.with(queryC.aggs().addAgg(leafAgg));
                }
                aggInput = new AggPathInput((Expression)f, (AggRef)new MetricAggRef(cAggPath, ia.innerName(), ia.innerKey() != null ? QueryTranslator.nameOf(ia.innerKey()) : null, ia.dataType()));
            } else {
                LeafAgg leafAgg = QueryTranslator.toAgg(functionId, (Function)f);
                aggInput = f instanceof TopHits ? new AggPathInput((Expression)f, (AggRef)new TopHitsAggRef(leafAgg.id(), f.dataType())) : new AggPathInput((Expression)f, (AggRef)new MetricAggRef(leafAgg.id(), f.dataType()));
                queryC = queryC.with(queryC.aggs().addAgg(leafAgg));
            }
            return new Tuple((Object)queryC, (Object)aggInput);
        }

        static class GroupingContext {
            final Map<Integer, GroupByKey> groupMap;
            final GroupByKey tail;

            GroupingContext(Map<Integer, GroupByKey> groupMap) {
                this.groupMap = groupMap;
                GroupByKey lastAgg = null;
                for (Map.Entry<Integer, GroupByKey> entry : groupMap.entrySet()) {
                    lastAgg = entry.getValue();
                }
                this.tail = lastAgg;
            }

            GroupByKey groupFor(Expression exp) {
                Integer hash = null;
                if (Functions.isAggregate((Expression)exp)) {
                    AggregateFunction f = (AggregateFunction)exp;
                    if (!this.groupMap.isEmpty()) {
                        GroupByKey matchingGroup = null;
                        hash = f.field().hashCode();
                        matchingGroup = this.groupMap.get(hash);
                        return matchingGroup != null ? matchingGroup : this.tail;
                    }
                    return null;
                }
                hash = exp.hashCode();
                return this.groupMap.get(hash);
            }

            public String toString() {
                return this.groupMap.toString();
            }
        }
    }

    private static class FoldProject
    extends FoldingRule<ProjectExec> {
        private FoldProject() {
        }

        @Override
        protected PhysicalPlan rule(ProjectExec project) {
            if (project.child() instanceof EsQueryExec) {
                EsQueryExec exec = (EsQueryExec)project.child();
                QueryContainer queryC = exec.queryContainer();
                AttributeMap.Builder aliases = AttributeMap.builder().putAll(queryC.aliases());
                AttributeMap.Builder processors = AttributeMap.builder().putAll(queryC.scalarFunctions());
                for (NamedExpression namedExpression : project.projections()) {
                    if (!(namedExpression instanceof Alias)) continue;
                    Attribute attr = namedExpression.toAttribute();
                    Expression e = ((Alias)namedExpression).child();
                    aliases.put(attr, (Object)e);
                    if (!(e instanceof ScalarFunction)) continue;
                    processors.put(attr, (Object)((ScalarFunction)e).asPipe());
                }
                QueryContainer clone = new QueryContainer(queryC.query(), queryC.aggs(), queryC.fields(), (AttributeMap<Expression>)aliases.build(), queryC.pseudoFunctions(), (AttributeMap<Pipe>)processors.build(), queryC.sort(), queryC.limit(), queryC.shouldTrackHits(), queryC.shouldIncludeFrozen(), queryC.minPageSize());
                return new EsQueryExec(exec.source(), exec.index(), project.output(), clone);
            }
            return project;
        }
    }

    private static class FoldFilter
    extends FoldingRule<FilterExec> {
        private FoldFilter() {
        }

        @Override
        protected PhysicalPlan rule(FilterExec plan) {
            if (plan.child() instanceof EsQueryExec) {
                EsQueryExec exec = (EsQueryExec)plan.child();
                QueryContainer qContainer = exec.queryContainer();
                QueryTranslator.QueryTranslation qt = QueryTranslator.toQuery(plan.condition(), plan.isHaving());
                Query query = null;
                if (qContainer.query() != null || qt.query != null) {
                    query = ExpressionTranslators.and((Source)plan.source(), (Query)qContainer.query(), (Query)qt.query);
                }
                Aggs aggs = this.addPipelineAggs(qContainer, qt, plan);
                qContainer = new QueryContainer(query, aggs, qContainer.fields(), qContainer.aliases(), qContainer.pseudoFunctions(), qContainer.scalarFunctions(), qContainer.sort(), qContainer.limit(), qContainer.shouldTrackHits(), qContainer.shouldIncludeFrozen(), qContainer.minPageSize());
                return exec.with(qContainer);
            }
            return plan;
        }

        private Aggs addPipelineAggs(QueryContainer qContainer, QueryTranslator.QueryTranslation qt, FilterExec fexec) {
            AggFilter filter = qt.aggFilter;
            Aggs aggs = qContainer.aggs();
            if (filter == null) {
                return qContainer.aggs();
            }
            aggs = aggs.addAgg(filter);
            return aggs;
        }
    }

    private static class FoldOrderBy
    extends FoldingRule<OrderExec> {
        private FoldOrderBy() {
        }

        @Override
        protected PhysicalPlan rule(OrderExec plan) {
            if (plan.child() instanceof EsQueryExec) {
                EsQueryExec exec = (EsQueryExec)plan.child();
                QueryContainer qContainer = exec.queryContainer();
                ListIterator<Order> it = plan.order().listIterator(plan.order().size());
                while (it.hasPrevious()) {
                    String lookup;
                    GroupByKey group;
                    Order order = it.previous();
                    Sort.Direction direction = Sort.Direction.from((Order.OrderDirection)order.direction());
                    Sort.Missing missing = Sort.Missing.from((Order.NullsPosition)order.nullsPosition());
                    Expression orderExpression = order.child();
                    if (orderExpression instanceof ReferenceAttribute) {
                        orderExpression = (Expression)qContainer.aliases().resolve((Object)orderExpression);
                    }
                    if ((group = qContainer.findGroupForAgg(lookup = Expressions.id((Expression)orderExpression))) != null && group != Aggs.IMPLICIT_GROUP_KEY) {
                        qContainer = qContainer.updateGroup(group.with(direction, missing));
                    }
                    if (orderExpression instanceof FieldAttribute) {
                        qContainer = qContainer.prependSort(lookup, (Sort)new AttributeSort((Attribute)((FieldAttribute)orderExpression), direction, missing));
                        continue;
                    }
                    if (orderExpression instanceof ScalarFunction) {
                        ScalarFunction sf = (ScalarFunction)orderExpression;
                        qContainer = qContainer.prependSort(lookup, (Sort)new ScriptSort(sf.asScript(), direction, missing));
                        continue;
                    }
                    if (orderExpression instanceof Histogram) {
                        qContainer = qContainer.prependSort(lookup, new GroupingFunctionSort(direction, missing));
                        continue;
                    }
                    if (orderExpression instanceof Score) {
                        qContainer = qContainer.prependSort(lookup, new ScoreSort(direction, missing));
                        continue;
                    }
                    if (orderExpression instanceof AggregateFunction) {
                        qContainer = qContainer.prependSort(lookup, new AggregateSort((AggregateFunction)orderExpression, direction, missing));
                        continue;
                    }
                    throw new SqlIllegalArgumentException("unsupported sorting expression {}", orderExpression);
                }
                return exec.with(qContainer);
            }
            return plan;
        }
    }

    private static class FoldLimit
    extends FoldingRule<LimitExec> {
        private FoldLimit() {
        }

        @Override
        protected PhysicalPlan rule(LimitExec plan) {
            if (plan.child() instanceof EsQueryExec) {
                EsQueryExec exec = (EsQueryExec)plan.child();
                int limit = (Integer)SqlDataTypeConverter.convert(Foldables.valueOf((Expression)plan.limit()), DataTypes.INTEGER);
                int currentSize = exec.queryContainer().limit();
                int newSize = currentSize < 0 ? limit : Math.min(currentSize, limit);
                return exec.with(exec.queryContainer().withLimit(newSize));
            }
            return plan;
        }
    }

    private static class LocalLimit
    extends FoldingRule<LimitExec> {
        private LocalLimit() {
        }

        @Override
        protected PhysicalPlan rule(LimitExec plan) {
            if (plan.child() instanceof LocalExec) {
                return plan.child();
            }
            return plan;
        }
    }

    private static class PropagateEmptyLocal
    extends FoldingRule<PhysicalPlan> {
        private PropagateEmptyLocal() {
        }

        @Override
        protected PhysicalPlan rule(PhysicalPlan plan) {
            PhysicalPlan p;
            if (plan.children().size() == 1 && (p = (PhysicalPlan)plan.children().get(0)) instanceof LocalExec) {
                if (((LocalExec)p).isEmpty()) {
                    return new LocalExec(plan.source(), new EmptyExecutable(plan.output()));
                }
                throw new SqlIllegalArgumentException("Encountered a bug; {} is a LocalExec but is not empty", p);
            }
            return plan;
        }
    }

    private static class PlanOutputToQueryRef
    extends FoldingRule<EsQueryExec> {
        private PlanOutputToQueryRef() {
        }

        @Override
        protected PhysicalPlan rule(EsQueryExec exec) {
            QueryContainer qContainer = exec.queryContainer();
            if (qContainer.hasColumns()) {
                return exec;
            }
            for (Attribute attr : exec.output()) {
                qContainer = qContainer.addColumn(attr);
            }
            return exec.with(qContainer);
        }
    }

    static abstract class FoldingRule<SubPlan extends PhysicalPlan>
    extends Rule<SubPlan, PhysicalPlan> {
        FoldingRule() {
        }

        public final PhysicalPlan apply(PhysicalPlan plan) {
            return (PhysicalPlan)plan.transformUp(this.typeToken(), this::rule);
        }

        protected abstract PhysicalPlan rule(SubPlan var1);
    }
}

