/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plugin;

import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestResponseListener;
import org.elasticsearch.xcontent.MediaType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.sql.action.SqlQueryRequest;
import org.elasticsearch.xpack.sql.action.SqlQueryResponse;
import org.elasticsearch.xpack.sql.plugin.SqlMediaTypeParser;
import org.elasticsearch.xpack.sql.plugin.TextFormat;

class SqlResponseListener
extends RestResponseListener<SqlQueryResponse> {
    private final long startNanos = System.nanoTime();
    private final MediaType mediaType;
    private final RestRequest request;

    SqlResponseListener(RestChannel channel, RestRequest request, SqlQueryRequest sqlRequest) {
        super(channel);
        this.request = request;
        this.mediaType = SqlMediaTypeParser.getResponseMediaType(request, sqlRequest);
        if (this.mediaType != TextFormat.CSV && request.hasParam("delimiter")) {
            String message = String.format(Locale.ROOT, "request [%s] contains unrecognized parameter: [delimiter]", request.path());
            throw new IllegalArgumentException(message);
        }
    }

    SqlResponseListener(RestChannel channel, RestRequest request) {
        super(channel);
        this.request = request;
        this.mediaType = SqlMediaTypeParser.getResponseMediaType(request);
    }

    public RestResponse buildResponse(SqlQueryResponse response) throws Exception {
        BytesRestResponse restResponse;
        if (this.mediaType instanceof XContentType) {
            XContentType type = (XContentType)this.mediaType;
            XContentBuilder builder = this.channel.newBuilder(this.request.getXContentType(), type, true);
            response.toXContent(builder, (ToXContent.Params)this.request);
            restResponse = new BytesRestResponse(RestStatus.OK, builder);
        } else {
            TextFormat type = (TextFormat)this.mediaType;
            String data = type.format(this.request, response);
            restResponse = new BytesRestResponse(RestStatus.OK, type.contentType(this.request), data.getBytes(StandardCharsets.UTF_8));
            if (response.hasCursor()) {
                restResponse.addHeader("Cursor", response.cursor());
            }
            if (response.hasId()) {
                restResponse.addHeader("Async-ID", response.id());
                restResponse.addHeader("Async-partial", String.valueOf(response.isPartial()));
                restResponse.addHeader("Async-running", String.valueOf(response.isRunning()));
            }
        }
        restResponse.addHeader("Took-nanos", Long.toString(System.nanoTime() - this.startNanos));
        return restResponse;
    }
}

