/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.BinaryDocValuesWriter;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterCodecReader;
import org.apache.lucene.index.FreqProxTermsWriter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafMetaData;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.NumericDocValuesWriter;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedDocValuesWriter;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedNumericDocValuesWriter;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.SortedSetDocValuesWriter;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.VectorValues;
import org.apache.lucene.index.VectorValuesWriter;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOSupplier;

public final class SortingCodecReader
extends FilterCodecReader {
    final Sorter.DocMap docMap;
    final LeafMetaData metaData;
    private String cachedField;
    private Object cachedObject;
    private boolean cacheIsNorms;
    private final Map<String, Integer> cacheStats = new HashMap<String, Integer>();

    public static CodecReader wrap(CodecReader reader, Sort sort) throws IOException {
        return SortingCodecReader.wrap(reader, new Sorter(sort).sort(reader), sort);
    }

    static CodecReader wrap(CodecReader reader, Sorter.DocMap docMap, Sort sort) {
        LeafMetaData metaData = reader.getMetaData();
        final LeafMetaData newMetaData = new LeafMetaData(metaData.getCreatedVersionMajor(), metaData.getMinVersion(), sort);
        if (docMap == null) {
            return new FilterCodecReader(reader){

                @Override
                public IndexReader.CacheHelper getCoreCacheHelper() {
                    return null;
                }

                @Override
                public IndexReader.CacheHelper getReaderCacheHelper() {
                    return null;
                }

                @Override
                public LeafMetaData getMetaData() {
                    return newMetaData;
                }

                public String toString() {
                    return "SortingCodecReader(" + this.in + ")";
                }
            };
        }
        if (reader.maxDoc() != docMap.size()) {
            throw new IllegalArgumentException("reader.maxDoc() should be equal to docMap.size(), got" + reader.maxDoc() + " != " + docMap.size());
        }
        assert (Sorter.isConsistent(docMap));
        return new SortingCodecReader(reader, docMap, newMetaData);
    }

    private SortingCodecReader(CodecReader in, Sorter.DocMap docMap, LeafMetaData metaData) {
        super(in);
        this.docMap = docMap;
        this.metaData = metaData;
    }

    @Override
    public FieldsProducer getPostingsReader() {
        final FieldsProducer postingsReader = this.in.getPostingsReader();
        return new FieldsProducer(){

            @Override
            public void close() throws IOException {
                postingsReader.close();
            }

            @Override
            public void checkIntegrity() throws IOException {
                postingsReader.checkIntegrity();
            }

            @Override
            public Iterator<String> iterator() {
                return postingsReader.iterator();
            }

            @Override
            public Terms terms(String field) throws IOException {
                Terms terms = postingsReader.terms(field);
                return terms == null ? null : new FreqProxTermsWriter.SortingTerms(terms, SortingCodecReader.this.in.getFieldInfos().fieldInfo(field).getIndexOptions(), SortingCodecReader.this.docMap);
            }

            @Override
            public int size() {
                return postingsReader.size();
            }
        };
    }

    @Override
    public StoredFieldsReader getFieldsReader() {
        StoredFieldsReader delegate = this.in.getFieldsReader();
        return this.newStoredFieldsReader(delegate);
    }

    private StoredFieldsReader newStoredFieldsReader(final StoredFieldsReader delegate) {
        return new StoredFieldsReader(){

            @Override
            public void visitDocument(int docID, StoredFieldVisitor visitor) throws IOException {
                delegate.visitDocument(SortingCodecReader.this.docMap.newToOld(docID), visitor);
            }

            @Override
            public StoredFieldsReader clone() {
                return SortingCodecReader.this.newStoredFieldsReader(delegate.clone());
            }

            @Override
            public void checkIntegrity() throws IOException {
                delegate.checkIntegrity();
            }

            @Override
            public void close() throws IOException {
                delegate.close();
            }
        };
    }

    @Override
    public Bits getLiveDocs() {
        Bits inLiveDocs = this.in.getLiveDocs();
        if (inLiveDocs == null) {
            return null;
        }
        return new SortingBits(inLiveDocs, this.docMap);
    }

    @Override
    public PointsReader getPointsReader() {
        final PointsReader delegate = this.in.getPointsReader();
        return new PointsReader(){

            @Override
            public void checkIntegrity() throws IOException {
                delegate.checkIntegrity();
            }

            @Override
            public PointValues getValues(String field) throws IOException {
                return new SortingPointValues(delegate.getValues(field), SortingCodecReader.this.docMap);
            }

            @Override
            public void close() throws IOException {
                delegate.close();
            }
        };
    }

    @Override
    public KnnVectorsReader getVectorReader() {
        final KnnVectorsReader delegate = this.in.getVectorReader();
        return new KnnVectorsReader(){

            @Override
            public void checkIntegrity() throws IOException {
                delegate.checkIntegrity();
            }

            @Override
            public VectorValues getVectorValues(String field) throws IOException {
                return new VectorValuesWriter.SortingVectorValues(delegate.getVectorValues(field), SortingCodecReader.this.docMap);
            }

            @Override
            public TopDocs search(String field, float[] target, int k, Bits acceptDocs) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() throws IOException {
                delegate.close();
            }

            @Override
            public long ramBytesUsed() {
                return delegate.ramBytesUsed();
            }
        };
    }

    @Override
    public NormsProducer getNormsReader() {
        final NormsProducer delegate = this.in.getNormsReader();
        return new NormsProducer(){

            @Override
            public NumericDocValues getNorms(FieldInfo field) throws IOException {
                return new NumericDocValuesWriter.SortingNumericDocValues(SortingCodecReader.this.getOrCreateNorms(field.name, () -> SortingCodecReader.this.getNumericDocValues(delegate.getNorms(field))));
            }

            @Override
            public void checkIntegrity() throws IOException {
                delegate.checkIntegrity();
            }

            @Override
            public void close() throws IOException {
                delegate.close();
            }
        };
    }

    @Override
    public DocValuesProducer getDocValuesReader() {
        final DocValuesProducer delegate = this.in.getDocValuesReader();
        return new DocValuesProducer(){

            @Override
            public NumericDocValues getNumeric(FieldInfo field) throws IOException {
                return new NumericDocValuesWriter.SortingNumericDocValues(SortingCodecReader.this.getOrCreateDV(field.name, () -> SortingCodecReader.this.getNumericDocValues(delegate.getNumeric(field))));
            }

            @Override
            public BinaryDocValues getBinary(FieldInfo field) throws IOException {
                return new BinaryDocValuesWriter.SortingBinaryDocValues(SortingCodecReader.this.getOrCreateDV(field.name, () -> new BinaryDocValuesWriter.BinaryDVs(SortingCodecReader.this.maxDoc(), SortingCodecReader.this.docMap, delegate.getBinary(field))));
            }

            @Override
            public SortedDocValues getSorted(FieldInfo field) throws IOException {
                SortedDocValues oldDocValues = delegate.getSorted(field);
                return new SortedDocValuesWriter.SortingSortedDocValues(oldDocValues, SortingCodecReader.this.getOrCreateDV(field.name, () -> {
                    int docID;
                    int[] ords = new int[SortingCodecReader.this.maxDoc()];
                    Arrays.fill(ords, -1);
                    while ((docID = oldDocValues.nextDoc()) != Integer.MAX_VALUE) {
                        int newDocID = SortingCodecReader.this.docMap.oldToNew(docID);
                        ords[newDocID] = oldDocValues.ordValue();
                    }
                    return ords;
                }));
            }

            @Override
            public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
                SortedNumericDocValues oldDocValues = delegate.getSortedNumeric(field);
                return new SortedNumericDocValuesWriter.SortingSortedNumericDocValues(oldDocValues, SortingCodecReader.this.getOrCreateDV(field.name, () -> new SortedNumericDocValuesWriter.LongValues(SortingCodecReader.this.maxDoc(), SortingCodecReader.this.docMap, oldDocValues, 0.5f)));
            }

            @Override
            public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
                SortedSetDocValues oldDocValues = delegate.getSortedSet(field);
                return new SortedSetDocValuesWriter.SortingSortedSetDocValues(oldDocValues, SortingCodecReader.this.getOrCreateDV(field.name, () -> new SortedSetDocValuesWriter.DocOrds(SortingCodecReader.this.maxDoc(), SortingCodecReader.this.docMap, oldDocValues, 0.5f)));
            }

            @Override
            public void checkIntegrity() throws IOException {
                delegate.checkIntegrity();
            }

            @Override
            public void close() throws IOException {
                delegate.close();
            }
        };
    }

    private NumericDocValuesWriter.NumericDVs getNumericDocValues(NumericDocValues oldNumerics) throws IOException {
        int docID;
        FixedBitSet docsWithField = new FixedBitSet(this.maxDoc());
        long[] values = new long[this.maxDoc()];
        while ((docID = oldNumerics.nextDoc()) != Integer.MAX_VALUE) {
            int newDocID = this.docMap.oldToNew(docID);
            docsWithField.set(newDocID);
            values[newDocID] = oldNumerics.longValue();
        }
        return new NumericDocValuesWriter.NumericDVs(values, docsWithField);
    }

    @Override
    public TermVectorsReader getTermVectorsReader() {
        return this.newTermVectorsReader(this.in.getTermVectorsReader());
    }

    private TermVectorsReader newTermVectorsReader(final TermVectorsReader delegate) {
        return new TermVectorsReader(){

            @Override
            public Fields get(int doc) throws IOException {
                return delegate.get(SortingCodecReader.this.docMap.newToOld(doc));
            }

            @Override
            public void checkIntegrity() throws IOException {
                delegate.checkIntegrity();
            }

            @Override
            public TermVectorsReader clone() {
                return SortingCodecReader.this.newTermVectorsReader(delegate.clone());
            }

            @Override
            public void close() throws IOException {
                delegate.close();
            }
        };
    }

    public String toString() {
        return "SortingCodecReader(" + this.in + ")";
    }

    @Override
    public IndexReader.CacheHelper getCoreCacheHelper() {
        return null;
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return null;
    }

    @Override
    public LeafMetaData getMetaData() {
        return this.metaData;
    }

    private <T> T getOrCreateNorms(String field, IOSupplier<T> supplier) throws IOException {
        return this.getOrCreate(field, true, supplier);
    }

    private synchronized <T> T getOrCreate(String field, boolean norms, IOSupplier<T> supplier) throws IOException {
        if (!(field.equals(this.cachedField) && this.cacheIsNorms == norms)) {
            assert (this.assertCreatedOnlyOnce(field, norms));
            this.cachedObject = supplier.get();
            this.cachedField = field;
            this.cacheIsNorms = norms;
        }
        assert (this.cachedObject != null);
        return (T)this.cachedObject;
    }

    private boolean assertCreatedOnlyOnce(String field, boolean norms) {
        assert (Thread.holdsLock(this));
        Integer timesCached = this.cacheStats.compute(field + "N:" + norms, (s, i) -> i == null ? 1 : i + 1);
        if (timesCached > 1) {
            assert (!norms) : "[" + field + "] norms must not be cached twice";
            boolean isSortField = false;
            for (SortField sf : this.metaData.getSort().getSort()) {
                if (!field.equals(sf.getField())) continue;
                isSortField = true;
                break;
            }
            assert (timesCached == 2) : "[" + field + "] must not be cached more than twice but was cached: " + timesCached + " times isSortField: " + isSortField;
            assert (isSortField) : "only sort fields should be cached twice but [" + field + "] is not a sort field";
        }
        return true;
    }

    private <T> T getOrCreateDV(String field, IOSupplier<T> supplier) throws IOException {
        return this.getOrCreate(field, false, supplier);
    }

    private static class SortingBits
    implements Bits {
        private final Bits in;
        private final Sorter.DocMap docMap;

        SortingBits(Bits in, Sorter.DocMap docMap) {
            this.in = in;
            this.docMap = docMap;
        }

        @Override
        public boolean get(int index) {
            return this.in.get(this.docMap.newToOld(index));
        }

        @Override
        public int length() {
            return this.in.length();
        }
    }

    private static class SortingPointValues
    extends PointValues {
        private final PointValues in;
        private final Sorter.DocMap docMap;

        SortingPointValues(PointValues in, Sorter.DocMap docMap) {
            this.in = in;
            this.docMap = docMap;
        }

        @Override
        public void intersect(final PointValues.IntersectVisitor visitor) throws IOException {
            this.in.intersect(new PointValues.IntersectVisitor(){

                @Override
                public void visit(int docID) throws IOException {
                    visitor.visit(docMap.oldToNew(docID));
                }

                @Override
                public void visit(int docID, byte[] packedValue) throws IOException {
                    visitor.visit(docMap.oldToNew(docID), packedValue);
                }

                @Override
                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                    return visitor.compare(minPackedValue, maxPackedValue);
                }
            });
        }

        @Override
        public long estimatePointCount(PointValues.IntersectVisitor visitor) {
            return this.in.estimatePointCount(visitor);
        }

        @Override
        public byte[] getMinPackedValue() throws IOException {
            return this.in.getMinPackedValue();
        }

        @Override
        public byte[] getMaxPackedValue() throws IOException {
            return this.in.getMaxPackedValue();
        }

        @Override
        public int getNumDimensions() throws IOException {
            return this.in.getNumDimensions();
        }

        @Override
        public int getNumIndexDimensions() throws IOException {
            return this.in.getNumIndexDimensions();
        }

        @Override
        public int getBytesPerDimension() throws IOException {
            return this.in.getBytesPerDimension();
        }

        @Override
        public long size() {
            return this.in.size();
        }

        @Override
        public int getDocCount() {
            return this.in.getDocCount();
        }
    }
}

