/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.env.Environment;
import org.elasticsearch.ingest.geoip.DatabaseReaderLazyLoader;
import org.elasticsearch.ingest.geoip.GeoIpCache;
import org.elasticsearch.watcher.FileChangesListener;
import org.elasticsearch.watcher.FileWatcher;
import org.elasticsearch.watcher.ResourceWatcher;
import org.elasticsearch.watcher.ResourceWatcherService;

final class ConfigDatabases
implements Closeable {
    private static final Logger LOGGER = LogManager.getLogger(ConfigDatabases.class);
    private final GeoIpCache cache;
    private final Path geoipConfigDir;
    private final ConcurrentMap<String, DatabaseReaderLazyLoader> configDatabases;

    ConfigDatabases(Environment environment, GeoIpCache cache) {
        this(environment.configFile().resolve("ingest-geoip"), cache);
    }

    ConfigDatabases(Path geoipConfigDir, GeoIpCache cache) {
        this.cache = cache;
        this.geoipConfigDir = geoipConfigDir;
        this.configDatabases = new ConcurrentHashMap<String, DatabaseReaderLazyLoader>();
    }

    void initialize(ResourceWatcherService resourceWatcher) throws IOException {
        this.configDatabases.putAll(this.initConfigDatabases(this.geoipConfigDir));
        FileWatcher watcher = new FileWatcher(this.geoipConfigDir);
        watcher.addListener((Object)new GeoipDirectoryListener());
        resourceWatcher.add((ResourceWatcher)watcher, ResourceWatcherService.Frequency.HIGH);
        LOGGER.info("initialized config databases [{}] and watching [{}] for changes", this.configDatabases.keySet(), (Object)this.geoipConfigDir);
    }

    DatabaseReaderLazyLoader getDatabase(String name) {
        return (DatabaseReaderLazyLoader)this.configDatabases.get(name);
    }

    Map<String, DatabaseReaderLazyLoader> getConfigDatabases() {
        return this.configDatabases;
    }

    void updateDatabase(Path file, boolean update) {
        String databaseFileName = file.getFileName().toString();
        try {
            if (update) {
                LOGGER.info("database file changed [{}], reload database...", (Object)file);
                DatabaseReaderLazyLoader loader = new DatabaseReaderLazyLoader(this.cache, file, null);
                DatabaseReaderLazyLoader existing = this.configDatabases.put(databaseFileName, loader);
                if (existing != null) {
                    existing.close();
                }
            } else {
                LOGGER.info("database file removed [{}], close database...", (Object)file);
                DatabaseReaderLazyLoader existing = (DatabaseReaderLazyLoader)this.configDatabases.remove(databaseFileName);
                assert (existing != null);
                existing.close();
            }
        }
        catch (Exception e) {
            LOGGER.error(() -> new ParameterizedMessage("failed to update database [{}]", (Object)databaseFileName), (Throwable)e);
        }
    }

    Map<String, DatabaseReaderLazyLoader> initConfigDatabases(Path geoipConfigDir) throws IOException {
        HashMap<String, DatabaseReaderLazyLoader> databases = new HashMap<String, DatabaseReaderLazyLoader>();
        if (geoipConfigDir != null && Files.exists(geoipConfigDir, new LinkOption[0])) {
            try (Stream<Path> databaseFiles = Files.list(geoipConfigDir);){
                PathMatcher pathMatcher = geoipConfigDir.getFileSystem().getPathMatcher("glob:**.mmdb");
                Iterator iterator = databaseFiles.iterator();
                while (iterator.hasNext()) {
                    Path databasePath = (Path)iterator.next();
                    if (!Files.isRegularFile(databasePath, new LinkOption[0]) || !pathMatcher.matches(databasePath)) continue;
                    assert (Files.exists(databasePath, new LinkOption[0]));
                    String databaseFileName = databasePath.getFileName().toString();
                    DatabaseReaderLazyLoader loader = new DatabaseReaderLazyLoader(this.cache, databasePath, null);
                    databases.put(databaseFileName, loader);
                }
            }
        }
        return Collections.unmodifiableMap(databases);
    }

    @Override
    public void close() throws IOException {
        for (DatabaseReaderLazyLoader lazyLoader : this.configDatabases.values()) {
            lazyLoader.close();
        }
    }

    private class GeoipDirectoryListener
    implements FileChangesListener {
        private GeoipDirectoryListener() {
        }

        public void onFileCreated(Path file) {
            this.onFileChanged(file);
        }

        public void onFileDeleted(Path file) {
            PathMatcher pathMatcher = file.getFileSystem().getPathMatcher("glob:**.mmdb");
            if (pathMatcher.matches(file)) {
                ConfigDatabases.this.updateDatabase(file, false);
            }
        }

        public void onFileChanged(Path file) {
            PathMatcher pathMatcher = file.getFileSystem().getPathMatcher("glob:**.mmdb");
            if (pathMatcher.matches(file)) {
                ConfigDatabases.this.updateDatabase(file, true);
            }
        }
    }
}

