/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.geoip.DatabaseNodeService;
import org.elasticsearch.ingest.geoip.GeoIpCache;
import org.elasticsearch.ingest.geoip.GeoIpDownloader;
import org.elasticsearch.ingest.geoip.GeoIpDownloaderTaskExecutor;
import org.elasticsearch.ingest.geoip.GeoIpProcessor;
import org.elasticsearch.ingest.geoip.GeoIpTaskParams;
import org.elasticsearch.ingest.geoip.GeoIpTaskState;
import org.elasticsearch.ingest.geoip.HttpClient;
import org.elasticsearch.ingest.geoip.stats.GeoIpDownloaderStats;
import org.elasticsearch.ingest.geoip.stats.GeoIpDownloaderStatsAction;
import org.elasticsearch.ingest.geoip.stats.GeoIpDownloaderStatsTransportAction;
import org.elasticsearch.ingest.geoip.stats.RestGeoIpDownloaderStatsAction;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.IngestPlugin;
import org.elasticsearch.plugins.PersistentTaskPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SystemIndexPlugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;

public class IngestGeoIpPlugin
extends Plugin
implements IngestPlugin,
SystemIndexPlugin,
Closeable,
PersistentTaskPlugin,
ActionPlugin {
    public static final Setting<Long> CACHE_SIZE = Setting.longSetting((String)"ingest.geoip.cache_size", (long)1000L, (long)0L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static Set<String> DEFAULT_DATABASE_FILENAMES = Set.of("GeoLite2-ASN.mmdb", "GeoLite2-City.mmdb", "GeoLite2-Country.mmdb");
    private final SetOnce<IngestService> ingestService = new SetOnce();
    private final SetOnce<DatabaseNodeService> databaseRegistry = new SetOnce();
    private GeoIpDownloaderTaskExecutor geoIpDownloaderTaskExecutor;

    public List<Setting<?>> getSettings() {
        return Arrays.asList(CACHE_SIZE, GeoIpDownloader.ENDPOINT_SETTING, GeoIpDownloader.POLL_INTERVAL_SETTING, GeoIpDownloaderTaskExecutor.ENABLED_SETTING);
    }

    public Map<String, Processor.Factory> getProcessors(Processor.Parameters parameters) {
        this.ingestService.set((Object)parameters.ingestService);
        long cacheSize = (Long)CACHE_SIZE.get(parameters.env.settings());
        GeoIpCache geoIpCache = new GeoIpCache(cacheSize);
        DatabaseNodeService registry = new DatabaseNodeService(parameters.env, parameters.client, geoIpCache, parameters.genericExecutor);
        this.databaseRegistry.set((Object)registry);
        return Map.of("geoip", new GeoIpProcessor.Factory(registry, parameters.ingestService.getClusterService()));
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        try {
            String nodeId = nodeEnvironment.nodeId();
            ((DatabaseNodeService)this.databaseRegistry.get()).initialize(nodeId, resourceWatcherService, (IngestService)this.ingestService.get());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.geoIpDownloaderTaskExecutor = new GeoIpDownloaderTaskExecutor(client, new HttpClient(), clusterService, threadPool);
        return List.of(this.databaseRegistry.get(), this.geoIpDownloaderTaskExecutor);
    }

    @Override
    public void close() throws IOException {
        ((DatabaseNodeService)this.databaseRegistry.get()).close();
    }

    public List<PersistentTasksExecutor<?>> getPersistentTasksExecutor(ClusterService clusterService, ThreadPool threadPool, Client client, SettingsModule settingsModule, IndexNameExpressionResolver expressionResolver) {
        return List.of(this.geoIpDownloaderTaskExecutor);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return List.of(new ActionPlugin.ActionHandler((ActionType)GeoIpDownloaderStatsAction.INSTANCE, GeoIpDownloaderStatsTransportAction.class));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return List.of(new RestGeoIpDownloaderStatsAction());
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return List.of(new NamedXContentRegistry.Entry(PersistentTaskParams.class, new ParseField("geoip-downloader", new String[0]), GeoIpTaskParams::fromXContent), new NamedXContentRegistry.Entry(PersistentTaskState.class, new ParseField("geoip-downloader", new String[0]), GeoIpTaskState::fromXContent));
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return List.of(new NamedWriteableRegistry.Entry(PersistentTaskState.class, "geoip-downloader", GeoIpTaskState::new), new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "geoip-downloader", GeoIpTaskParams::new), new NamedWriteableRegistry.Entry(Task.Status.class, "geoip-downloader", GeoIpDownloaderStats::new));
    }

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
        SystemIndexDescriptor geoipDatabasesIndex = SystemIndexDescriptor.builder().setIndexPattern(".geoip_databases*").setDescription("GeoIP databases").setMappings(IngestGeoIpPlugin.mappings()).setSettings(Settings.builder().put("index.number_of_shards", 1).put("index.number_of_replicas", 0).put("index.auto_expand_replicas", "0-1").build()).setOrigin("ingest").setVersionMetaKey("version").setPrimaryIndex(".geoip_databases").setNetNew().build();
        return Collections.singleton(geoipDatabasesIndex);
    }

    public String getFeatureName() {
        return "geoip";
    }

    public String getFeatureDescription() {
        return "Manages data related to GeoIP database downloader";
    }

    private static XContentBuilder mappings() {
        try {
            return XContentFactory.jsonBuilder().startObject().startObject("_doc").startObject("_meta").field("version", (ToXContent)Version.CURRENT).endObject().field("dynamic", "strict").startObject("properties").startObject("name").field("type", "keyword").endObject().startObject("chunk").field("type", "integer").endObject().startObject("data").field("type", "binary").endObject().endObject().endObject().endObject();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to build mappings for .geoip_databases", e);
        }
    }
}

