/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup.rest;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.core.rollup.action.GetRollupIndexCapsAction;

public class RestGetRollupIndexCapsAction
extends BaseRestHandler {
    static final ParseField INDEX = new ParseField("index", new String[0]);

    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)"/{index}/_rollup/data").replaces(RestRequest.Method.GET, "/{index}/_xpack/rollup/data", RestApiVersion.V_7).build());
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) {
        String index = restRequest.param(INDEX.getPreferredName());
        IndicesOptions options = IndicesOptions.fromRequest((RestRequest)restRequest, (IndicesOptions)IndicesOptions.STRICT_EXPAND_OPEN_FORBID_CLOSED);
        GetRollupIndexCapsAction.Request request = new GetRollupIndexCapsAction.Request(Strings.splitStringByCommaToArray((String)index), options);
        return channel -> client.execute((ActionType)GetRollupIndexCapsAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }

    public String getName() {
        return "get_rollup_index_caps";
    }
}

