/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.predicate.regex;

import java.util.Objects;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.MinimizationOperations;
import org.elasticsearch.xpack.ql.expression.predicate.regex.AbstractStringPattern;
import org.elasticsearch.xpack.ql.util.StringUtils;

public class LikePattern
extends AbstractStringPattern {
    private final String pattern;
    private final char escape;
    private final String regex;
    private final String wildcard;
    private final String indexNameWildcard;

    public LikePattern(String pattern, char escape) {
        this.pattern = pattern;
        this.escape = escape;
        this.regex = StringUtils.likeToJavaPattern(pattern, escape);
        this.wildcard = StringUtils.likeToLuceneWildcard(pattern, escape);
        this.indexNameWildcard = StringUtils.likeToIndexWildcard(pattern, escape);
    }

    public String pattern() {
        return this.pattern;
    }

    public char escape() {
        return this.escape;
    }

    @Override
    Automaton createAutomaton() {
        Automaton automaton = WildcardQuery.toAutomaton((Term)new Term(null, this.wildcard));
        return MinimizationOperations.minimize((Automaton)automaton, (int)10000);
    }

    @Override
    public String asJavaRegex() {
        return this.regex;
    }

    public String asLuceneWildcard() {
        return this.wildcard;
    }

    public String asIndexNameWildcard() {
        return this.indexNameWildcard;
    }

    public int hashCode() {
        return Objects.hash(this.pattern, Character.valueOf(this.escape));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LikePattern other = (LikePattern)obj;
        return Objects.equals(this.pattern, other.pattern) && this.escape == other.escape;
    }
}

