/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.tasks.list;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.tasks.Task;

public class ListTasksRequest
extends BaseTasksRequest<ListTasksRequest> {
    public static final String[] ANY_DESCRIPTION = Strings.EMPTY_ARRAY;
    private boolean detailed = false;
    private boolean waitForCompletion = false;
    private String[] descriptions = ANY_DESCRIPTION;

    public ListTasksRequest() {
    }

    public ListTasksRequest(StreamInput in) throws IOException {
        super(in);
        this.detailed = in.readBoolean();
        this.waitForCompletion = in.readBoolean();
        if (in.getVersion().onOrAfter(Version.V_7_13_0)) {
            this.descriptions = in.readStringArray();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.detailed);
        out.writeBoolean(this.waitForCompletion);
        if (out.getVersion().onOrAfter(Version.V_7_13_0)) {
            out.writeStringArray(this.descriptions);
        }
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.descriptions.length > 0 && !this.detailed) {
            validationException = ValidateActions.addValidationError("matching on descriptions is not available when [detailed] is false", validationException);
        }
        return validationException;
    }

    @Override
    public boolean match(Task task) {
        return super.match(task) && (CollectionUtils.isEmpty(this.getDescriptions()) || Regex.simpleMatch(this.getDescriptions(), task.getDescription()));
    }

    public boolean getDetailed() {
        return this.detailed;
    }

    public ListTasksRequest setDetailed(boolean detailed) {
        this.detailed = detailed;
        return this;
    }

    public boolean getWaitForCompletion() {
        return this.waitForCompletion;
    }

    public ListTasksRequest setWaitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
        return this;
    }

    public String[] getDescriptions() {
        return this.descriptions;
    }

    public ListTasksRequest setDescriptions(String ... descriptions) {
        this.descriptions = descriptions;
        return this;
    }
}

