/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.get;

import java.io.IOException;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class MultiGetItemResponse
implements Writeable {
    private final GetResponse response;
    private final MultiGetResponse.Failure failure;

    public MultiGetItemResponse(GetResponse response, MultiGetResponse.Failure failure) {
        this.response = response;
        this.failure = failure;
    }

    MultiGetItemResponse(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            this.failure = new MultiGetResponse.Failure(in);
            this.response = null;
        } else {
            this.response = new GetResponse(in);
            this.failure = null;
        }
    }

    public String getIndex() {
        if (this.failure != null) {
            return this.failure.getIndex();
        }
        return this.response.getIndex();
    }

    public String getId() {
        if (this.failure != null) {
            return this.failure.getId();
        }
        return this.response.getId();
    }

    public boolean isFailed() {
        return this.failure != null;
    }

    public GetResponse getResponse() {
        return this.response;
    }

    public MultiGetResponse.Failure getFailure() {
        return this.failure;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.failure != null) {
            out.writeBoolean(true);
            this.failure.writeTo(out);
        } else {
            out.writeBoolean(false);
            this.response.writeTo(out);
        }
    }
}

