/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.ingest;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.ingest.Pipeline;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public class SimulatePipelineRequest
extends ActionRequest
implements ToXContentObject {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(SimulatePipelineRequest.class);
    private String id;
    private boolean verbose;
    private BytesReference source;
    private XContentType xContentType;
    private RestApiVersion restApiVersion;
    static final String SIMULATED_PIPELINE_ID = "_simulate_pipeline";

    public SimulatePipelineRequest(BytesReference source, XContentType xContentType) {
        this(source, xContentType, RestApiVersion.current());
    }

    public SimulatePipelineRequest(BytesReference source, XContentType xContentType, RestApiVersion restApiVersion) {
        this.source = Objects.requireNonNull(source);
        this.xContentType = Objects.requireNonNull(xContentType);
        this.restApiVersion = restApiVersion;
    }

    SimulatePipelineRequest() {
    }

    SimulatePipelineRequest(StreamInput in) throws IOException {
        super(in);
        this.id = in.readOptionalString();
        this.verbose = in.readBoolean();
        this.source = in.readBytesReference();
        this.xContentType = in.readEnum(XContentType.class);
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public BytesReference getSource() {
        return this.source;
    }

    public XContentType getXContentType() {
        return this.xContentType;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.id);
        out.writeBoolean(this.verbose);
        out.writeBytesReference(this.source);
        XContentHelper.writeTo(out, this.xContentType);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.rawValue((InputStream)this.source.streamInput(), this.xContentType);
        return builder;
    }

    static Parsed parseWithPipelineId(String pipelineId, Map<String, Object> config, boolean verbose, IngestService ingestService, RestApiVersion restApiVersion) {
        if (pipelineId == null) {
            throw new IllegalArgumentException("param [pipeline] is null");
        }
        Pipeline pipeline = ingestService.getPipeline(pipelineId);
        if (pipeline == null) {
            throw new IllegalArgumentException("pipeline [" + pipelineId + "] does not exist");
        }
        List<IngestDocument> ingestDocumentList = SimulatePipelineRequest.parseDocs(config, restApiVersion);
        return new Parsed(pipeline, ingestDocumentList, verbose);
    }

    static Parsed parse(Map<String, Object> config, boolean verbose, IngestService ingestService, RestApiVersion restApiVersion) throws Exception {
        Map<String, Object> pipelineConfig = ConfigurationUtils.readMap(null, null, config, "pipeline");
        Pipeline pipeline = Pipeline.create(SIMULATED_PIPELINE_ID, pipelineConfig, ingestService.getProcessorFactories(), ingestService.getScriptService());
        List<IngestDocument> ingestDocumentList = SimulatePipelineRequest.parseDocs(config, restApiVersion);
        return new Parsed(pipeline, ingestDocumentList, verbose);
    }

    private static List<IngestDocument> parseDocs(Map<String, Object> config, RestApiVersion restApiVersion) {
        List docs = ConfigurationUtils.readList(null, null, config, "docs");
        if (docs.isEmpty()) {
            throw new IllegalArgumentException("must specify at least one document in [docs]");
        }
        ArrayList<IngestDocument> ingestDocumentList = new ArrayList<IngestDocument>();
        for (Object object : docs) {
            if (!(object instanceof Map)) {
                throw new IllegalArgumentException("malformed [docs] section, should include an inner object");
            }
            Map dataMap = (Map)object;
            Map<String, Object> document = ConfigurationUtils.readMap(null, null, dataMap, "_source");
            String index = ConfigurationUtils.readStringOrIntProperty(null, null, dataMap, IngestDocument.Metadata.INDEX.getFieldName(), "_index");
            String id = ConfigurationUtils.readStringOrIntProperty(null, null, dataMap, IngestDocument.Metadata.ID.getFieldName(), "_id");
            String routing = ConfigurationUtils.readOptionalStringOrIntProperty(null, null, dataMap, IngestDocument.Metadata.ROUTING.getFieldName());
            if (restApiVersion == RestApiVersion.V_7 && dataMap.containsKey(IngestDocument.Metadata.TYPE.getFieldName())) {
                deprecationLogger.compatibleCritical("simulate_pipeline_with_types", "[types removal] specifying _type in pipeline simulation requests is deprecated", new Object[0]);
            }
            Long version = null;
            if (dataMap.containsKey(IngestDocument.Metadata.VERSION.getFieldName())) {
                String versionValue = ConfigurationUtils.readOptionalStringOrLongProperty(null, null, dataMap, IngestDocument.Metadata.VERSION.getFieldName());
                if (versionValue != null) {
                    version = Long.valueOf(versionValue);
                } else {
                    throw new IllegalArgumentException("[_version] cannot be null");
                }
            }
            VersionType versionType = null;
            if (dataMap.containsKey(IngestDocument.Metadata.VERSION_TYPE.getFieldName())) {
                versionType = VersionType.fromString(ConfigurationUtils.readStringProperty(null, null, dataMap, IngestDocument.Metadata.VERSION_TYPE.getFieldName()));
            }
            IngestDocument ingestDocument = new IngestDocument(index, id, routing, version, versionType, document);
            if (dataMap.containsKey(IngestDocument.Metadata.IF_SEQ_NO.getFieldName())) {
                String ifSeqNoValue = ConfigurationUtils.readOptionalStringOrLongProperty(null, null, dataMap, IngestDocument.Metadata.IF_SEQ_NO.getFieldName());
                if (ifSeqNoValue != null) {
                    Long ifSeqNo = Long.valueOf(ifSeqNoValue);
                    ingestDocument.setFieldValue(IngestDocument.Metadata.IF_SEQ_NO.getFieldName(), ifSeqNo);
                } else {
                    throw new IllegalArgumentException("[_if_seq_no] cannot be null");
                }
            }
            if (dataMap.containsKey(IngestDocument.Metadata.IF_PRIMARY_TERM.getFieldName())) {
                String ifPrimaryTermValue = ConfigurationUtils.readOptionalStringOrLongProperty(null, null, dataMap, IngestDocument.Metadata.IF_PRIMARY_TERM.getFieldName());
                if (ifPrimaryTermValue != null) {
                    Long ifPrimaryTerm = Long.valueOf(ifPrimaryTermValue);
                    ingestDocument.setFieldValue(IngestDocument.Metadata.IF_PRIMARY_TERM.getFieldName(), ifPrimaryTerm);
                } else {
                    throw new IllegalArgumentException("[_if_primary_term] cannot be null");
                }
            }
            if (dataMap.containsKey(IngestDocument.Metadata.DYNAMIC_TEMPLATES.getFieldName())) {
                Map dynamicTemplates = ConfigurationUtils.readMap(null, null, dataMap, IngestDocument.Metadata.DYNAMIC_TEMPLATES.getFieldName());
                if (dynamicTemplates != null) {
                    ingestDocument.setFieldValue(IngestDocument.Metadata.DYNAMIC_TEMPLATES.getFieldName(), new HashMap(dynamicTemplates));
                } else {
                    throw new IllegalArgumentException("[_dynamic_templates] cannot be null");
                }
            }
            ingestDocumentList.add(ingestDocument);
        }
        return ingestDocumentList;
    }

    public RestApiVersion getRestApiVersion() {
        return this.restApiVersion;
    }

    static class Parsed {
        private final List<IngestDocument> documents;
        private final Pipeline pipeline;
        private final boolean verbose;

        Parsed(Pipeline pipeline, List<IngestDocument> documents, boolean verbose) {
            this.pipeline = pipeline;
            this.documents = Collections.unmodifiableList(documents);
            this.verbose = verbose;
        }

        public Pipeline getPipeline() {
            return this.pipeline;
        }

        public List<IngestDocument> getDocuments() {
            return this.documents;
        }

        public boolean isVerbose() {
            return this.verbose;
        }
    }

    public static final class Fields {
        static final String PIPELINE = "pipeline";
        static final String DOCS = "docs";
        static final String SOURCE = "_source";
    }
}

