/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.elasticsearch.bootstrap.BootstrapException;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.env.Environment;

public class BootstrapUtil {
    private BootstrapUtil() {
    }

    public static SecureString readPassphrase(InputStream stream, int maxLength) throws IOException {
        SecureString passphrase;
        try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
            passphrase = new SecureString(Terminal.readLineToCharArray((Reader)reader, (int)maxLength));
        }
        catch (RuntimeException e) {
            if (e.getMessage().startsWith("Input exceeded maximum length")) {
                throw new IllegalStateException("Password exceeded maximum length of " + maxLength, e);
            }
            throw e;
        }
        if (passphrase.length() == 0) {
            passphrase.close();
            throw new IllegalStateException("Keystore passphrase required but none provided.");
        }
        return passphrase;
    }

    public static SecureSettings loadSecureSettings(Environment initialEnv) throws BootstrapException {
        return BootstrapUtil.loadSecureSettings(initialEnv, System.in);
    }

    public static SecureSettings loadSecureSettings(Environment initialEnv, InputStream stdin) throws BootstrapException {
        try {
            return KeyStoreWrapper.bootstrap(initialEnv.configFile(), () -> BootstrapUtil.readPassphrase(stdin, 128));
        }
        catch (Exception e) {
            throw new BootstrapException(e);
        }
    }
}

