/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.DiskUsage;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdSettings;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.monitor.fs.FsInfo;
import org.elasticsearch.threadpool.ThreadPool;

public class InternalClusterInfoService
implements ClusterInfoService,
ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(InternalClusterInfoService.class);
    public static final Setting<TimeValue> INTERNAL_CLUSTER_INFO_UPDATE_INTERVAL_SETTING = Setting.timeSetting("cluster.info.update.interval", TimeValue.timeValueSeconds((long)30L), TimeValue.timeValueSeconds((long)10L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> INTERNAL_CLUSTER_INFO_TIMEOUT_SETTING = Setting.positiveTimeSetting("cluster.info.update.timeout", TimeValue.timeValueSeconds((long)15L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile boolean enabled;
    private volatile TimeValue updateFrequency;
    private volatile TimeValue fetchTimeout;
    private volatile ImmutableOpenMap<String, DiskUsage> leastAvailableSpaceUsages;
    private volatile ImmutableOpenMap<String, DiskUsage> mostAvailableSpaceUsages;
    private volatile IndicesStatsSummary indicesStatsSummary;
    private final ThreadPool threadPool;
    private final Client client;
    private final List<Consumer<ClusterInfo>> listeners = new CopyOnWriteArrayList<Consumer<ClusterInfo>>();
    private final Object mutex = new Object();
    private final List<ActionListener<ClusterInfo>> nextRefreshListeners = new ArrayList<ActionListener<ClusterInfo>>();
    private AsyncRefresh currentRefresh;
    private RefreshScheduler refreshScheduler;

    public InternalClusterInfoService(Settings settings, ClusterService clusterService, ThreadPool threadPool, Client client) {
        this.leastAvailableSpaceUsages = ImmutableOpenMap.of();
        this.mostAvailableSpaceUsages = ImmutableOpenMap.of();
        this.indicesStatsSummary = IndicesStatsSummary.EMPTY;
        this.threadPool = threadPool;
        this.client = client;
        this.updateFrequency = INTERNAL_CLUSTER_INFO_UPDATE_INTERVAL_SETTING.get(settings);
        this.fetchTimeout = INTERNAL_CLUSTER_INFO_TIMEOUT_SETTING.get(settings);
        this.enabled = DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_THRESHOLD_ENABLED_SETTING.get(settings);
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        clusterSettings.addSettingsUpdateConsumer(INTERNAL_CLUSTER_INFO_TIMEOUT_SETTING, this::setFetchTimeout);
        clusterSettings.addSettingsUpdateConsumer(INTERNAL_CLUSTER_INFO_UPDATE_INTERVAL_SETTING, this::setUpdateFrequency);
        clusterSettings.addSettingsUpdateConsumer(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_THRESHOLD_ENABLED_SETTING, this::setEnabled);
    }

    private void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private void setFetchTimeout(TimeValue fetchTimeout) {
        this.fetchTimeout = fetchTimeout;
    }

    void setUpdateFrequency(TimeValue updateFrequency) {
        this.updateFrequency = updateFrequency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        Runnable newRefresh;
        Iterator<DiscoveryNode> iterator = this.mutex;
        synchronized (iterator) {
            if (!event.localNodeMaster()) {
                this.refreshScheduler = null;
                return;
            }
            if (this.refreshScheduler == null) {
                logger.trace("elected as master, scheduling cluster info update tasks");
                this.refreshScheduler = new RefreshScheduler();
                this.nextRefreshListeners.add(this.refreshScheduler.getListener());
            }
            newRefresh = this.getNewRefresh();
            assert (this.assertRefreshInvariant());
        }
        newRefresh.run();
        for (DiscoveryNode addedNode : event.nodesDelta().addedNodes()) {
            if (!addedNode.canContainData()) continue;
            this.refreshAsync(new PlainActionFuture<ClusterInfo>());
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRefreshComplete(AsyncRefresh completedRefresh) {
        Runnable newRefresh;
        Object object = this.mutex;
        synchronized (object) {
            assert (this.currentRefresh == completedRefresh);
            this.currentRefresh = null;
            newRefresh = this.getNewRefresh();
            assert (this.assertRefreshInvariant());
        }
        newRefresh.run();
    }

    private Runnable getNewRefresh() {
        assert (Thread.holdsLock(this.mutex)) : "mutex not held";
        if (this.currentRefresh != null) {
            return () -> {};
        }
        if (this.nextRefreshListeners.isEmpty()) {
            return () -> {};
        }
        ArrayList<ActionListener<ClusterInfo>> thisRefreshListeners = new ArrayList<ActionListener<ClusterInfo>>(this.nextRefreshListeners);
        this.nextRefreshListeners.clear();
        if (this.enabled) {
            this.currentRefresh = new AsyncRefresh(thisRefreshListeners);
            return this.currentRefresh::execute;
        }
        return () -> {
            this.leastAvailableSpaceUsages = ImmutableOpenMap.of();
            this.mostAvailableSpaceUsages = ImmutableOpenMap.of();
            this.indicesStatsSummary = IndicesStatsSummary.EMPTY;
            thisRefreshListeners.forEach(l -> l.onResponse(ClusterInfo.EMPTY));
        };
    }

    private boolean assertRefreshInvariant() {
        assert (Thread.holdsLock(this.mutex)) : "mutex not held";
        assert (this.nextRefreshListeners.isEmpty() || this.currentRefresh != null);
        return true;
    }

    @Override
    public ClusterInfo getClusterInfo() {
        IndicesStatsSummary indicesStatsSummary = this.indicesStatsSummary;
        return new ClusterInfo(this.leastAvailableSpaceUsages, this.mostAvailableSpaceUsages, indicesStatsSummary.shardSizes, indicesStatsSummary.shardDataSetSizes, indicesStatsSummary.shardRoutingToDataPath, indicesStatsSummary.reservedSpace);
    }

    List<NodeStats> adjustNodesStats(List<NodeStats> nodeStats) {
        return nodeStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshAsync(ActionListener<ClusterInfo> future) {
        Runnable newRefresh;
        Object object = this.mutex;
        synchronized (object) {
            this.nextRefreshListeners.add(future);
            newRefresh = this.getNewRefresh();
            assert (this.assertRefreshInvariant());
        }
        newRefresh.run();
    }

    @Override
    public void addListener(Consumer<ClusterInfo> clusterInfoConsumer) {
        this.listeners.add(clusterInfoConsumer);
    }

    static void buildShardLevelInfo(ShardStats[] stats, ImmutableOpenMap.Builder<String, Long> shardSizes, ImmutableOpenMap.Builder<ShardId, Long> shardDataSetSizeBuilder, ImmutableOpenMap.Builder<ShardRouting, String> newShardRoutingToDataPath, Map<ClusterInfo.NodeAndPath, ClusterInfo.ReservedSpace.Builder> reservedSpaceByShard) {
        for (ShardStats s : stats) {
            ShardRouting shardRouting = s.getShardRouting();
            newShardRoutingToDataPath.put(shardRouting, s.getDataPath());
            StoreStats storeStats = s.getStats().getStore();
            if (storeStats == null) continue;
            long size = storeStats.sizeInBytes();
            long dataSetSize = storeStats.totalDataSetSizeInBytes();
            long reserved = storeStats.getReservedSize().getBytes();
            String shardIdentifier = ClusterInfo.shardIdentifierFromRouting(shardRouting);
            logger.trace("shard: {} size: {} reserved: {}", (Object)shardIdentifier, (Object)size, (Object)reserved);
            shardSizes.put(shardIdentifier, size);
            if (dataSetSize > shardDataSetSizeBuilder.getOrDefault(shardRouting.shardId(), -1L)) {
                shardDataSetSizeBuilder.put(shardRouting.shardId(), dataSetSize);
            }
            if (reserved == -1L) continue;
            ClusterInfo.ReservedSpace.Builder reservedSpaceBuilder = reservedSpaceByShard.computeIfAbsent(new ClusterInfo.NodeAndPath(shardRouting.currentNodeId(), s.getDataPath()), t -> new ClusterInfo.ReservedSpace.Builder());
            reservedSpaceBuilder.add(shardRouting.shardId(), reserved);
        }
    }

    static void fillDiskUsagePerNode(List<NodeStats> nodeStatsArray, ImmutableOpenMap.Builder<String, DiskUsage> newLeastAvailableUsages, ImmutableOpenMap.Builder<String, DiskUsage> newMostAvailableUsages) {
        for (NodeStats nodeStats : nodeStatsArray) {
            if (nodeStats.getFs() == null) {
                logger.warn("node [{}/{}] did not return any filesystem stats", (Object)nodeStats.getNode().getName(), (Object)nodeStats.getNode().getId());
                continue;
            }
            FsInfo.Path leastAvailablePath = null;
            FsInfo.Path mostAvailablePath = null;
            for (FsInfo.Path info : nodeStats.getFs()) {
                if (leastAvailablePath == null) {
                    assert (mostAvailablePath == null);
                    mostAvailablePath = leastAvailablePath = info;
                    continue;
                }
                if (leastAvailablePath.getAvailable().getBytes() > info.getAvailable().getBytes()) {
                    leastAvailablePath = info;
                    continue;
                }
                if (mostAvailablePath.getAvailable().getBytes() >= info.getAvailable().getBytes()) continue;
                mostAvailablePath = info;
            }
            if (leastAvailablePath == null) {
                assert (mostAvailablePath == null);
                logger.warn("node [{}/{}] did not return any filesystem stats", (Object)nodeStats.getNode().getName(), (Object)nodeStats.getNode().getId());
                continue;
            }
            String nodeId = nodeStats.getNode().getId();
            String nodeName = nodeStats.getNode().getName();
            if (logger.isTraceEnabled()) {
                logger.trace("node [{}]: most available: total: {}, available: {} / least available: total: {}, available: {}", (Object)nodeId, (Object)mostAvailablePath.getTotal(), (Object)mostAvailablePath.getAvailable(), (Object)leastAvailablePath.getTotal(), (Object)leastAvailablePath.getAvailable());
            }
            if (leastAvailablePath.getTotal().getBytes() < 0L) {
                if (logger.isTraceEnabled()) {
                    logger.trace("node: [{}] least available path has less than 0 total bytes of disk [{}], skipping", (Object)nodeId, (Object)leastAvailablePath.getTotal().getBytes());
                }
            } else {
                newLeastAvailableUsages.put(nodeId, new DiskUsage(nodeId, nodeName, leastAvailablePath.getPath(), leastAvailablePath.getTotal().getBytes(), leastAvailablePath.getAvailable().getBytes()));
            }
            if (mostAvailablePath.getTotal().getBytes() < 0L) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace("node: [{}] most available path has less than 0 total bytes of disk [{}], skipping", (Object)nodeId, (Object)mostAvailablePath.getTotal().getBytes());
                continue;
            }
            newMostAvailableUsages.put(nodeId, new DiskUsage(nodeId, nodeName, mostAvailablePath.getPath(), mostAvailablePath.getTotal().getBytes(), mostAvailablePath.getAvailable().getBytes()));
        }
    }

    private static class IndicesStatsSummary {
        static final IndicesStatsSummary EMPTY = new IndicesStatsSummary(ImmutableOpenMap.of(), ImmutableOpenMap.of(), ImmutableOpenMap.of(), ImmutableOpenMap.of());
        final ImmutableOpenMap<String, Long> shardSizes;
        final ImmutableOpenMap<ShardId, Long> shardDataSetSizes;
        final ImmutableOpenMap<ShardRouting, String> shardRoutingToDataPath;
        final ImmutableOpenMap<ClusterInfo.NodeAndPath, ClusterInfo.ReservedSpace> reservedSpace;

        IndicesStatsSummary(ImmutableOpenMap<String, Long> shardSizes, ImmutableOpenMap<ShardId, Long> shardDataSetSizes, ImmutableOpenMap<ShardRouting, String> shardRoutingToDataPath, ImmutableOpenMap<ClusterInfo.NodeAndPath, ClusterInfo.ReservedSpace> reservedSpace) {
            this.shardSizes = shardSizes;
            this.shardDataSetSizes = shardDataSetSizes;
            this.shardRoutingToDataPath = shardRoutingToDataPath;
            this.reservedSpace = reservedSpace;
        }
    }

    private class RefreshScheduler {
        private RefreshScheduler() {
        }

        ActionListener<ClusterInfo> getListener() {
            return ActionListener.wrap(() -> {
                if (this.shouldRefresh()) {
                    InternalClusterInfoService.this.threadPool.scheduleUnlessShuttingDown(InternalClusterInfoService.this.updateFrequency, "same", () -> {
                        if (this.shouldRefresh()) {
                            InternalClusterInfoService.this.refreshAsync(this.getListener());
                        }
                    });
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean shouldRefresh() {
            Object object = InternalClusterInfoService.this.mutex;
            synchronized (object) {
                return InternalClusterInfoService.this.refreshScheduler == this;
            }
        }
    }

    private class AsyncRefresh {
        private final List<ActionListener<ClusterInfo>> thisRefreshListeners;
        private final CountDown countDown = new CountDown(2);

        AsyncRefresh(List<ActionListener<ClusterInfo>> thisRefreshListeners) {
            this.thisRefreshListeners = thisRefreshListeners;
        }

        void execute() {
            assert (!this.countDown.isCountedDown());
            logger.trace("starting async refresh");
            NodesStatsRequest nodesStatsRequest = new NodesStatsRequest("data:true");
            nodesStatsRequest.clear();
            nodesStatsRequest.addMetric(NodesStatsRequest.Metric.FS.metricName());
            nodesStatsRequest.timeout(InternalClusterInfoService.this.fetchTimeout);
            InternalClusterInfoService.this.client.admin().cluster().nodesStats(nodesStatsRequest, ActionListener.runAfter(new ActionListener<NodesStatsResponse>(){

                @Override
                public void onResponse(NodesStatsResponse nodesStatsResponse) {
                    logger.trace("received node stats response");
                    for (FailedNodeException failure : nodesStatsResponse.failures()) {
                        Throwable cause = failure.getCause();
                        if (logger.isDebugEnabled()) {
                            logger.warn((Message)new ParameterizedMessage("failed to retrieve stats for node [{}]", (Object)failure.nodeId()), cause);
                            continue;
                        }
                        logger.warn("failed to retrieve stats for node [{}]: {}", (Object)failure.nodeId(), (Object)cause.getMessage());
                    }
                    ImmutableOpenMap.Builder<String, DiskUsage> leastAvailableUsagesBuilder = ImmutableOpenMap.builder();
                    ImmutableOpenMap.Builder<String, DiskUsage> mostAvailableUsagesBuilder = ImmutableOpenMap.builder();
                    InternalClusterInfoService.fillDiskUsagePerNode(InternalClusterInfoService.this.adjustNodesStats(nodesStatsResponse.getNodes()), leastAvailableUsagesBuilder, mostAvailableUsagesBuilder);
                    InternalClusterInfoService.this.leastAvailableSpaceUsages = leastAvailableUsagesBuilder.build();
                    InternalClusterInfoService.this.mostAvailableSpaceUsages = mostAvailableUsagesBuilder.build();
                }

                @Override
                public void onFailure(Exception e) {
                    if (e instanceof ClusterBlockException) {
                        logger.trace("failed to retrieve node stats", (Throwable)e);
                    } else {
                        logger.warn("failed to retrieve node stats", (Throwable)e);
                    }
                    InternalClusterInfoService.this.leastAvailableSpaceUsages = ImmutableOpenMap.of();
                    InternalClusterInfoService.this.mostAvailableSpaceUsages = ImmutableOpenMap.of();
                }
            }, this::onStatsProcessed));
            IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
            indicesStatsRequest.clear();
            indicesStatsRequest.store(true);
            indicesStatsRequest.indicesOptions(IndicesOptions.STRICT_EXPAND_OPEN_CLOSED_HIDDEN);
            indicesStatsRequest.timeout(InternalClusterInfoService.this.fetchTimeout);
            InternalClusterInfoService.this.client.admin().indices().stats(indicesStatsRequest, ActionListener.runAfter(new ActionListener<IndicesStatsResponse>(){

                @Override
                public void onResponse(IndicesStatsResponse indicesStatsResponse) {
                    logger.trace("received indices stats response");
                    if (indicesStatsResponse.getShardFailures().length > 0) {
                        HashSet<String> failedNodeIds = new HashSet<String>();
                        for (DefaultShardOperationFailedException shardFailure : indicesStatsResponse.getShardFailures()) {
                            if (shardFailure.getCause() instanceof FailedNodeException) {
                                FailedNodeException failedNodeException = (FailedNodeException)shardFailure.getCause();
                                if (failedNodeIds.add(failedNodeException.nodeId())) {
                                    if (logger.isDebugEnabled()) {
                                        logger.warn((Message)new ParameterizedMessage("failed to retrieve shard stats from node [{}]", (Object)failedNodeException.nodeId()), (Throwable)failedNodeException);
                                    } else {
                                        logger.warn("failed to retrieve shard stats from node [{}]: {}", (Object)failedNodeException.nodeId(), (Object)failedNodeException.getCause().getMessage());
                                    }
                                }
                                logger.trace((Message)new ParameterizedMessage("failed to retrieve stats for shard [{}][{}]", (Object)shardFailure.index(), (Object)shardFailure.shardId()), shardFailure.getCause());
                                continue;
                            }
                            logger.warn((Message)new ParameterizedMessage("failed to retrieve stats for shard [{}][{}]", (Object)shardFailure.index(), (Object)shardFailure.shardId()), shardFailure.getCause());
                        }
                    }
                    ShardStats[] stats = indicesStatsResponse.getShards();
                    ImmutableOpenMap.Builder<String, Long> shardSizeByIdentifierBuilder = ImmutableOpenMap.builder();
                    ImmutableOpenMap.Builder<ShardId, Long> shardDataSetSizeBuilder = ImmutableOpenMap.builder();
                    ImmutableOpenMap.Builder<ShardRouting, String> dataPathByShardRoutingBuilder = ImmutableOpenMap.builder();
                    HashMap<ClusterInfo.NodeAndPath, ClusterInfo.ReservedSpace.Builder> reservedSpaceBuilders = new HashMap<ClusterInfo.NodeAndPath, ClusterInfo.ReservedSpace.Builder>();
                    InternalClusterInfoService.buildShardLevelInfo(stats, shardSizeByIdentifierBuilder, shardDataSetSizeBuilder, dataPathByShardRoutingBuilder, reservedSpaceBuilders);
                    ImmutableOpenMap.Builder rsrvdSpace = ImmutableOpenMap.builder();
                    reservedSpaceBuilders.forEach((nodeAndPath, builder) -> rsrvdSpace.put(nodeAndPath, builder.build()));
                    InternalClusterInfoService.this.indicesStatsSummary = new IndicesStatsSummary(shardSizeByIdentifierBuilder.build(), shardDataSetSizeBuilder.build(), dataPathByShardRoutingBuilder.build(), rsrvdSpace.build());
                }

                @Override
                public void onFailure(Exception e) {
                    if (e instanceof ClusterBlockException) {
                        logger.trace("failed to retrieve indices stats", (Throwable)e);
                    } else {
                        logger.warn("failed to retrieve indices stats", (Throwable)e);
                    }
                    InternalClusterInfoService.this.indicesStatsSummary = IndicesStatsSummary.EMPTY;
                }
            }, this::onStatsProcessed));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onStatsProcessed() {
            if (this.countDown.countDown()) {
                logger.trace("stats all received, computing cluster info and notifying listeners");
                try {
                    ClusterInfo clusterInfo = InternalClusterInfoService.this.getClusterInfo();
                    boolean anyListeners = false;
                    for (Consumer<ClusterInfo> consumer : InternalClusterInfoService.this.listeners) {
                        anyListeners = true;
                        try {
                            logger.trace("notifying [{}] of new cluster info", consumer);
                            consumer.accept(clusterInfo);
                        }
                        catch (Exception e) {
                            logger.info((Message)new ParameterizedMessage("failed to notify [{}] of new cluster info", consumer), (Throwable)e);
                        }
                    }
                    assert (anyListeners) : "expected to notify at least one listener";
                    for (ActionListener actionListener : this.thisRefreshListeners) {
                        actionListener.onResponse(clusterInfo);
                    }
                }
                finally {
                    InternalClusterInfoService.this.onRefreshComplete(this);
                }
            }
        }
    }
}

