/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Locale;
import joptsimple.OptionSet;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.coordination.CoordinationMetadata;
import org.elasticsearch.cluster.coordination.ElasticsearchNodeCommand;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.env.Environment;
import org.elasticsearch.gateway.PersistedClusterStateService;

public class UnsafeBootstrapMasterCommand
extends ElasticsearchNodeCommand {
    static final String CLUSTER_STATE_TERM_VERSION_MSG_FORMAT = "Current node cluster state (term, version) pair is (%s, %s)";
    static final String CONFIRMATION_MSG = "------------------------------------------------------------------------\n\nYou should only run this tool if you have permanently lost half or more\nof the master-eligible nodes in this cluster, and you cannot restore the\ncluster from a snapshot. This tool can cause arbitrary data loss and its\nuse should be your last resort. If you have multiple surviving master\neligible nodes, you should run this tool on the node with the highest\ncluster state (term, version) pair.\n\nDo you want to proceed?\n";
    static final String NOT_MASTER_NODE_MSG = "unsafe-bootstrap tool can only be run on master eligible node";
    static final String EMPTY_LAST_COMMITTED_VOTING_CONFIG_MSG = "last committed voting voting configuration is empty, cluster has never been bootstrapped?";
    static final String MASTER_NODE_BOOTSTRAPPED_MSG = "Master node was successfully bootstrapped";
    static final Setting<String> UNSAFE_BOOTSTRAP = ClusterService.USER_DEFINED_METADATA.getConcreteSetting("cluster.metadata.unsafe-bootstrap");

    UnsafeBootstrapMasterCommand() {
        super("Forces the successful election of the current node after the permanent loss of the half or more master-eligible nodes");
    }

    @Override
    protected boolean validateBeforeLock(Terminal terminal, Environment env) {
        Settings settings = env.settings();
        terminal.println(Terminal.Verbosity.VERBOSE, (CharSequence)"Checking node.master setting");
        Boolean master = DiscoveryNode.isMasterNode(settings);
        if (!master.booleanValue()) {
            throw new ElasticsearchException(NOT_MASTER_NODE_MSG, new Object[0]);
        }
        return true;
    }

    @Override
    protected void processNodePaths(Terminal terminal, Path[] dataPaths, OptionSet options, Environment env) throws IOException {
        PersistedClusterStateService persistedClusterStateService = UnsafeBootstrapMasterCommand.createPersistedClusterStateService(env.settings(), dataPaths);
        Tuple<Long, ClusterState> state = UnsafeBootstrapMasterCommand.loadTermAndClusterState(persistedClusterStateService, env);
        ClusterState oldClusterState = (ClusterState)state.v2();
        Metadata metadata = oldClusterState.metadata();
        CoordinationMetadata coordinationMetadata = metadata.coordinationMetadata();
        if (coordinationMetadata == null || coordinationMetadata.getLastCommittedConfiguration() == null || coordinationMetadata.getLastCommittedConfiguration().isEmpty()) {
            throw new ElasticsearchException(EMPTY_LAST_COMMITTED_VOTING_CONFIG_MSG, new Object[0]);
        }
        terminal.println((CharSequence)String.format(Locale.ROOT, CLUSTER_STATE_TERM_VERSION_MSG_FORMAT, coordinationMetadata.term(), metadata.version()));
        CoordinationMetadata newCoordinationMetadata = CoordinationMetadata.builder(coordinationMetadata).clearVotingConfigExclusions().lastAcceptedConfiguration(new CoordinationMetadata.VotingConfiguration(Collections.singleton(persistedClusterStateService.getNodeId()))).lastCommittedConfiguration(new CoordinationMetadata.VotingConfiguration(Collections.singleton(persistedClusterStateService.getNodeId()))).build();
        Settings persistentSettings = Settings.builder().put(metadata.persistentSettings()).put(UNSAFE_BOOTSTRAP.getKey(), true).build();
        Metadata.Builder newMetadata = Metadata.builder(metadata).clusterUUID("_na_").generateClusterUuidIfNeeded().clusterUUIDCommitted(true).persistentSettings(persistentSettings).coordinationMetadata(newCoordinationMetadata);
        for (IndexMetadata indexMetadata : metadata.indices().values()) {
            newMetadata.put(IndexMetadata.builder(indexMetadata).settings(Settings.builder().put(indexMetadata.getSettings()).put("index.history.uuid", UUIDs.randomBase64UUID())));
        }
        ClusterState newClusterState = ClusterState.builder(oldClusterState).metadata(newMetadata).build();
        terminal.println(Terminal.Verbosity.VERBOSE, (CharSequence)("[old cluster state = " + oldClusterState + ", new cluster state = " + newClusterState + "]"));
        this.confirm(terminal, CONFIRMATION_MSG);
        try (PersistedClusterStateService.Writer writer = persistedClusterStateService.createWriter();){
            writer.writeFullStateAndCommit((Long)state.v1(), newClusterState);
        }
        terminal.println((CharSequence)MASTER_NODE_BOOTSTRAPPED_MSG);
    }
}

