/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;

public class AliasMetadata
extends AbstractDiffable<AliasMetadata>
implements ToXContentFragment {
    private final String alias;
    private final CompressedXContent filter;
    private final String indexRouting;
    private final String searchRouting;
    private final Set<String> searchRoutingValues;
    @Nullable
    private final Boolean writeIndex;
    @Nullable
    private final Boolean isHidden;

    private AliasMetadata(String alias, CompressedXContent filter, String indexRouting, String searchRouting, Boolean writeIndex, @Nullable Boolean isHidden) {
        this.alias = alias;
        this.filter = filter;
        this.indexRouting = indexRouting;
        this.searchRouting = searchRouting;
        this.searchRoutingValues = searchRouting != null ? Collections.unmodifiableSet(Sets.newHashSet(Strings.splitStringByCommaToArray(searchRouting))) : Collections.emptySet();
        this.writeIndex = writeIndex;
        this.isHidden = isHidden;
    }

    private AliasMetadata(AliasMetadata aliasMetadata, String alias) {
        this(alias, aliasMetadata.filter(), aliasMetadata.indexRouting(), aliasMetadata.searchRouting(), aliasMetadata.writeIndex(), aliasMetadata.isHidden);
    }

    public String alias() {
        return this.alias;
    }

    public String getAlias() {
        return this.alias();
    }

    public CompressedXContent filter() {
        return this.filter;
    }

    public CompressedXContent getFilter() {
        return this.filter();
    }

    public boolean filteringRequired() {
        return this.filter != null;
    }

    public String getSearchRouting() {
        return this.searchRouting();
    }

    public String searchRouting() {
        return this.searchRouting;
    }

    public String getIndexRouting() {
        return this.indexRouting();
    }

    public String indexRouting() {
        return this.indexRouting;
    }

    public Set<String> searchRoutingValues() {
        return this.searchRoutingValues;
    }

    public Boolean writeIndex() {
        return this.writeIndex;
    }

    @Nullable
    public Boolean isHidden() {
        return this.isHidden;
    }

    public static Builder builder(String alias) {
        return new Builder(alias);
    }

    public static Builder newAliasMetadataBuilder(String alias) {
        return new Builder(alias);
    }

    public static AliasMetadata newAliasMetadata(AliasMetadata aliasMetadata, String newAlias) {
        return new AliasMetadata(aliasMetadata, newAlias);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AliasMetadata that = (AliasMetadata)o;
        if (!Objects.equals(this.alias, that.alias)) {
            return false;
        }
        if (!Objects.equals(this.filter, that.filter)) {
            return false;
        }
        if (!Objects.equals(this.indexRouting, that.indexRouting)) {
            return false;
        }
        if (!Objects.equals(this.searchRouting, that.searchRouting)) {
            return false;
        }
        if (!Objects.equals(this.writeIndex, that.writeIndex)) {
            return false;
        }
        return Objects.equals(this.isHidden, that.isHidden);
    }

    public int hashCode() {
        int result = this.alias != null ? this.alias.hashCode() : 0;
        result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
        result = 31 * result + (this.indexRouting != null ? this.indexRouting.hashCode() : 0);
        result = 31 * result + (this.searchRouting != null ? this.searchRouting.hashCode() : 0);
        result = 31 * result + (this.writeIndex != null ? this.writeIndex.hashCode() : 0);
        return result;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.alias());
        if (this.filter() != null) {
            out.writeBoolean(true);
            this.filter.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.indexRouting() != null) {
            out.writeBoolean(true);
            out.writeString(this.indexRouting());
        } else {
            out.writeBoolean(false);
        }
        if (this.searchRouting() != null) {
            out.writeBoolean(true);
            out.writeString(this.searchRouting());
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalBoolean(this.writeIndex());
        out.writeOptionalBoolean(this.isHidden);
    }

    public AliasMetadata(StreamInput in) throws IOException {
        this.alias = in.readString();
        this.filter = in.readBoolean() ? CompressedXContent.readCompressedString(in) : null;
        this.indexRouting = in.readBoolean() ? in.readString() : null;
        if (in.readBoolean()) {
            this.searchRouting = in.readString();
            this.searchRoutingValues = Collections.unmodifiableSet(Sets.newHashSet(Strings.splitStringByCommaToArray(this.searchRouting)));
        } else {
            this.searchRouting = null;
            this.searchRoutingValues = Collections.emptySet();
        }
        this.writeIndex = in.readOptionalBoolean();
        this.isHidden = in.readOptionalBoolean();
    }

    public static Diff<AliasMetadata> readDiffFrom(StreamInput in) throws IOException {
        return AliasMetadata.readDiffFrom(AliasMetadata::new, in);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, true, true);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Builder.toXContent(this, builder, params);
        return builder;
    }

    public static AliasMetadata getFirstAliasMetadata(Metadata metadata, IndexAbstraction ia) {
        if (ia.getType() != IndexAbstraction.Type.ALIAS) {
            throw new IllegalArgumentException("unexpected type: [" + ia.getType() + "]");
        }
        IndexMetadata firstIndex = metadata.index(ia.getIndices().get(0));
        return firstIndex.getAliases().get(ia.getName());
    }

    public static class Builder {
        private final String alias;
        private CompressedXContent filter;
        private String indexRouting;
        private String searchRouting;
        @Nullable
        private Boolean writeIndex;
        @Nullable
        private Boolean isHidden;

        public Builder(String alias) {
            this.alias = alias;
        }

        public String alias() {
            return this.alias;
        }

        public Builder filter(CompressedXContent filter) {
            this.filter = filter;
            return this;
        }

        public Builder filter(String filter) {
            if (!Strings.hasLength(filter)) {
                this.filter = null;
                return this;
            }
            return this.filter(XContentHelper.convertToMap(XContentFactory.xContent((CharSequence)filter), filter, true));
        }

        public Builder filter(Map<String, Object> filter) {
            if (filter == null || filter.isEmpty()) {
                this.filter = null;
                return this;
            }
            try {
                XContentBuilder builder = XContentFactory.jsonBuilder().map(filter);
                this.filter = new CompressedXContent(BytesReference.bytes(builder));
                return this;
            }
            catch (IOException e) {
                throw new ElasticsearchGenerationException("Failed to build json for alias request", e);
            }
        }

        public Builder routing(String routing) {
            this.indexRouting = routing;
            this.searchRouting = routing;
            return this;
        }

        public Builder indexRouting(String indexRouting) {
            this.indexRouting = indexRouting;
            return this;
        }

        public Builder searchRouting(String searchRouting) {
            this.searchRouting = searchRouting;
            return this;
        }

        public Builder writeIndex(@Nullable Boolean writeIndex) {
            this.writeIndex = writeIndex;
            return this;
        }

        public Builder isHidden(@Nullable Boolean isHidden) {
            this.isHidden = isHidden;
            return this;
        }

        public AliasMetadata build() {
            return new AliasMetadata(this.alias, this.filter, this.indexRouting, this.searchRouting, this.writeIndex, this.isHidden);
        }

        public static void toXContent(AliasMetadata aliasMetadata, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(aliasMetadata.alias());
            boolean binary = params.paramAsBoolean("binary", false);
            if (aliasMetadata.filter() != null) {
                if (binary) {
                    builder.field("filter", aliasMetadata.filter.compressed());
                } else {
                    builder.field("filter", (Map)XContentHelper.convertToMap(aliasMetadata.filter().uncompressed(), true).v2());
                }
            }
            if (aliasMetadata.indexRouting() != null) {
                builder.field("index_routing", aliasMetadata.indexRouting());
            }
            if (aliasMetadata.searchRouting() != null) {
                builder.field("search_routing", aliasMetadata.searchRouting());
            }
            if (aliasMetadata.writeIndex() != null) {
                builder.field("is_write_index", aliasMetadata.writeIndex());
            }
            if (aliasMetadata.isHidden != null) {
                builder.field("is_hidden", aliasMetadata.isHidden());
            }
            builder.endObject();
        }

        public static AliasMetadata fromXContent(XContentParser parser) throws IOException {
            Builder builder = new Builder(parser.currentName());
            String currentFieldName = null;
            XContentParser.Token token = parser.nextToken();
            if (token == null) {
                return builder.build();
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("filter".equals(currentFieldName)) {
                        Map filter = parser.mapOrdered();
                        builder.filter(filter);
                        continue;
                    }
                    parser.skipChildren();
                    continue;
                }
                if (token == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
                    if (!"filter".equals(currentFieldName)) continue;
                    builder.filter(new CompressedXContent(parser.binaryValue()));
                    continue;
                }
                if (token == XContentParser.Token.VALUE_STRING) {
                    if ("routing".equals(currentFieldName)) {
                        builder.routing(parser.text());
                        continue;
                    }
                    if ("index_routing".equals(currentFieldName) || "indexRouting".equals(currentFieldName)) {
                        builder.indexRouting(parser.text());
                        continue;
                    }
                    if ("search_routing".equals(currentFieldName) || "searchRouting".equals(currentFieldName)) {
                        builder.searchRouting(parser.text());
                        continue;
                    }
                    if (!"filter".equals(currentFieldName)) continue;
                    builder.filter(new CompressedXContent(parser.binaryValue()));
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    parser.skipChildren();
                    continue;
                }
                if (token != XContentParser.Token.VALUE_BOOLEAN) continue;
                if ("is_write_index".equals(currentFieldName)) {
                    builder.writeIndex(parser.booleanValue());
                    continue;
                }
                if (!"is_hidden".equals(currentFieldName)) continue;
                builder.isHidden(parser.booleanValue());
            }
            return builder.build();
        }
    }
}

