/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.hash;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.hash.MurmurHash3;

public class Murmur3Hasher {
    public static final String METHOD = "MurmurHash3";
    private final long seed;
    private final byte[] remainder = new byte[16];
    private int remainderLength = 0;
    private int length;
    private long h1;
    private long h2;

    public Murmur3Hasher(long seed) {
        this.seed = seed;
        this.h1 = this.h2 = seed;
    }

    public void update(byte[] inputBytes) {
        int totalLength = this.remainderLength + inputBytes.length;
        if (totalLength >= 16) {
            byte[] bytesToHash;
            int numBytesToHash = totalLength & 0xFFFFFFF0;
            if (this.remainderLength > 0) {
                bytesToHash = new byte[numBytesToHash];
                System.arraycopy(this.remainder, 0, bytesToHash, 0, this.remainderLength);
                System.arraycopy(inputBytes, 0, bytesToHash, this.remainderLength, numBytesToHash - this.remainderLength);
            } else {
                bytesToHash = inputBytes;
            }
            MurmurHash3.IntermediateResult result = MurmurHash3.intermediateHash(bytesToHash, 0, numBytesToHash, this.h1, this.h2);
            this.h1 = result.h1;
            this.h2 = result.h2;
            this.length += numBytesToHash;
            if (totalLength > numBytesToHash) {
                System.arraycopy(inputBytes, numBytesToHash - this.remainderLength, this.remainder, 0, totalLength - numBytesToHash);
                this.remainderLength = totalLength - numBytesToHash;
            } else {
                this.remainderLength = 0;
            }
        } else {
            System.arraycopy(inputBytes, 0, this.remainder, this.remainderLength, inputBytes.length);
            this.remainderLength += inputBytes.length;
        }
    }

    public void reset() {
        this.length = 0;
        this.remainderLength = 0;
        this.h1 = this.h2 = this.seed;
    }

    public byte[] digest() {
        this.length += this.remainderLength;
        MurmurHash3.Hash128 h = MurmurHash3.finalizeHash(new MurmurHash3.Hash128(), this.remainder, 0, this.length, this.h1, this.h2);
        byte[] hash = new byte[16];
        System.arraycopy(Numbers.longToBytes(h.h1), 0, hash, 0, 8);
        System.arraycopy(Numbers.longToBytes(h.h2), 0, hash, 8, 8);
        return hash;
    }

    public String getAlgorithm() {
        return METHOD;
    }

    public static MurmurHash3.Hash128 toHash128(byte[] doubleLongBytes) {
        MurmurHash3.Hash128 hash128 = new MurmurHash3.Hash128();
        hash128.h1 = Numbers.bytesToLong(new BytesRef(doubleLongBytes, 0, 8));
        hash128.h2 = Numbers.bytesToLong(new BytesRef(doubleLongBytes, 8, 8));
        return hash128;
    }
}

