/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.EOFException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.elasticsearch.common.io.stream.StreamInput;

public class ByteBufferStreamInput
extends StreamInput {
    private final ByteBuffer buffer;

    public ByteBufferStreamInput(ByteBuffer buffer) {
        this.buffer = buffer.mark();
    }

    @Override
    public int read() throws IOException {
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public byte readByte() throws IOException {
        try {
            return this.buffer.get();
        }
        catch (BufferUnderflowException ex) {
            throw this.newEOFException(ex);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        len = Math.min(len, this.buffer.remaining());
        this.buffer.get(b, off, len);
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        int remaining = this.buffer.remaining();
        if (n > (long)remaining) {
            this.buffer.position(this.buffer.limit());
            return remaining;
        }
        this.buffer.position((int)((long)this.buffer.position() + n));
        return n;
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        try {
            this.buffer.get(b, offset, len);
        }
        catch (BufferUnderflowException ex) {
            throw this.newEOFException(ex);
        }
    }

    @Override
    public short readShort() throws IOException {
        try {
            return this.buffer.getShort();
        }
        catch (BufferUnderflowException ex) {
            throw this.newEOFException(ex);
        }
    }

    @Override
    public int readInt() throws IOException {
        try {
            return this.buffer.getInt();
        }
        catch (BufferUnderflowException ex) {
            throw this.newEOFException(ex);
        }
    }

    @Override
    public long readLong() throws IOException {
        try {
            return this.buffer.getLong();
        }
        catch (BufferUnderflowException ex) {
            throw this.newEOFException(ex);
        }
    }

    private EOFException newEOFException(RuntimeException ex) {
        EOFException eofException = new EOFException();
        eofException.initCause(ex);
        return eofException;
    }

    @Override
    public void reset() throws IOException {
        this.buffer.reset();
    }

    @Override
    public int available() throws IOException {
        return this.buffer.remaining();
    }

    @Override
    protected void ensureCanReadBytes(int length) throws EOFException {
        if (this.buffer.remaining() < length) {
            throw new EOFException("tried to read: " + length + " bytes but only " + this.buffer.remaining() + " remaining");
        }
    }

    @Override
    public void mark(int readlimit) {
        this.buffer.mark();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }
}

