/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.FormattedDocValues;
import org.elasticsearch.index.fielddata.LeafNumericFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.script.field.DelegateDocValuesField;
import org.elasticsearch.script.field.DocValuesField;
import org.elasticsearch.search.DocValueFormat;

public abstract class LeafDoubleFieldData
implements LeafNumericFieldData {
    private final long ramBytesUsed;

    protected LeafDoubleFieldData(long ramBytesUsed) {
        this.ramBytesUsed = ramBytesUsed;
    }

    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    @Override
    public final DocValuesField getScriptField(String name) {
        return new DelegateDocValuesField(new ScriptDocValues.Doubles(this.getDoubleValues()), name);
    }

    @Override
    public final SortedBinaryDocValues getBytesValues() {
        return FieldData.toString(this.getDoubleValues());
    }

    @Override
    public final SortedNumericDocValues getLongValues() {
        return FieldData.castToLong(this.getDoubleValues());
    }

    public static LeafNumericFieldData empty(int maxDoc) {
        return new LeafDoubleFieldData(0L){

            @Override
            public SortedNumericDoubleValues getDoubleValues() {
                return FieldData.emptySortedNumericDoubles();
            }

            public Collection<Accountable> getChildResources() {
                return Collections.emptyList();
            }
        };
    }

    @Override
    public FormattedDocValues getFormattedValues(final DocValueFormat format) {
        final SortedNumericDoubleValues values = this.getDoubleValues();
        return new FormattedDocValues(){

            @Override
            public boolean advanceExact(int docId) throws IOException {
                return values.advanceExact(docId);
            }

            @Override
            public int docValueCount() throws IOException {
                return values.docValueCount();
            }

            @Override
            public Object nextValue() throws IOException {
                return format.format(values.nextValue());
            }
        };
    }

    public void close() {
    }
}

