/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryRequest;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.repositories.RepositoryConflictException;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;

public class RestPutRepositoryAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_snapshot/{repository}"), new RestHandler.Route(RestRequest.Method.PUT, "/_snapshot/{repository}"));
    }

    @Override
    public String getName() {
        return "put_repository_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        PutRepositoryRequest putRepositoryRequest = Requests.putRepositoryRequest(request.param("repository"));
        try (XContentParser parser = request.contentParser();){
            putRepositoryRequest.source(parser.mapOrdered());
        }
        putRepositoryRequest.verify(request.paramAsBoolean("verify", true));
        putRepositoryRequest.masterNodeTimeout(request.paramAsTime("master_timeout", putRepositoryRequest.masterNodeTimeout()));
        putRepositoryRequest.timeout(request.paramAsTime("timeout", putRepositoryRequest.timeout()));
        return channel -> client.admin().cluster().putRepository(putRepositoryRequest, new RestToXContentListener((RestChannel)channel).delegateResponse((delegate, err) -> {
            if (request.getRestApiVersion().equals((Object)RestApiVersion.V_7) && err instanceof RepositoryConflictException) {
                delegate.onFailure(new IllegalStateException(((RepositoryConflictException)err).getBackwardCompatibleMessage()));
            } else {
                delegate.onFailure((Exception)err);
            }
        }));
    }
}

