/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.util.List;
import java.util.function.BiFunction;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.KeyComparable;

public final class DelayedBucket<B extends InternalMultiBucketAggregation.InternalBucket> {
    private final BiFunction<List<B>, InternalAggregation.ReduceContext, B> reduce;
    private final InternalAggregation.ReduceContext reduceContext;
    private List<B> toReduce;
    private B reduced;
    private long docCount = -1L;

    public DelayedBucket(BiFunction<List<B>, InternalAggregation.ReduceContext, B> reduce, InternalAggregation.ReduceContext reduceContext, List<B> toReduce) {
        this.reduce = reduce;
        this.reduceContext = reduceContext;
        this.toReduce = toReduce;
    }

    public B reduced() {
        if (this.reduced == null) {
            this.reduceContext.consumeBucketsAndMaybeBreak(1);
            this.reduced = (InternalMultiBucketAggregation.InternalBucket)this.reduce.apply(this.toReduce, this.reduceContext);
            this.toReduce = null;
        }
        return this.reduced;
    }

    public long getDocCount() {
        if (this.docCount < 0L) {
            if (this.reduced == null) {
                this.docCount = 0L;
                for (InternalMultiBucketAggregation.InternalBucket bucket : this.toReduce) {
                    this.docCount += bucket.getDocCount();
                }
            } else {
                this.docCount = this.reduced.getDocCount();
            }
        }
        return this.docCount;
    }

    int compareKey(DelayedBucket<?> rhs) {
        return ((KeyComparable)this.representativeBucket()).compareKey(rhs.representativeBucket());
    }

    private B representativeBucket() {
        return (B)(this.reduced == null ? (InternalMultiBucketAggregation.InternalBucket)this.toReduce.get(0) : this.reduced);
    }

    public String toString() {
        return "Delayed[" + this.representativeBucket().getKeyAsString() + "]";
    }

    void nonCompetitive() {
        if (this.reduced != null) {
            this.reduceContext.consumeBucketsAndMaybeBreak(-1 - InternalMultiBucketAggregation.countInnerBucket(this.reduced));
        }
    }
}

