/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.IndexCommit;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ResultDeduplicator;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.seqno.SequenceNumbers;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardSnapshotFailedException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryShardId;
import org.elasticsearch.repositories.ShardGeneration;
import org.elasticsearch.repositories.ShardGenerations;
import org.elasticsearch.repositories.ShardSnapshotResult;
import org.elasticsearch.repositories.SnapshotShardContext;
import org.elasticsearch.snapshots.AbortedSnapshotException;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.snapshots.UpdateIndexShardSnapshotStatusRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class SnapshotShardsService
extends AbstractLifecycleComponent
implements ClusterStateListener,
IndexEventListener {
    private static final Logger logger = LogManager.getLogger(SnapshotShardsService.class);
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final RepositoriesService repositoriesService;
    private final TransportService transportService;
    private final ThreadPool threadPool;
    private final Map<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> shardSnapshots = new HashMap<Snapshot, Map<ShardId, IndexShardSnapshotStatus>>();
    private final ResultDeduplicator<UpdateIndexShardSnapshotStatusRequest, Void> remoteFailedRequestDeduplicator = new ResultDeduplicator();

    public SnapshotShardsService(Settings settings, ClusterService clusterService, RepositoriesService repositoriesService, TransportService transportService, IndicesService indicesService) {
        this.indicesService = indicesService;
        this.repositoriesService = repositoriesService;
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.threadPool = transportService.getThreadPool();
        if (DiscoveryNode.canContainData(settings)) {
            clusterService.addListener(this);
        }
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() {
        this.clusterService.removeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        try {
            SnapshotsInProgress previousSnapshots = event.previousState().custom("snapshots", SnapshotsInProgress.EMPTY);
            SnapshotsInProgress currentSnapshots = event.state().custom("snapshots", SnapshotsInProgress.EMPTY);
            if (!previousSnapshots.equals(currentSnapshots)) {
                Map<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> map = this.shardSnapshots;
                synchronized (map) {
                    this.cancelRemoved(currentSnapshots);
                    for (List<SnapshotsInProgress.Entry> snapshots : currentSnapshots.entriesByRepo()) {
                        this.startNewSnapshots(snapshots);
                    }
                }
            }
            String previousMasterNodeId = event.previousState().nodes().getMasterNodeId();
            String currentMasterNodeId = event.state().nodes().getMasterNodeId();
            if (currentMasterNodeId != null && !currentMasterNodeId.equals(previousMasterNodeId)) {
                this.remoteFailedRequestDeduplicator.clear();
                for (List<SnapshotsInProgress.Entry> snapshots : currentSnapshots.entriesByRepo()) {
                    this.syncShardStatsOnNewMaster(snapshots);
                }
            }
        }
        catch (Exception e) {
            assert (false) : new AssertionError((Object)e);
            logger.warn("failed to update snapshot state", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
        Map<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> map = this.shardSnapshots;
        synchronized (map) {
            for (Map.Entry<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> snapshotShards : this.shardSnapshots.entrySet()) {
                Map<ShardId, IndexShardSnapshotStatus> shards = snapshotShards.getValue();
                if (!shards.containsKey(shardId)) continue;
                logger.debug("[{}] shard closing, abort snapshotting for snapshot [{}]", (Object)shardId, (Object)snapshotShards.getKey().getSnapshotId());
                shards.get(shardId).abortIfNotCompleted("shard is closing, aborting");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ShardId, IndexShardSnapshotStatus> currentSnapshotShards(Snapshot snapshot) {
        Map<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> map = this.shardSnapshots;
        synchronized (map) {
            Map<ShardId, IndexShardSnapshotStatus> current = this.shardSnapshots.get(snapshot);
            return current == null ? null : new HashMap<ShardId, IndexShardSnapshotStatus>(current);
        }
    }

    private void cancelRemoved(SnapshotsInProgress snapshotsInProgress) {
        Iterator<Map.Entry<Snapshot, Map<ShardId, IndexShardSnapshotStatus>>> it = this.shardSnapshots.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> entry = it.next();
            Snapshot snapshot = entry.getKey();
            if (snapshotsInProgress.snapshot(snapshot) != null) continue;
            it.remove();
            for (IndexShardSnapshotStatus snapshotStatus : entry.getValue().values()) {
                snapshotStatus.abortIfNotCompleted("snapshot has been removed in cluster state, aborting");
            }
        }
    }

    private void startNewSnapshots(List<SnapshotsInProgress.Entry> snapshotsInProgress) {
        String localNodeId = this.clusterService.localNode().getId();
        for (SnapshotsInProgress.Entry entry : snapshotsInProgress) {
            SnapshotsInProgress.State entryState = entry.state();
            if (entry.isClone()) continue;
            if (entryState == SnapshotsInProgress.State.STARTED) {
                HashMap<ShardId, IndexShardSnapshotStatus> startedShards = null;
                Snapshot snapshot = entry.snapshot();
                Map snapshotShards = this.shardSnapshots.getOrDefault(snapshot, Collections.emptyMap());
                for (ObjectObjectCursor<ShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : entry.shards()) {
                    ShardId shardId = (ShardId)objectObjectCursor.key;
                    SnapshotsInProgress.ShardSnapshotStatus shardSnapshotStatus = (SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value;
                    if (shardSnapshotStatus.state() != SnapshotsInProgress.ShardState.INIT || !localNodeId.equals(shardSnapshotStatus.nodeId()) || snapshotShards.containsKey(shardId)) continue;
                    logger.trace("[{}] adding shard to the queue", (Object)shardId);
                    if (startedShards == null) {
                        startedShards = new HashMap<ShardId, IndexShardSnapshotStatus>();
                    }
                    startedShards.put(shardId, IndexShardSnapshotStatus.newInitializing(shardSnapshotStatus.generation()));
                }
                if (startedShards == null || startedShards.isEmpty()) continue;
                this.shardSnapshots.computeIfAbsent(snapshot, s -> new HashMap()).putAll(startedShards);
                this.startNewShards(entry, (Map<ShardId, IndexShardSnapshotStatus>)startedShards);
                continue;
            }
            if (entryState != SnapshotsInProgress.State.ABORTED) continue;
            Snapshot snapshot = entry.snapshot();
            Map snapshotShards = this.shardSnapshots.getOrDefault(snapshot, Collections.emptyMap());
            for (ObjectObjectCursor<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : entry.shardsByRepoShardId()) {
                ShardId shardId = entry.shardId((RepositoryShardId)objectObjectCursor.key);
                IndexShardSnapshotStatus snapshotStatus = (IndexShardSnapshotStatus)snapshotShards.get(shardId);
                if (snapshotStatus == null) {
                    if (((SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value).state() != SnapshotsInProgress.ShardState.ABORTED || !localNodeId.equals(((SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value).nodeId())) continue;
                    this.notifyFailedSnapshotShard(snapshot, shardId, ((SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value).reason(), ((SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value).generation());
                    continue;
                }
                snapshotStatus.abortIfNotCompleted("snapshot has been aborted");
            }
        }
    }

    private void startNewShards(SnapshotsInProgress.Entry entry, Map<ShardId, IndexShardSnapshotStatus> startedShards) {
        this.threadPool.executor("snapshot").execute(() -> {
            final Snapshot snapshot = entry.snapshot();
            for (Map.Entry shardEntry : startedShards.entrySet()) {
                final ShardId shardId = (ShardId)shardEntry.getKey();
                final IndexShardSnapshotStatus snapshotStatus = (IndexShardSnapshotStatus)shardEntry.getValue();
                IndexId indexId = entry.indices().get(shardId.getIndexName());
                assert (indexId != null);
                assert (SnapshotsService.useShardGenerations(entry.version()) || ShardGenerations.fixShardGeneration(snapshotStatus.generation()) == null) : "Found non-null, non-numeric shard generation [" + snapshotStatus.generation() + "] for snapshot with old-format compatibility";
                this.snapshot(shardId, snapshot, indexId, entry.userMetadata(), snapshotStatus, entry.version(), new ActionListener<ShardSnapshotResult>(){

                    @Override
                    public void onResponse(ShardSnapshotResult shardSnapshotResult) {
                        ShardGeneration newGeneration = shardSnapshotResult.getGeneration();
                        assert (newGeneration != null);
                        assert (newGeneration.equals(snapshotStatus.generation()));
                        if (logger.isDebugEnabled()) {
                            IndexShardSnapshotStatus.Copy lastSnapshotStatus = snapshotStatus.asCopy();
                            logger.debug("[{}][{}] completed snapshot to [{}] with status [{}] at generation [{}]", (Object)shardId, (Object)snapshot, (Object)snapshot.getRepository(), (Object)lastSnapshotStatus, (Object)snapshotStatus.generation());
                        }
                        SnapshotShardsService.this.notifySuccessfulSnapshotShard(snapshot, shardId, shardSnapshotResult);
                    }

                    @Override
                    public void onFailure(Exception e) {
                        String failure;
                        if (e instanceof AbortedSnapshotException) {
                            failure = "aborted";
                            logger.debug(() -> new ParameterizedMessage("[{}][{}] aborted shard snapshot", (Object)shardId, (Object)snapshot), (Throwable)e);
                        } else {
                            failure = SnapshotShardsService.summarizeFailure(e);
                            logger.warn(() -> new ParameterizedMessage("[{}][{}] failed to snapshot shard", (Object)shardId, (Object)snapshot), (Throwable)e);
                        }
                        snapshotStatus.moveToFailed(SnapshotShardsService.this.threadPool.absoluteTimeInMillis(), failure);
                        SnapshotShardsService.this.notifyFailedSnapshotShard(snapshot, shardId, failure, snapshotStatus.generation());
                    }
                });
            }
        });
    }

    static String summarizeFailure(Throwable t) {
        if (t.getCause() == null) {
            return t.getClass().getSimpleName() + "[" + t.getMessage() + "]";
        }
        StringBuilder sb = new StringBuilder();
        while (t != null) {
            sb.append(t.getClass().getSimpleName());
            if (t.getMessage() != null) {
                sb.append("[");
                sb.append(t.getMessage());
                sb.append("]");
            }
            if ((t = t.getCause()) == null) continue;
            sb.append("; nested: ");
        }
        return sb.toString();
    }

    private void snapshot(ShardId shardId, Snapshot snapshot, IndexId indexId, Map<String, Object> userMetadata, IndexShardSnapshotStatus snapshotStatus, Version version, ActionListener<ShardSnapshotResult> listener) {
        try {
            IndexShard indexShard = this.indicesService.indexServiceSafe(shardId.getIndex()).getShardOrNull(shardId.id());
            if (!indexShard.routingEntry().primary()) {
                throw new IndexShardSnapshotFailedException(shardId, "snapshot should be performed only on primary");
            }
            if (indexShard.routingEntry().relocating()) {
                throw new IndexShardSnapshotFailedException(shardId, "cannot snapshot while relocating");
            }
            IndexShardState indexShardState = indexShard.state();
            if (indexShardState == IndexShardState.CREATED || indexShardState == IndexShardState.RECOVERING) {
                throw new IndexShardSnapshotFailedException(shardId, "shard didn't fully recover yet");
            }
            Repository repository = this.repositoriesService.repository(snapshot.getRepository());
            Engine.IndexCommitRef snapshotRef = null;
            try {
                snapshotRef = indexShard.acquireIndexCommitForSnapshot();
                repository.snapshotShard(new SnapshotShardContext(indexShard.store(), indexShard.mapperService(), snapshot.getSnapshotId(), indexId, snapshotRef, SnapshotShardsService.getShardStateId(indexShard, snapshotRef.getIndexCommit()), snapshotStatus, version, userMetadata, listener));
            }
            catch (Exception e) {
                IOUtils.close((Closeable)snapshotRef);
                throw e;
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    @Nullable
    public static String getShardStateId(IndexShard indexShard, IndexCommit snapshotIndexCommit) throws IOException {
        Map userCommitData = snapshotIndexCommit.getUserData();
        SequenceNumbers.CommitInfo seqNumInfo = SequenceNumbers.loadSeqNoInfoFromLuceneCommit(userCommitData.entrySet());
        long maxSeqNo = seqNumInfo.maxSeqNo;
        if (maxSeqNo != seqNumInfo.localCheckpoint || maxSeqNo != indexShard.getLastSyncedGlobalCheckpoint()) {
            return null;
        }
        return (String)userCommitData.get("history_uuid") + "-" + userCommitData.getOrDefault("force_merge_uuid", "na") + "-" + maxSeqNo;
    }

    private void syncShardStatsOnNewMaster(List<SnapshotsInProgress.Entry> entries) {
        for (SnapshotsInProgress.Entry snapshot : entries) {
            Map<ShardId, IndexShardSnapshotStatus> localShards;
            if (snapshot.state() != SnapshotsInProgress.State.STARTED && snapshot.state() != SnapshotsInProgress.State.ABORTED || (localShards = this.currentSnapshotShards(snapshot.snapshot())) == null) continue;
            ImmutableOpenMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> masterShards = snapshot.shards();
            for (Map.Entry<ShardId, IndexShardSnapshotStatus> localShard : localShards.entrySet()) {
                ShardId shardId = localShard.getKey();
                SnapshotsInProgress.ShardSnapshotStatus masterShard = masterShards.get(shardId);
                if (masterShard == null || masterShard.state().completed()) continue;
                IndexShardSnapshotStatus.Copy indexShardSnapshotStatus = localShard.getValue().asCopy();
                IndexShardSnapshotStatus.Stage stage = indexShardSnapshotStatus.getStage();
                if (stage == IndexShardSnapshotStatus.Stage.DONE) {
                    logger.debug("[{}] new master thinks the shard [{}] is not completed but the shard is done locally, updating status on the master", (Object)snapshot.snapshot(), (Object)shardId);
                    this.notifySuccessfulSnapshotShard(snapshot.snapshot(), shardId, localShard.getValue().getShardSnapshotResult());
                    continue;
                }
                if (stage != IndexShardSnapshotStatus.Stage.FAILURE) continue;
                logger.debug("[{}] new master thinks the shard [{}] is not completed but the shard failed locally, updating status on master", (Object)snapshot.snapshot(), (Object)shardId);
                this.notifyFailedSnapshotShard(snapshot.snapshot(), shardId, indexShardSnapshotStatus.getFailure(), localShard.getValue().generation());
            }
        }
    }

    private void notifySuccessfulSnapshotShard(Snapshot snapshot, ShardId shardId, ShardSnapshotResult shardSnapshotResult) {
        assert (shardSnapshotResult != null);
        assert (shardSnapshotResult.getGeneration() != null);
        this.sendSnapshotShardUpdate(snapshot, shardId, SnapshotsInProgress.ShardSnapshotStatus.success(this.clusterService.localNode().getId(), shardSnapshotResult));
    }

    private void notifyFailedSnapshotShard(Snapshot snapshot, ShardId shardId, String failure, ShardGeneration generation) {
        this.sendSnapshotShardUpdate(snapshot, shardId, new SnapshotsInProgress.ShardSnapshotStatus(this.clusterService.localNode().getId(), SnapshotsInProgress.ShardState.FAILED, failure, generation));
    }

    private void sendSnapshotShardUpdate(final Snapshot snapshot, final ShardId shardId, final SnapshotsInProgress.ShardSnapshotStatus status) {
        this.remoteFailedRequestDeduplicator.executeOnce(new UpdateIndexShardSnapshotStatusRequest(snapshot, shardId, status), new ActionListener<Void>(){

            @Override
            public void onResponse(Void aVoid) {
                logger.trace("[{}][{}] updated snapshot state to [{}]", (Object)shardId, (Object)snapshot, (Object)status);
            }

            @Override
            public void onFailure(Exception e) {
                logger.warn(() -> new ParameterizedMessage("[{}][{}] failed to update snapshot state to [{}]", new Object[]{shardId, snapshot, status}), (Throwable)e);
            }
        }, (req, reqListener) -> this.transportService.sendRequest(this.transportService.getLocalNode(), "internal:cluster/snapshot/update_snapshot_status", (TransportRequest)req, new TransportResponseHandler<ActionResponse.Empty>(){

            @Override
            public ActionResponse.Empty read(StreamInput in) {
                return ActionResponse.Empty.INSTANCE;
            }

            @Override
            public void handleResponse(ActionResponse.Empty response) {
                reqListener.onResponse(null);
            }

            @Override
            public void handleException(TransportException exp) {
                reqListener.onFailure(exp);
            }
        }));
    }
}

