/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tasks;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskInfo;
import org.elasticsearch.tasks.TaskResult;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;

public class Task {
    public static final String X_OPAQUE_ID = "X-Opaque-Id";
    public static final String TRACE_PARENT = "traceparent";
    public static final String TRACE_ID = "trace.id";
    private final long id;
    private final String type;
    private final String action;
    private final String description;
    private final TaskId parentTask;
    private final Map<String, String> headers;
    private final long startTime;
    private final long startTimeNanos;

    public Task(long id, String type, String action, String description, TaskId parentTask, Map<String, String> headers) {
        this(id, type, action, description, parentTask, System.currentTimeMillis(), System.nanoTime(), headers);
    }

    public Task(long id, String type, String action, String description, TaskId parentTask, long startTime, long startTimeNanos, Map<String, String> headers) {
        this.id = id;
        this.type = type;
        this.action = action;
        this.description = description;
        this.parentTask = parentTask;
        this.startTime = startTime;
        this.startTimeNanos = startTimeNanos;
        this.headers = headers;
    }

    public final TaskInfo taskInfo(String localNodeId, boolean detailed) {
        String description = null;
        Status status = null;
        if (detailed) {
            description = this.getDescription();
            status = this.getStatus();
        }
        return this.taskInfo(localNodeId, description, status);
    }

    protected final TaskInfo taskInfo(String localNodeId, String description, Status status) {
        return new TaskInfo(new TaskId(localNodeId, this.getId()), this.getType(), this.getAction(), description, status, this.startTime, System.nanoTime() - this.startTimeNanos, this instanceof CancellableTask, this instanceof CancellableTask && ((CancellableTask)this).isCancelled(), this.parentTask, this.headers);
    }

    public long getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getAction() {
        return this.action;
    }

    public String getDescription() {
        return this.description;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getStartTimeNanos() {
        return this.startTimeNanos;
    }

    public TaskId getParentTaskId() {
        return this.parentTask;
    }

    public Status getStatus() {
        return null;
    }

    public String getHeader(String header) {
        return this.headers.get(header);
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public TaskResult result(DiscoveryNode node, Exception error) throws IOException {
        return new TaskResult(this.taskInfo(node.getId(), true), error);
    }

    public TaskResult result(DiscoveryNode node, ActionResponse response) throws IOException {
        if (response instanceof ToXContent) {
            return new TaskResult(this.taskInfo(node.getId(), true), (ToXContent)response);
        }
        throw new IllegalStateException("response has to implement ToXContent to be able to store the results");
    }

    public static interface Status
    extends ToXContentObject,
    NamedWriteable {
    }
}

