/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.ssl;

import java.security.cert.X509Certificate;
import java.util.Objects;
import org.elasticsearch.core.Nullable;

public final class StoredCertificate {
    private final X509Certificate certificate;
    @Nullable
    private final String path;
    private final String format;
    @Nullable
    private final String alias;
    private final boolean hasPrivateKey;

    public StoredCertificate(X509Certificate certificate, String path, String format, String alias, boolean hasPrivateKey) {
        this.certificate = Objects.requireNonNull(certificate, "Certificate may not be null");
        this.path = path;
        this.format = Objects.requireNonNull(format, "Format may not be null");
        this.alias = alias;
        this.hasPrivateKey = hasPrivateKey;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public String getPath() {
        return this.path;
    }

    public String getFormat() {
        return this.format;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean hasPrivateKey() {
        return this.hasPrivateKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredCertificate that = (StoredCertificate)o;
        return this.hasPrivateKey == that.hasPrivateKey && this.certificate.equals(that.certificate) && Objects.equals(this.path, that.path) && this.format.equals(that.format) && Objects.equals(this.alias, that.alias);
    }

    public int hashCode() {
        return Objects.hash(this.certificate, this.path, this.format, this.alias, this.hasPrivateKey);
    }
}

