/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.cfg;

import java.io.File;
import java.nio.file.Path;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.plugin.analysis.ik.AnalysisIkPlugin;
import org.wltea.analyzer.dic.Dictionary;

public class Configuration {
    private Environment environment;
    private Settings settings;
    private boolean useSmart;
    private boolean enableRemoteDict = false;
    private boolean enableLowercase = true;

    @Inject
    public Configuration(Environment env, Settings settings) {
        this.environment = env;
        this.settings = settings;
        this.useSmart = settings.get("use_smart", "false").equals("true");
        this.enableLowercase = settings.get("enable_lowercase", "true").equals("true");
        this.enableRemoteDict = settings.get("enable_remote_dict", "true").equals("true");
        Dictionary.initial(this);
    }

    public Path getConfigInPluginDir() {
        return PathUtils.get((String)new File(AnalysisIkPlugin.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParent(), (String[])new String[]{"config"}).toAbsolutePath();
    }

    public boolean isUseSmart() {
        return this.useSmart;
    }

    public Configuration setUseSmart(boolean useSmart) {
        this.useSmart = useSmart;
        return this;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public boolean isEnableRemoteDict() {
        return this.enableRemoteDict;
    }

    public boolean isEnableLowercase() {
        return this.enableLowercase;
    }
}

