/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xpack.core.ml.action.OpenJobAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class JobTaskRequest<R extends JobTaskRequest<R>>
extends BaseTasksRequest<R> {
    String jobId;

    JobTaskRequest() {
    }

    JobTaskRequest(String jobId) {
        this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
    }

    public String getJobId() {
        return this.jobId;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.jobId = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.jobId);
    }

    public boolean match(Task task) {
        return OpenJobAction.JobTaskMatcher.match(task, this.jobId);
    }
}

