/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup.job;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.rollup.RollupField;
import org.elasticsearch.xpack.core.rollup.job.GroupConfig;
import org.elasticsearch.xpack.core.rollup.job.MetricConfig;
import org.elasticsearch.xpack.core.scheduler.Cron;

public class RollupJobConfig
implements NamedWriteable,
ToXContentObject {
    private static final String NAME = "xpack/rollup/jobconfig";
    public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
    public static final ParseField CURRENT = new ParseField("current", new String[0]);
    public static final ParseField CRON = new ParseField("cron", new String[0]);
    public static final ParseField PAGE_SIZE = new ParseField("page_size", new String[0]);
    private static final ParseField INDEX_PATTERN = new ParseField("index_pattern", new String[0]);
    private static final ParseField ROLLUP_INDEX = new ParseField("rollup_index", new String[0]);
    private static final ParseField GROUPS = new ParseField("groups", new String[0]);
    private static final ParseField METRICS = new ParseField("metrics", new String[0]);
    private String id;
    private String indexPattern;
    private String rollupIndex;
    private GroupConfig groupConfig;
    private List<MetricConfig> metricsConfig = Collections.emptyList();
    private TimeValue timeout = TimeValue.timeValueSeconds((long)20L);
    private String cron;
    private int pageSize;
    public static final ObjectParser<Builder, Void> PARSER = new ObjectParser("xpack/rollup/jobconfig", false, Builder::new);

    RollupJobConfig(String id, String indexPattern, String rollupIndex, String cron, int pageSize, GroupConfig groupConfig, List<MetricConfig> metricsConfig, TimeValue timeout) {
        this.id = id;
        this.indexPattern = indexPattern;
        this.rollupIndex = rollupIndex;
        this.groupConfig = groupConfig;
        this.metricsConfig = metricsConfig;
        this.timeout = timeout;
        this.cron = cron;
        this.pageSize = pageSize;
    }

    public RollupJobConfig(StreamInput in) throws IOException {
        this.id = in.readString();
        this.indexPattern = in.readString();
        this.rollupIndex = in.readString();
        this.cron = in.readString();
        this.groupConfig = (GroupConfig)in.readOptionalWriteable(GroupConfig::new);
        this.metricsConfig = in.readList(MetricConfig::new);
        this.timeout = in.readTimeValue();
        this.pageSize = in.readInt();
    }

    public RollupJobConfig() {
    }

    public String getId() {
        return this.id;
    }

    public GroupConfig getGroupConfig() {
        return this.groupConfig;
    }

    public List<MetricConfig> getMetricsConfig() {
        return this.metricsConfig;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public String getIndexPattern() {
        return this.indexPattern;
    }

    public String getRollupIndex() {
        return this.rollupIndex;
    }

    public String getCron() {
        return this.cron;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String getWriteableName() {
        return NAME;
    }

    public Set<String> getAllFields() {
        HashSet<String> fields = new HashSet<String>(this.groupConfig.getAllFields());
        fields.addAll(this.metricsConfig.stream().map(MetricConfig::getField).collect(Collectors.toSet()));
        return fields;
    }

    public void validateMappings(Map<String, Map<String, FieldCapabilities>> fieldCapsResponse, ActionRequestValidationException validationException) {
        this.groupConfig.validateMappings(fieldCapsResponse, validationException);
        for (MetricConfig m : this.metricsConfig) {
            m.validateMappings(fieldCapsResponse, validationException);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(RollupField.ID.getPreferredName(), this.id);
        builder.field(INDEX_PATTERN.getPreferredName(), this.indexPattern);
        builder.field(ROLLUP_INDEX.getPreferredName(), this.rollupIndex);
        builder.field(CRON.getPreferredName(), this.cron);
        if (this.groupConfig != null) {
            builder.field(GROUPS.getPreferredName(), (ToXContent)this.groupConfig);
        }
        if (this.metricsConfig != null) {
            builder.startArray(METRICS.getPreferredName());
            for (MetricConfig config : this.metricsConfig) {
                builder.startObject();
                config.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
        }
        if (this.timeout != null) {
            builder.field(TIMEOUT.getPreferredName(), (Object)this.timeout);
        }
        builder.field(PAGE_SIZE.getPreferredName(), this.pageSize);
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeString(this.indexPattern);
        out.writeString(this.rollupIndex);
        out.writeString(this.cron);
        out.writeOptionalWriteable((Writeable)this.groupConfig);
        out.writeList(this.metricsConfig);
        out.writeTimeValue(this.timeout);
        out.writeInt(this.pageSize);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RollupJobConfig that = (RollupJobConfig)other;
        return Objects.equals(this.id, that.id) && Objects.equals(this.indexPattern, that.indexPattern) && Objects.equals(this.rollupIndex, that.rollupIndex) && Objects.equals(this.cron, that.cron) && Objects.equals(this.groupConfig, that.groupConfig) && Objects.equals(this.metricsConfig, that.metricsConfig) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.pageSize, that.pageSize);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.indexPattern, this.rollupIndex, this.cron, this.groupConfig, this.metricsConfig, this.timeout, this.pageSize);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
    }

    public String toJSONString() {
        return this.toString();
    }

    static {
        PARSER.declareString(Builder::setId, RollupField.ID);
        PARSER.declareObject(Builder::setGroupConfig, (p, c) -> ((GroupConfig.Builder)GroupConfig.PARSER.apply(p, c)).build(), GROUPS);
        PARSER.declareObjectArray(Builder::setMetricsConfig, (p, c) -> ((MetricConfig.Builder)MetricConfig.PARSER.apply(p, c)).build(), METRICS);
        PARSER.declareString((params, val) -> params.setTimeout(TimeValue.parseTimeValue((String)val, (String)TIMEOUT.getPreferredName())), TIMEOUT);
        PARSER.declareString(Builder::setIndexPattern, INDEX_PATTERN);
        PARSER.declareString(Builder::setRollupIndex, ROLLUP_INDEX);
        PARSER.declareString(Builder::setCron, CRON);
        PARSER.declareInt(Builder::setPageSize, PAGE_SIZE);
    }

    public static class Builder
    implements Writeable,
    ToXContentObject {
        private String id;
        private String indexPattern;
        private String rollupIndex;
        private GroupConfig groupConfig;
        private List<MetricConfig> metricsConfig = Collections.emptyList();
        private TimeValue timeout = TimeValue.timeValueSeconds((long)20L);
        private String cron;
        private int pageSize = 0;

        public Builder(RollupJobConfig job) {
            this.id = job.getId();
            this.indexPattern = job.getIndexPattern();
            this.rollupIndex = job.getRollupIndex();
            this.groupConfig = job.getGroupConfig();
            this.metricsConfig = job.getMetricsConfig();
            this.timeout = job.getTimeout();
            this.cron = job.getCron();
            this.pageSize = job.getPageSize();
        }

        public static Builder fromXContent(String id, XContentParser parser) {
            Builder config = (Builder)PARSER.apply(parser, null);
            if (id != null) {
                config.setId(id);
            }
            return config;
        }

        public Builder() {
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getIndexPattern() {
            return this.indexPattern;
        }

        public Builder setIndexPattern(String indexPattern) {
            this.indexPattern = indexPattern;
            return this;
        }

        public String getRollupIndex() {
            return this.rollupIndex;
        }

        public Builder setRollupIndex(String rollupIndex) {
            this.rollupIndex = rollupIndex;
            return this;
        }

        public GroupConfig getGroupConfig() {
            return this.groupConfig;
        }

        public Builder setGroupConfig(GroupConfig groupConfig) {
            this.groupConfig = groupConfig;
            return this;
        }

        public List<MetricConfig> getMetricsConfig() {
            return this.metricsConfig;
        }

        public Builder setMetricsConfig(List<MetricConfig> metricsConfig) {
            this.metricsConfig = metricsConfig;
            return this;
        }

        public TimeValue getTimeout() {
            return this.timeout;
        }

        public Builder setTimeout(TimeValue timeout) {
            this.timeout = timeout;
            return this;
        }

        public String getCron() {
            return this.cron;
        }

        public Builder setCron(String cron) {
            this.cron = cron;
            return this;
        }

        public int getPageSize() {
            return this.pageSize;
        }

        public Builder setPageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public RollupJobConfig build() {
            if (this.id == null || this.id.isEmpty()) {
                throw new IllegalArgumentException("An ID is mandatory.");
            }
            if (this.indexPattern == null || this.indexPattern.isEmpty()) {
                throw new IllegalArgumentException("An index pattern is mandatory.");
            }
            if (this.rollupIndex == null || this.rollupIndex.isEmpty()) {
                throw new IllegalArgumentException("A rollup index name is mandatory.");
            }
            if (this.cron == null || this.cron.isEmpty()) {
                throw new IllegalArgumentException("A cron schedule is mandatory.");
            }
            if (this.pageSize <= 0) {
                throw new IllegalArgumentException("Parameter [" + PAGE_SIZE.getPreferredName() + "] is mandatory and  must be a positive long.");
            }
            Cron testCron = new Cron(this.cron);
            if (this.groupConfig == null && (this.metricsConfig == null || this.metricsConfig.isEmpty())) {
                throw new IllegalArgumentException("At least one grouping or metric must be configured.");
            }
            return new RollupJobConfig(this.id, this.indexPattern, this.rollupIndex, this.cron, this.pageSize, this.groupConfig, this.metricsConfig, this.timeout);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.id != null) {
                builder.field(RollupField.ID.getPreferredName(), this.id);
            }
            if (this.indexPattern != null) {
                builder.field(INDEX_PATTERN.getPreferredName(), this.indexPattern);
            }
            if (this.indexPattern != null) {
                builder.field(ROLLUP_INDEX.getPreferredName(), this.rollupIndex);
            }
            if (this.cron != null) {
                builder.field(CRON.getPreferredName(), this.cron);
            }
            if (this.groupConfig != null) {
                builder.field(GROUPS.getPreferredName(), (ToXContent)this.groupConfig);
            }
            if (this.metricsConfig != null) {
                builder.startArray(METRICS.getPreferredName());
                for (MetricConfig config : this.metricsConfig) {
                    builder.startObject();
                    config.toXContent(builder, params);
                    builder.endObject();
                }
                builder.endArray();
            }
            if (this.timeout != null) {
                builder.field(TIMEOUT.getPreferredName(), (Object)this.timeout);
            }
            builder.field(PAGE_SIZE.getPreferredName(), this.pageSize);
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.id);
            out.writeOptionalString(this.indexPattern);
            out.writeOptionalString(this.rollupIndex);
            out.writeOptionalString(this.cron);
            out.writeOptionalWriteable((Writeable)this.groupConfig);
            out.writeList(this.metricsConfig);
            out.writeTimeValue(this.timeout);
            out.writeInt(this.pageSize);
        }
    }
}

