/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.transform.ArtifactTransform;
import org.gradle.api.internal.artifacts.transform.AbstractTransformer;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformDependencies;
import org.gradle.api.internal.artifacts.transform.TransformOutputsInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.FileNormalizer;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;
import org.gradle.internal.fingerprint.AbsolutePathInputNormalizer;
import org.gradle.internal.fingerprint.FileCollectionFingerprinterRegistry;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.instantiation.InstantiationScheme;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.isolation.IsolatableFactory;
import org.gradle.internal.reflect.Instantiator;

public class LegacyTransformer
extends AbstractTransformer<ArtifactTransform> {
    private final Instantiator instantiator;
    private final HashCode secondaryInputsHash;
    private final Isolatable<Object[]> isolatableParameters;

    public LegacyTransformer(Class<? extends ArtifactTransform> implementationClass, Object[] parameters, InstantiationScheme actionInstantiationScheme, ImmutableAttributes fromAttributes, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, IsolatableFactory isolatableFactory) {
        super(implementationClass, fromAttributes);
        this.instantiator = actionInstantiationScheme.instantiator();
        this.isolatableParameters = isolatableFactory.isolate((Object)parameters);
        this.secondaryInputsHash = LegacyTransformer.hashSecondaryInputs(this.isolatableParameters, implementationClass, classLoaderHierarchyHasher);
    }

    @Override
    public boolean requiresDependencies() {
        return false;
    }

    @Override
    public boolean isCacheable() {
        return false;
    }

    @Override
    public ImmutableList<File> transform(File inputArtifact, File outputDir, ArtifactTransformDependencies dependencies) {
        ArtifactTransform transformer = this.newTransformer();
        transformer.setOutputDirectory(outputDir);
        List outputs = transformer.transform(inputArtifact);
        if (outputs == null) {
            throw new InvalidUserDataException("Transform returned null result.");
        }
        LegacyTransformer.validateOutputs(inputArtifact, outputDir, outputs);
        return ImmutableList.copyOf((Collection)outputs);
    }

    private static void validateOutputs(File inputArtifact, File outputDir, List<File> outputs) {
        String inputFilePrefix = inputArtifact.getPath() + File.separator;
        String outputDirPrefix = outputDir.getPath() + File.separator;
        for (File output : outputs) {
            TransformOutputsInternal.validateOutputExists(output);
            TransformOutputsInternal.determineOutputLocationType(output, inputArtifact, inputFilePrefix, outputDir, outputDirPrefix);
        }
    }

    @Override
    public HashCode getSecondaryInputHash() {
        return this.secondaryInputsHash;
    }

    @Override
    public Class<? extends FileNormalizer> getInputArtifactNormalizer() {
        return AbsolutePathInputNormalizer.class;
    }

    @Override
    public Class<? extends FileNormalizer> getInputArtifactDependenciesNormalizer() {
        return AbsolutePathInputNormalizer.class;
    }

    @Override
    public boolean isIsolated() {
        return true;
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
    }

    @Override
    public void isolateParameters(FileCollectionFingerprinterRegistry fingerprinterRegistry) {
    }

    private ArtifactTransform newTransformer() {
        Object[] isolatedParameters = (Object[])this.isolatableParameters.isolate();
        return (ArtifactTransform)this.instantiator.newInstance(this.getImplementationClass(), isolatedParameters);
    }

    private static HashCode hashSecondaryInputs(Isolatable<Object[]> isolatableParameters, Class<? extends ArtifactTransform> implementationClass, ClassLoaderHierarchyHasher classLoaderHierarchyHasher) {
        Hasher hasher = Hashing.newHasher();
        LegacyTransformer.appendActionImplementation(implementationClass, hasher, classLoaderHierarchyHasher);
        isolatableParameters.appendToHasher(hasher);
        return hasher.hash();
    }
}

