/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.NetworkTopologyDiscovery;

public class NetworkTopologyDiscoveryImpl
implements NetworkTopologyDiscovery {
    private static final Logger logger = Logger.getLogger(NetworkTopologyDiscoveryImpl.class.getName());
    private final Method _isUp;
    private final Method _supportsMulticast;

    public NetworkTopologyDiscoveryImpl() {
        Method supportsMulticast;
        Method isUp;
        try {
            isUp = NetworkInterface.class.getMethod("isUp", null);
        }
        catch (Exception exception) {
            isUp = null;
        }
        this._isUp = isUp;
        try {
            supportsMulticast = NetworkInterface.class.getMethod("supportsMulticast", null);
        }
        catch (Exception exception) {
            supportsMulticast = null;
        }
        this._supportsMulticast = supportsMulticast;
    }

    public InetAddress[] getInetAddresses() {
        HashSet<InetAddress> result = new HashSet<InetAddress>();
        try {
            Enumeration<NetworkInterface> nifs = NetworkInterface.getNetworkInterfaces();
            while (nifs.hasMoreElements()) {
                NetworkInterface nif = nifs.nextElement();
                Enumeration<InetAddress> iaenum = nif.getInetAddresses();
                while (iaenum.hasMoreElements()) {
                    InetAddress interfaceAddress = iaenum.nextElement();
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("Found NetworkInterface/InetAddress: " + nif + " -- " + interfaceAddress);
                    }
                    if (!this.useInetAddress(nif, interfaceAddress)) continue;
                    result.add(interfaceAddress);
                }
            }
        }
        catch (SocketException se) {
            logger.warning("Error while fetching network interfaces addresses: " + se);
        }
        return result.toArray(new InetAddress[result.size()]);
    }

    public boolean useInetAddress(NetworkInterface networkInterface, InetAddress interfaceAddress) {
        try {
            if (this._isUp != null) {
                try {
                    if (!((Boolean)this._isUp.invoke((Object)networkInterface, (Object[])null)).booleanValue()) {
                        return false;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this._supportsMulticast != null) {
                try {
                    if (!((Boolean)this._supportsMulticast.invoke((Object)networkInterface, (Object[])null)).booleanValue()) {
                        return false;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return !interfaceAddress.isLoopbackAddress();
        }
        catch (Exception exception) {
            return false;
        }
    }
}

