/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import com.sun.jna.Native;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.Functions;
import hudson.Messages;
import hudson.Proc;
import hudson.RestrictedSince;
import hudson.model.TaskListener;
import hudson.os.PosixAPI;
import hudson.util.QuotedStringTokenizer;
import hudson.util.VariableResolver;
import hudson.util.jna.GNUCLibrary;
import hudson.util.jna.Kernel32Utils;
import hudson.util.jna.WinIOException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import jenkins.util.SystemProperties;
import jnr.posix.FileStat;
import jnr.posix.POSIX;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Chmod;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class Util {
    private static final long ONE_SECOND_MS = 1000L;
    private static final long ONE_MINUTE_MS = 60000L;
    private static final long ONE_HOUR_MS = 3600000L;
    private static final long ONE_DAY_MS = 86400000L;
    private static final long ONE_MONTH_MS = 2592000000L;
    private static final long ONE_YEAR_MS = 31536000000L;
    private static final Pattern VARIABLE;
    private static final Pattern errorCodeParser;
    private static final boolean[] uriMap;
    private static final AtomicBoolean warnedSymlinks;
    public static final FastDateFormat XS_DATETIME_FORMATTER;
    public static final FastDateFormat RFC822_DATETIME_FORMATTER;
    private static final Logger LOGGER;
    public static boolean NO_SYMLINK;
    public static boolean SYMLINK_ESCAPEHATCH;
    @Restricted(value={NoExternalUse.class})
    static int DELETION_MAX;
    @Restricted(value={NoExternalUse.class})
    static int WAIT_BETWEEN_DELETION_RETRIES;
    @Restricted(value={NoExternalUse.class})
    static boolean GC_AFTER_FAILED_DELETE;

    @Nonnull
    public static <T> List<T> filter(@Nonnull Iterable<?> base, @Nonnull Class<T> type) {
        ArrayList<T> r = new ArrayList<T>();
        for (Object i : base) {
            if (!type.isInstance(i)) continue;
            r.add(type.cast(i));
        }
        return r;
    }

    @Nonnull
    public static <T> List<T> filter(@Nonnull List<?> base, @Nonnull Class<T> type) {
        return Util.filter(base, type);
    }

    @Nullable
    public static String replaceMacro(@CheckForNull String s, @Nonnull Map<String, String> properties) {
        return Util.replaceMacro(s, new VariableResolver.ByMap<String>(properties));
    }

    @Nullable
    public static String replaceMacro(@CheckForNull String s, @Nonnull VariableResolver<String> resolver) {
        if (s == null) {
            return null;
        }
        int idx = 0;
        Matcher m;
        while ((m = VARIABLE.matcher(s)).find(idx)) {
            String value;
            String key = m.group().substring(1);
            if (key.charAt(0) == '$') {
                value = "$";
            } else {
                if (key.charAt(0) == '{') {
                    key = key.substring(1, key.length() - 1);
                }
                value = resolver.resolve(key);
            }
            if (value == null) {
                idx = m.end();
                continue;
            }
            s = s.substring(0, m.start()) + value + s.substring(m.end());
            idx = m.start() + value.length();
        }
        return s;
    }

    @Nonnull
    public static String loadFile(@Nonnull File logfile) throws IOException {
        return Util.loadFile(logfile, Charset.defaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static String loadFile(@Nonnull File logfile, @Nonnull Charset charset) throws IOException {
        if (!logfile.exists()) {
            return "";
        }
        StringBuilder str = new StringBuilder((int)logfile.length());
        try (BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(logfile), charset));){
            int len;
            char[] buf = new char[1024];
            while ((len = r.read(buf, 0, buf.length)) > 0) {
                str.append(buf, 0, len);
            }
        }
        return str.toString();
    }

    public static void deleteContentsRecursive(@Nonnull File file) throws IOException {
        int numberOfAttempts = 1;
        while (true) {
            try {
                Util.tryOnceDeleteContentsRecursive(file);
            }
            catch (IOException ex) {
                boolean threadWasInterrupted = Util.pauseBetweenDeletes(numberOfAttempts);
                if (numberOfAttempts >= DELETION_MAX || threadWasInterrupted) {
                    throw new IOException(Util.deleteFailExceptionMessage(file, numberOfAttempts, threadWasInterrupted), ex);
                }
                ++numberOfAttempts;
                continue;
            }
            break;
        }
    }

    public static void deleteFile(@Nonnull File f) throws IOException {
        int numberOfAttempts = 1;
        while (true) {
            try {
                Util.tryOnceDeleteFile(f);
            }
            catch (IOException ex) {
                boolean threadWasInterrupted = Util.pauseBetweenDeletes(numberOfAttempts);
                if (numberOfAttempts >= DELETION_MAX || threadWasInterrupted) {
                    throw new IOException(Util.deleteFailExceptionMessage(f, numberOfAttempts, threadWasInterrupted), ex);
                }
                ++numberOfAttempts;
                continue;
            }
            break;
        }
    }

    private static void tryOnceDeleteFile(File f) throws IOException {
        if (!f.delete()) {
            if (!f.exists()) {
                return;
            }
            Util.makeWritable(f);
            Util.makeWritable(f.getParentFile());
            if (!f.delete() && f.exists()) {
                Files.deleteIfExists(f.toPath());
                File[] files = f.listFiles();
                if (files != null && files.length > 0) {
                    throw new IOException("Unable to delete " + f.getPath() + " - files in dir: " + Arrays.asList(files));
                }
                throw new IOException("Unable to delete " + f.getPath());
            }
        }
    }

    private static void makeWritable(@Nonnull File f) {
        if (f.setWritable(true)) {
            return;
        }
        try {
            Chmod chmod = new Chmod();
            chmod.setProject(new Project());
            chmod.setFile(f);
            chmod.setPerm("u+w");
            chmod.execute();
        }
        catch (BuildException e) {
            LOGGER.log(Level.INFO, "Failed to chmod " + f, e);
        }
        try {
            POSIX posix = PosixAPI.jnr();
            String path = f.getAbsolutePath();
            FileStat stat = posix.stat(path);
            posix.chmod(path, stat.mode() | 0x80);
        }
        catch (Throwable t) {
            LOGGER.log(Level.FINE, "Failed to chmod(2) " + f, t);
        }
    }

    public static void deleteRecursive(@Nonnull File dir) throws IOException {
        int numberOfAttempts = 1;
        while (true) {
            try {
                Util.tryOnceDeleteRecursive(dir);
            }
            catch (IOException ex) {
                boolean threadWasInterrupted = Util.pauseBetweenDeletes(numberOfAttempts);
                if (numberOfAttempts >= DELETION_MAX || threadWasInterrupted) {
                    throw new IOException(Util.deleteFailExceptionMessage(dir, numberOfAttempts, threadWasInterrupted), ex);
                }
                ++numberOfAttempts;
                continue;
            }
            break;
        }
    }

    private static void tryOnceDeleteRecursive(File dir) throws IOException {
        if (!Util.isSymlink(dir)) {
            Util.tryOnceDeleteContentsRecursive(dir);
        }
        Util.tryOnceDeleteFile(dir);
    }

    private static void tryOnceDeleteContentsRecursive(File directory) throws IOException {
        File[] directoryContents = directory.listFiles();
        if (directoryContents == null) {
            return;
        }
        IOException firstCaught = null;
        for (File child : directoryContents) {
            try {
                Util.tryOnceDeleteRecursive(child);
            }
            catch (IOException justCaught) {
                if (firstCaught != null) continue;
                firstCaught = justCaught;
            }
        }
        if (firstCaught != null) {
            throw firstCaught;
        }
    }

    private static boolean pauseBetweenDeletes(int numberOfAttemptsSoFar) {
        long delayInMs;
        if (numberOfAttemptsSoFar >= DELETION_MAX) {
            return false;
        }
        if (GC_AFTER_FAILED_DELETE) {
            System.gc();
        }
        if ((delayInMs = WAIT_BETWEEN_DELETION_RETRIES >= 0 ? (long)WAIT_BETWEEN_DELETION_RETRIES : (long)(-numberOfAttemptsSoFar * WAIT_BETWEEN_DELETION_RETRIES)) <= 0L) {
            return Thread.interrupted();
        }
        try {
            Thread.sleep(delayInMs);
            return false;
        }
        catch (InterruptedException e) {
            return true;
        }
    }

    private static String deleteFailExceptionMessage(File whatWeWereTryingToRemove, int retryCount, boolean wasInterrupted) {
        StringBuilder sb = new StringBuilder();
        sb.append("Unable to delete '");
        sb.append(whatWeWereTryingToRemove);
        sb.append("'. Tried ");
        sb.append(retryCount);
        sb.append(" time");
        if (retryCount != 1) {
            sb.append('s');
        }
        if (DELETION_MAX > 1) {
            sb.append(" (of a maximum of ");
            sb.append(DELETION_MAX);
            sb.append(')');
            if (GC_AFTER_FAILED_DELETE) {
                sb.append(" garbage-collecting");
            }
            if (WAIT_BETWEEN_DELETION_RETRIES != 0 && GC_AFTER_FAILED_DELETE) {
                sb.append(" and");
            }
            if (WAIT_BETWEEN_DELETION_RETRIES != 0) {
                sb.append(" waiting ");
                sb.append(Util.getTimeSpanString(Math.abs(WAIT_BETWEEN_DELETION_RETRIES)));
                if (WAIT_BETWEEN_DELETION_RETRIES < 0) {
                    sb.append("-");
                    sb.append(Util.getTimeSpanString(Math.abs(WAIT_BETWEEN_DELETION_RETRIES) * DELETION_MAX));
                }
            }
            if (WAIT_BETWEEN_DELETION_RETRIES != 0 || GC_AFTER_FAILED_DELETE) {
                sb.append(" between attempts");
            }
        }
        if (wasInterrupted) {
            sb.append(". The delete operation was interrupted before it completed successfully");
        }
        sb.append('.');
        return sb.toString();
    }

    public static boolean isSymlink(@Nonnull File file) throws IOException {
        String name;
        Boolean r = Util.isSymlinkJava7(file);
        if (r != null) {
            return r;
        }
        if (Functions.isWindows()) {
            try {
                return Kernel32Utils.isJunctionOrSymlink(file);
            }
            catch (LinkageError | UnsupportedOperationException e) {
                // empty catch block
            }
        }
        if ((name = file.getName()).equals(".") || name.equals("..")) {
            return false;
        }
        File parentDir = file.getParentFile();
        File fileInCanonicalParent = parentDir == null ? file : new File(parentDir.getCanonicalPath(), name);
        return !fileInCanonicalParent.getCanonicalFile().equals(fileInCanonicalParent.getAbsoluteFile());
    }

    @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    private static Boolean isSymlinkJava7(@Nonnull File file) throws IOException {
        try {
            Path path = file.toPath();
            return Files.isSymbolicLink(path);
        }
        catch (Exception x) {
            throw (IOException)new IOException(x.toString()).initCause(x);
        }
    }

    public static boolean isRelativePath(String path) {
        char p;
        if (path.startsWith("/")) {
            return false;
        }
        if (path.startsWith("\\\\") && path.length() > 3 && path.indexOf(92, 3) != -1) {
            return false;
        }
        if (path.length() >= 3 && ':' == path.charAt(1) && ('A' <= (p = path.charAt(0)) && p <= 'Z' || 'a' <= p && p <= 'z')) {
            return path.charAt(2) != '\\' && path.charAt(2) != '/';
        }
        return true;
    }

    public static File createTempDir() throws IOException {
        File tmp = File.createTempFile("hudson", "tmp");
        if (!tmp.delete()) {
            throw new IOException("Failed to delete " + tmp);
        }
        if (!tmp.mkdirs()) {
            throw new IOException("Failed to create a new directory " + tmp);
        }
        return tmp;
    }

    public static void displayIOException(@Nonnull IOException e, @Nonnull TaskListener listener) {
        String msg = Util.getWin32ErrorMessage(e);
        if (msg != null) {
            listener.getLogger().println(msg);
        }
    }

    @CheckForNull
    public static String getWin32ErrorMessage(@Nonnull IOException e) {
        return Util.getWin32ErrorMessage((Throwable)e);
    }

    @CheckForNull
    public static String getWin32ErrorMessage(Throwable e) {
        Matcher m;
        String msg = e.getMessage();
        if (msg != null && (m = errorCodeParser.matcher(msg)).matches()) {
            try {
                ResourceBundle rb = ResourceBundle.getBundle("/hudson/win32errors");
                return rb.getString("error" + m.group(1));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (e.getCause() != null) {
            return Util.getWin32ErrorMessage(e.getCause());
        }
        return null;
    }

    @CheckForNull
    public static String getWin32ErrorMessage(int n) {
        try {
            ResourceBundle rb = ResourceBundle.getBundle("/hudson/win32errors");
            return rb.getString("error" + n);
        }
        catch (MissingResourceException e) {
            LOGGER.log(Level.WARNING, "Failed to find resource bundle", e);
            return null;
        }
    }

    @Nonnull
    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    public static void copyStream(@Nonnull InputStream in, @Nonnull OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[8192];
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
    }

    public static void copyStream(@Nonnull Reader in, @Nonnull Writer out) throws IOException {
        int len;
        char[] buf = new char[8192];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStreamAndClose(@Nonnull InputStream in, @Nonnull OutputStream out) throws IOException {
        try {
            Util.copyStream(in, out);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStreamAndClose(@Nonnull Reader in, @Nonnull Writer out) throws IOException {
        try {
            Util.copyStream(in, out);
        }
        finally {
            IOUtils.closeQuietly((Reader)in);
            IOUtils.closeQuietly((Writer)out);
        }
    }

    @Nonnull
    public static String[] tokenize(@Nonnull String s, @CheckForNull String delimiter) {
        return QuotedStringTokenizer.tokenize(s, delimiter);
    }

    @Nonnull
    public static String[] tokenize(@Nonnull String s) {
        return Util.tokenize(s, " \t\n\r\f");
    }

    @Nonnull
    public static String[] mapToEnv(@Nonnull Map<String, String> m) {
        String[] r = new String[m.size()];
        int idx = 0;
        for (Map.Entry<String, String> e : m.entrySet()) {
            r[idx++] = e.getKey() + '=' + e.getValue();
        }
        return r;
    }

    public static int min(int x, int ... values) {
        for (int i : values) {
            if (i >= x) continue;
            x = i;
        }
        return x;
    }

    @CheckForNull
    public static String nullify(@CheckForNull String v) {
        return Util.fixEmpty(v);
    }

    @Nonnull
    public static String removeTrailingSlash(@Nonnull String s) {
        if (s.endsWith("/")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    @Nullable
    public static String ensureEndsWith(@CheckForNull String subject, @CheckForNull String suffix) {
        if (subject == null) {
            return null;
        }
        if (subject.endsWith(suffix)) {
            return subject;
        }
        return subject + suffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static String getDigestOf(@Nonnull InputStream source) throws IOException {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[1024];
            try (DigestInputStream in = new DigestInputStream(source, md5);){
                while (in.read(buffer) >= 0) {
                }
            }
            return Util.toHexString(md5.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("MD5 not installed", e);
        }
    }

    @Nonnull
    public static String getDigestOf(@Nonnull String text) {
        try {
            return Util.getDigestOf(new ByteArrayInputStream(text.getBytes("UTF-8")));
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static String getDigestOf(@Nonnull File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            String string = Util.getDigestOf(new BufferedInputStream(is));
            return string;
        }
    }

    @Nonnull
    public static SecretKey toAes128Key(@Nonnull String s) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.reset();
            digest.update(s.getBytes("UTF-8"));
            return new SecretKeySpec(digest.digest(), 0, 16, "AES");
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    @Nonnull
    public static String toHexString(@Nonnull byte[] data, int start, int len) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            int b = data[start + i] & 0xFF;
            if (b < 16) {
                buf.append('0');
            }
            buf.append(Integer.toHexString(b));
        }
        return buf.toString();
    }

    @Nonnull
    public static String toHexString(@Nonnull byte[] bytes) {
        return Util.toHexString(bytes, 0, bytes.length);
    }

    @Nonnull
    public static byte[] fromHexString(@Nonnull String data) {
        byte[] r = new byte[data.length() / 2];
        for (int i = 0; i < data.length(); i += 2) {
            r[i / 2] = (byte)Integer.parseInt(data.substring(i, i + 2), 16);
        }
        return r;
    }

    @Nonnull
    public static String getTimeSpanString(long duration) {
        long years = duration / 31536000000L;
        long months = (duration %= 31536000000L) / 2592000000L;
        long days = (duration %= 2592000000L) / 86400000L;
        long hours = (duration %= 86400000L) / 3600000L;
        long minutes = (duration %= 3600000L) / 60000L;
        long seconds = (duration %= 60000L) / 1000L;
        long millisecs = duration %= 1000L;
        if (years > 0L) {
            return Util.makeTimeSpanString(years, Messages.Util_year(years), months, Messages.Util_month(months));
        }
        if (months > 0L) {
            return Util.makeTimeSpanString(months, Messages.Util_month(months), days, Messages.Util_day(days));
        }
        if (days > 0L) {
            return Util.makeTimeSpanString(days, Messages.Util_day(days), hours, Messages.Util_hour(hours));
        }
        if (hours > 0L) {
            return Util.makeTimeSpanString(hours, Messages.Util_hour(hours), minutes, Messages.Util_minute(minutes));
        }
        if (minutes > 0L) {
            return Util.makeTimeSpanString(minutes, Messages.Util_minute(minutes), seconds, Messages.Util_second(seconds));
        }
        if (seconds >= 10L) {
            return Messages.Util_second(seconds);
        }
        if (seconds >= 1L) {
            return Messages.Util_second(Float.valueOf((float)seconds + (float)(millisecs / 100L) / 10.0f));
        }
        if (millisecs >= 100L) {
            return Messages.Util_second(Float.valueOf((float)(millisecs / 10L) / 100.0f));
        }
        return Messages.Util_millisecond(millisecs);
    }

    @Nonnull
    private static String makeTimeSpanString(long bigUnit, @Nonnull String bigLabel, long smallUnit, @Nonnull String smallLabel) {
        String text = bigLabel;
        if (bigUnit < 10L) {
            text = text + ' ' + smallLabel;
        }
        return text;
    }

    @Nonnull
    public static String getPastTimeString(long duration) {
        return Messages.Util_pastTime(Util.getTimeSpanString(duration));
    }

    @Nonnull
    @Deprecated
    public static String combine(long n, @Nonnull String suffix) {
        String s = Long.toString(n) + ' ' + suffix;
        if (n != 1L) {
            s = s + "s";
        }
        return s;
    }

    @Nonnull
    public static <T> List<T> createSubList(@Nonnull Collection<?> source, @Nonnull Class<T> type) {
        ArrayList<T> r = new ArrayList<T>();
        for (Object item : source) {
            if (!type.isInstance(item)) continue;
            r.add(type.cast(item));
        }
        return r;
    }

    @Nonnull
    public static String encode(@Nonnull String s) {
        try {
            boolean escaped = false;
            StringBuilder out = new StringBuilder(s.length());
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)buf, "UTF-8");
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c < '\u0080' && c != ' ') {
                    out.append(c);
                    continue;
                }
                w.write(c);
                w.flush();
                for (byte b : buf.toByteArray()) {
                    out.append('%');
                    out.append(Util.toDigit(b >> 4 & 0xF));
                    out.append(Util.toDigit(b & 0xF));
                }
                buf.reset();
                escaped = true;
            }
            return escaped ? out.toString() : s;
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    @Nonnull
    public static String rawEncode(@Nonnull String s) {
        boolean escaped = false;
        StringBuilder out = null;
        CharsetEncoder enc = null;
        CharBuffer buf = null;
        int m = s.length();
        for (int i = 0; i < m; ++i) {
            char c = s.charAt(i);
            if (c > 'z' || uriMap[c]) {
                if (!escaped) {
                    out = new StringBuilder(i + (m - i) * 3);
                    out.append(s.substring(0, i));
                    enc = Charset.forName("UTF-8").newEncoder();
                    buf = CharBuffer.allocate(1);
                    escaped = true;
                }
                buf.put(0, c);
                buf.rewind();
                try {
                    ByteBuffer bytes = enc.encode(buf);
                    while (bytes.hasRemaining()) {
                        byte b = bytes.get();
                        out.append('%');
                        out.append(Util.toDigit(b >> 4 & 0xF));
                        out.append(Util.toDigit(b & 0xF));
                    }
                    continue;
                }
                catch (CharacterCodingException ex) {
                    continue;
                }
            }
            if (!escaped) continue;
            out.append(c);
        }
        return escaped ? out.toString() : s;
    }

    private static char toDigit(int n) {
        return (char)(n < 10 ? 48 + n : 65 + n - 10);
    }

    public static String singleQuote(String s) {
        return '\'' + s + '\'';
    }

    @Nonnull
    public static String escape(@Nonnull String text) {
        if (text == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(text.length() + 64);
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\n') {
                buf.append("<br>");
                continue;
            }
            if (ch == '<') {
                buf.append("&lt;");
                continue;
            }
            if (ch == '>') {
                buf.append("&gt;");
                continue;
            }
            if (ch == '&') {
                buf.append("&amp;");
                continue;
            }
            if (ch == '\"') {
                buf.append("&quot;");
                continue;
            }
            if (ch == '\'') {
                buf.append("&#039;");
                continue;
            }
            if (ch == ' ') {
                char nextCh = i + 1 < text.length() ? text.charAt(i + 1) : (char)'\u0000';
                buf.append(nextCh == ' ' ? "&nbsp;" : " ");
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    @Nonnull
    public static String xmlEscape(@Nonnull String text) {
        StringBuilder buf = new StringBuilder(text.length() + 64);
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '<') {
                buf.append("&lt;");
                continue;
            }
            if (ch == '>') {
                buf.append("&gt;");
                continue;
            }
            if (ch == '&') {
                buf.append("&amp;");
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static void touch(@Nonnull File file) throws IOException {
        new FileOutputStream(file).close();
    }

    public static void copyFile(@Nonnull File src, @Nonnull File dst) throws BuildException {
        Copy cp = new Copy();
        cp.setProject(new Project());
        cp.setTofile(dst);
        cp.setFile(src);
        cp.setOverwrite(true);
        cp.execute();
    }

    @Nonnull
    public static String fixNull(@CheckForNull String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    @CheckForNull
    public static String fixEmpty(@CheckForNull String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        return s;
    }

    @CheckForNull
    public static String fixEmptyAndTrim(@CheckForNull String s) {
        if (s == null) {
            return null;
        }
        return Util.fixEmpty(s.trim());
    }

    @Nonnull
    public static <T> List<T> fixNull(@CheckForNull List<T> l) {
        return l != null ? l : Collections.emptyList();
    }

    @Nonnull
    public static <T> Set<T> fixNull(@CheckForNull Set<T> l) {
        return l != null ? l : Collections.emptySet();
    }

    @Nonnull
    public static <T> Collection<T> fixNull(@CheckForNull Collection<T> l) {
        return l != null ? l : Collections.emptySet();
    }

    @Nonnull
    public static <T> Iterable<T> fixNull(@CheckForNull Iterable<T> l) {
        return l != null ? l : Collections.emptySet();
    }

    @Nonnull
    public static String getFileName(@Nonnull String filePath) {
        int idx = filePath.lastIndexOf(92);
        if (idx >= 0) {
            return Util.getFileName(filePath.substring(idx + 1));
        }
        idx = filePath.lastIndexOf(47);
        if (idx >= 0) {
            return Util.getFileName(filePath.substring(idx + 1));
        }
        return filePath;
    }

    @Nonnull
    public static String join(@Nonnull Collection<?> strings, @Nonnull String separator) {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (Object s : strings) {
            if (first) {
                first = false;
            } else {
                buf.append(separator);
            }
            buf.append(s);
        }
        return buf.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Nonnull
    public static <T> List<T> join(Collection<? extends T> ... items) {
        void var5_8;
        int size = 0;
        for (Collection<T> collection : items) {
            size += collection.size();
        }
        ArrayList<? extends T> r = new ArrayList<T>(size);
        Collection<? extends T>[] arr$ = items;
        int len$ = arr$.length;
        boolean bl = false;
        while (var5_8 < len$) {
            Collection<? extends T> item = arr$[var5_8];
            r.addAll(item);
            ++var5_8;
        }
        return r;
    }

    @Nonnull
    public static FileSet createFileSet(@Nonnull File baseDir, @Nonnull String includes, @CheckForNull String excludes) {
        String token;
        FileSet fs = new FileSet();
        fs.setDir(baseDir);
        fs.setProject(new Project());
        StringTokenizer tokens = new StringTokenizer(includes, ",");
        while (tokens.hasMoreTokens()) {
            token = tokens.nextToken().trim();
            fs.createInclude().setName(token);
        }
        if (excludes != null) {
            tokens = new StringTokenizer(excludes, ",");
            while (tokens.hasMoreTokens()) {
                token = tokens.nextToken().trim();
                fs.createExclude().setName(token);
            }
        }
        return fs;
    }

    @Nonnull
    public static FileSet createFileSet(@Nonnull File baseDir, @Nonnull String includes) {
        return Util.createFileSet(baseDir, includes, null);
    }

    public static void createSymlink(@Nonnull File baseDir, @Nonnull String targetPath, @Nonnull String symlinkPath, @Nonnull TaskListener listener) throws InterruptedException {
        block17: {
            try {
                Integer r;
                String errmsg;
                File symlinkFile;
                block18: {
                    if (Util.createSymlinkJava7(baseDir, targetPath, symlinkPath)) {
                        return;
                    }
                    if (NO_SYMLINK) {
                        return;
                    }
                    symlinkFile = new File(baseDir, symlinkPath);
                    if (Functions.isWindows()) {
                        if (symlinkFile.exists()) {
                            symlinkFile.delete();
                        }
                        File dst = new File(symlinkFile, "..\\" + targetPath);
                        try {
                            Kernel32Utils.createSymbolicLink(symlinkFile, targetPath, dst.isDirectory());
                            break block17;
                        }
                        catch (WinIOException e) {
                            if (e.getErrorCode() == 1314) {
                                Util.warnWindowsSymlink();
                                return;
                            }
                            throw e;
                        }
                        catch (UnsatisfiedLinkError e) {
                            return;
                        }
                    }
                    errmsg = "";
                    if (!symlinkFile.delete() && symlinkFile.exists()) {
                        new Proc.LocalProc(new String[]{"rm", "-rf", symlinkPath}, new String[0], (OutputStream)listener.getLogger(), baseDir).join();
                    }
                    r = null;
                    if (!SYMLINK_ESCAPEHATCH) {
                        try {
                            r = GNUCLibrary.LIBC.symlink(targetPath, symlinkFile.getAbsolutePath());
                            if (r != 0) {
                                r = Native.getLastError();
                                errmsg = GNUCLibrary.LIBC.strerror(r);
                            }
                        }
                        catch (LinkageError e) {
                            POSIX posix = PosixAPI.jnr();
                            if (!posix.isNative()) break block18;
                            r = posix.symlink(targetPath, symlinkFile.getAbsolutePath());
                        }
                    }
                }
                if (r == null) {
                    r = new Proc.LocalProc(new String[]{"ln", "-s", targetPath, symlinkPath}, new String[0], (OutputStream)listener.getLogger(), baseDir).join();
                }
                if (r != 0) {
                    listener.getLogger().println(String.format("ln -s %s %s failed: %d %s", targetPath, symlinkFile, r, errmsg));
                }
            }
            catch (IOException e) {
                PrintStream log = listener.getLogger();
                log.printf("ln %s %s failed%n", targetPath, new File(baseDir, symlinkPath));
                Util.displayIOException(e, listener);
                e.printStackTrace(log);
            }
        }
    }

    private static boolean createSymlinkJava7(@Nonnull File baseDir, @Nonnull String targetPath, @Nonnull String symlinkPath) throws IOException {
        try {
            Path path = new File(baseDir, symlinkPath).toPath();
            Path target = Paths.get(targetPath, new String[0]);
            int maxNumberOfTries = 4;
            int timeInMillis = 100;
            for (int tryNumber = 1; tryNumber <= 4; ++tryNumber) {
                Files.deleteIfExists(path);
                try {
                    Files.createSymbolicLink(path, target, new FileAttribute[0]);
                    break;
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    if (tryNumber >= 4) {
                        LOGGER.warning("symlink FileAlreadyExistsException thrown 4 times => cannot createSymbolicLink");
                        throw fileAlreadyExistsException;
                    }
                    TimeUnit.MILLISECONDS.sleep(100L);
                    continue;
                }
            }
            return true;
        }
        catch (UnsupportedOperationException e) {
            return true;
        }
        catch (FileSystemException e) {
            if (Functions.isWindows()) {
                Util.warnWindowsSymlink();
                return true;
            }
            return false;
        }
        catch (IOException x) {
            throw x;
        }
        catch (Exception x) {
            throw (IOException)new IOException(x.toString()).initCause(x);
        }
    }

    private static void warnWindowsSymlink() {
        if (warnedSymlinks.compareAndSet(false, true)) {
            LOGGER.warning("Symbolic links enabled on this platform but disabled for this user; run as administrator or use Local Security Policy > Security Settings > Local Policies > User Rights Assignment > Create symbolic links");
        }
    }

    @Deprecated
    public static String resolveSymlink(File link, TaskListener listener) throws InterruptedException, IOException {
        return Util.resolveSymlink(link);
    }

    @CheckForNull
    public static File resolveSymlinkToFile(@Nonnull File link) throws InterruptedException, IOException {
        String target = Util.resolveSymlink(link);
        if (target == null) {
            return null;
        }
        File f = new File(target);
        if (f.isAbsolute()) {
            return f;
        }
        return new File(link.getParentFile(), target);
    }

    @CheckForNull
    public static String resolveSymlink(@Nonnull File link) throws InterruptedException, IOException {
        try {
            Path path = link.toPath();
            return Files.readSymbolicLink(path).toString();
        }
        catch (UnsupportedOperationException | FileSystemException x) {
            return null;
        }
        catch (IOException x) {
            throw x;
        }
        catch (Exception x) {
            throw (IOException)new IOException(x.toString()).initCause(x);
        }
    }

    @Deprecated
    public static String encodeRFC2396(String url) {
        try {
            return new URI(null, url, null).toASCIIString();
        }
        catch (URISyntaxException e) {
            LOGGER.warning("Failed to encode " + url);
            return url;
        }
    }

    @Nonnull
    public static String wrapToErrorSpan(@Nonnull String s) {
        s = "<span class=error style='display:inline-block'>" + s + "</span>";
        return s;
    }

    @CheckForNull
    public static Number tryParseNumber(@CheckForNull String numberStr, @CheckForNull Number defaultNumber) {
        if (numberStr == null || numberStr.length() == 0) {
            return defaultNumber;
        }
        try {
            return NumberFormat.getNumberInstance().parse(numberStr);
        }
        catch (ParseException e) {
            return defaultNumber;
        }
    }

    public static boolean isOverridden(@Nonnull Class base, @Nonnull Class derived, @Nonnull String methodName, Class ... types) {
        return !Util.getMethod(base, methodName, types).equals(Util.getMethod(derived, methodName, types));
    }

    private static Method getMethod(@Nonnull Class clazz, @Nonnull String methodName, Class ... types) {
        Method res = null;
        try {
            res = clazz.getDeclaredMethod(methodName, types);
            if (res != null && (Modifier.isPrivate(res.getModifiers()) || Modifier.isFinal(res.getModifiers()) || Modifier.isStatic(res.getModifiers()))) {
                res = null;
            }
        }
        catch (NoSuchMethodException e) {
            Class superclass = clazz.getSuperclass();
            if (superclass != null) {
                res = Util.getMethod(superclass, methodName, types);
            }
        }
        catch (SecurityException e) {
            throw new AssertionError((Object)e);
        }
        if (res == null) {
            throw new IllegalArgumentException(String.format("Method %s not found in %s (or it is private, final or static)", methodName, clazz.getName()));
        }
        return res;
    }

    @Nonnull
    public static File changeExtension(@Nonnull File dst, @Nonnull String ext) {
        String p = dst.getPath();
        int pos = p.lastIndexOf(46);
        if (pos < 0) {
            return new File(p + ext);
        }
        return new File(p.substring(0, pos) + ext);
    }

    @Nullable
    public static String intern(@CheckForNull String s) {
        return s == null ? s : s.intern();
    }

    @Deprecated
    @RestrictedSince(value="1.651.2 / 2.TODO")
    @Restricted(value={NoExternalUse.class})
    public static boolean isAbsoluteUri(@Nonnull String uri) {
        int idx = uri.indexOf(58);
        if (idx < 0) {
            return false;
        }
        return idx < Util._indexOf(uri, '#') && idx < Util._indexOf(uri, '?') && idx < Util._indexOf(uri, '/');
    }

    public static boolean isSafeToRedirectTo(@Nonnull String uri) {
        return !Util.isAbsoluteUri(uri) && !uri.startsWith("//");
    }

    private static int _indexOf(@Nonnull String s, char ch) {
        int idx = s.indexOf(ch);
        if (idx < 0) {
            return s.length();
        }
        return idx;
    }

    @Nonnull
    public static Properties loadProperties(@Nonnull String properties) throws IOException {
        Properties p = new Properties();
        p.load(new StringReader(properties));
        return p;
    }

    @Restricted(value={NoExternalUse.class})
    public static void closeAndLogFailures(@CheckForNull Closeable toClose, @Nonnull Logger logger, @Nonnull String closeableName, @Nonnull String closeableOwner) {
        if (toClose == null) {
            return;
        }
        try {
            toClose.close();
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, String.format("Failed to close %s of %s", closeableName, closeableOwner), ex);
        }
    }

    static {
        int i;
        VARIABLE = Pattern.compile("\\$([A-Za-z0-9_]+|\\{[A-Za-z0-9_.]+\\}|\\$)");
        errorCodeParser = Pattern.compile(".*CreateProcess.*error=([0-9]+).*");
        uriMap = new boolean[123];
        String raw = "!  $ &'()*+,-. 0123456789   =  @ABCDEFGHIJKLMNOPQRSTUVWXYZ    _ abcdefghijklmnopqrstuvwxyz";
        for (i = 0; i < 33; ++i) {
            Util.uriMap[i] = true;
        }
        for (int j = 0; j < raw.length(); ++j) {
            Util.uriMap[i] = raw.charAt(j) == ' ';
            ++i;
        }
        warnedSymlinks = new AtomicBoolean();
        XS_DATETIME_FORMATTER = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss'Z'", (TimeZone)new SimpleTimeZone(0, "GMT"));
        RFC822_DATETIME_FORMATTER = FastDateFormat.getInstance((String)"EEE, dd MMM yyyy HH:mm:ss Z", (Locale)Locale.US);
        LOGGER = Logger.getLogger(Util.class.getName());
        NO_SYMLINK = SystemProperties.getBoolean(Util.class.getName() + ".noSymLink");
        SYMLINK_ESCAPEHATCH = SystemProperties.getBoolean(Util.class.getName() + ".symlinkEscapeHatch");
        DELETION_MAX = Math.max(1, SystemProperties.getInteger(Util.class.getName() + ".maxFileDeletionRetries", 3));
        WAIT_BETWEEN_DELETION_RETRIES = SystemProperties.getInteger(Util.class.getName() + ".deletionRetryWait", 100);
        GC_AFTER_FAILED_DELETE = SystemProperties.getBoolean(Util.class.getName() + ".performGCOnFailedDelete");
    }
}

