/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.core.JVM;
import com.trilead.ssh2.util.IOUtils;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.EnvVars;
import hudson.ExpressionFactory2;
import hudson.Functions;
import hudson.model.Hudson;
import hudson.security.ACL;
import hudson.util.AWTProblem;
import hudson.util.BootFailure;
import hudson.util.ChartUtil;
import hudson.util.HudsonFailedToLoad;
import hudson.util.HudsonIsLoading;
import hudson.util.IncompatibleAntVersionDetected;
import hudson.util.IncompatibleServletVersionDetected;
import hudson.util.IncompatibleVMDetected;
import hudson.util.InsufficientPermissionDetected;
import hudson.util.NoHomeDir;
import hudson.util.NoTempDir;
import hudson.util.RingBufferLogHandler;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Security;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletResponse;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import jenkins.model.Jenkins;
import jenkins.util.JenkinsJVM;
import jenkins.util.SystemProperties;
import org.apache.commons.jelly.expression.ExpressionFactory;
import org.apache.tools.ant.types.FileSet;
import org.jvnet.localizer.LocaleProvider;
import org.kohsuke.stapler.jelly.JellyFacet;

public class WebAppMain
implements ServletContextListener {
    private final RingBufferLogHandler handler = new RingBufferLogHandler(){

        @Override
        public synchronized void publish(LogRecord record) {
            if (record.getLevel().intValue() >= Level.INFO.intValue()) {
                super.publish(record);
            }
        }
    };
    private static final String APP = "app";
    private boolean terminated;
    private Thread initThread;
    private static final Logger LOGGER = Logger.getLogger(WebAppMain.class.getName());
    private static final String[] HOME_NAMES = new String[]{"JENKINS_HOME", "HUDSON_HOME"};

    public void contextInitialized(ServletContextEvent event) {
        JenkinsJVMAccess._setJenkinsJVM(true);
        final ServletContext context = event.getServletContext();
        File home = null;
        try {
            JVM jvm;
            LocaleProvider.setProvider((LocaleProvider)new LocaleProvider(){

                public Locale get() {
                    return Functions.getCurrentLocale();
                }
            });
            try {
                jvm = new JVM();
                new URLClassLoader(new URL[0], this.getClass().getClassLoader());
            }
            catch (SecurityException e) {
                throw new InsufficientPermissionDetected(e);
            }
            try {
                Security.removeProvider("SunPKCS11-Solaris");
            }
            catch (SecurityException e) {
                // empty catch block
            }
            this.installLogger();
            FileAndDescription describedHomeDir = this.getHomeDir(event);
            home = describedHomeDir.file.getAbsoluteFile();
            home.mkdirs();
            System.out.println("Jenkins home directory: " + home + " found at: " + describedHomeDir.description);
            if (!home.exists()) {
                throw new NoHomeDir(home);
            }
            this.recordBootAttempt(home);
            if (jvm.bestReflectionProvider().getClass() == PureJavaReflectionProvider.class) {
                throw new IncompatibleVMDetected();
            }
            try {
                ServletResponse.class.getMethod("setCharacterEncoding", String.class);
            }
            catch (NoSuchMethodException e) {
                throw new IncompatibleServletVersionDetected(ServletResponse.class);
            }
            try {
                FileSet.class.getMethod("getDirectoryScanner", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IncompatibleAntVersionDetected(FileSet.class);
            }
            if (ChartUtil.awtProblemCause != null) {
                throw new AWTProblem(ChartUtil.awtProblemCause);
            }
            try {
                File f = File.createTempFile("test", "test");
                f.delete();
            }
            catch (IOException e) {
                throw new NoTempDir(e);
            }
            try {
                TransformerFactory.newInstance();
            }
            catch (TransformerFactoryConfigurationError x) {
                LOGGER.log(Level.WARNING, "XSLT not configured correctly. Hudson will try to fix this. See http://issues.apache.org/bugzilla/show_bug.cgi?id=40895 for more details", x);
                System.setProperty(TransformerFactory.class.getName(), "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
                try {
                    TransformerFactory.newInstance();
                    LOGGER.info("XSLT is set to the JAXP RI in JRE");
                }
                catch (TransformerFactoryConfigurationError y) {
                    LOGGER.log(Level.SEVERE, "Failed to correct the problem.");
                }
            }
            WebAppMain.installExpressionFactory(event);
            context.setAttribute(APP, (Object)new HudsonIsLoading());
            final File _home = home;
            this.initThread = new Thread("Jenkins initialization thread"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean success = false;
                    try {
                        Jenkins instance = new Hudson(_home, context);
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        context.setAttribute(WebAppMain.APP, (Object)instance);
                        BootFailure.getBootFailureFile(_home).delete();
                        LOGGER.info("Jenkins is fully up and running");
                        success = true;
                    }
                    catch (Error e) {
                        new HudsonFailedToLoad(e).publish(context, _home);
                        throw e;
                    }
                    catch (Exception e) {
                        new HudsonFailedToLoad(e).publish(context, _home);
                    }
                    finally {
                        Jenkins instance = Jenkins.getInstanceOrNull();
                        if (!success && instance != null) {
                            instance.cleanUp();
                        }
                    }
                }
            };
            this.initThread.start();
        }
        catch (BootFailure e) {
            e.publish(context, home);
        }
        catch (Error | RuntimeException e) {
            LOGGER.log(Level.SEVERE, "Failed to initialize Jenkins", e);
            throw e;
        }
    }

    public void joinInit() throws InterruptedException {
        this.initThread.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordBootAttempt(File home) {
        FileOutputStream o = null;
        try {
            o = new FileOutputStream(BootFailure.getBootFailureFile(home), true);
            o.write((new Date().toString() + System.getProperty("line.separator", "\n")).toString().getBytes());
        }
        catch (IOException e) {
            try {
                LOGGER.log(Level.WARNING, "Failed to record boot attempts", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(o);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)o);
        }
        IOUtils.closeQuietly((Closeable)o);
    }

    public static void installExpressionFactory(ServletContextEvent event) {
        JellyFacet.setExpressionFactory((ServletContextEvent)event, (ExpressionFactory)new ExpressionFactory2());
    }

    @SuppressWarnings(value={"LG_LOST_LOGGER_DUE_TO_WEAK_REFERENCE"})
    private void installLogger() {
        Jenkins.logRecords = this.handler.getView();
        Logger.getLogger("").addHandler(this.handler);
    }

    public FileAndDescription getHomeDir(ServletContextEvent event) {
        File ws;
        for (String name : HOME_NAMES) {
            try {
                InitialContext iniCtxt = new InitialContext();
                Context env = (Context)iniCtxt.lookup("java:comp/env");
                String value = (String)env.lookup(name);
                if (value != null && value.trim().length() > 0) {
                    return new FileAndDescription(new File(value.trim()), "JNDI/java:comp/env/" + name);
                }
                value = (String)iniCtxt.lookup(name);
                if (value == null || value.trim().length() <= 0) continue;
                return new FileAndDescription(new File(value.trim()), "JNDI/" + name);
            }
            catch (NamingException e) {
                // empty catch block
            }
        }
        for (String name : HOME_NAMES) {
            String sysProp = SystemProperties.getString(name);
            if (sysProp == null) continue;
            return new FileAndDescription(new File(sysProp.trim()), "SystemProperties.getProperty(\"" + name + "\")");
        }
        for (String name : HOME_NAMES) {
            String env = EnvVars.masterEnvVars.get(name);
            if (env == null) continue;
            return new FileAndDescription(new File(env.trim()).getAbsoluteFile(), "EnvVars.masterEnvVars.get(\"" + name + "\")");
        }
        String root = event.getServletContext().getRealPath("/WEB-INF/workspace");
        if (root != null && (ws = new File(root.trim())).exists()) {
            return new FileAndDescription(ws, "getServletContext().getRealPath(\"/WEB-INF/workspace\")");
        }
        File legacyHome = new File(new File(System.getProperty("user.home")), ".hudson");
        if (legacyHome.exists()) {
            return new FileAndDescription(legacyHome, "$user.home/.hudson");
        }
        File newHome = new File(new File(System.getProperty("user.home")), ".jenkins");
        return new FileAndDescription(newHome, "$user.home/.jenkins");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent event) {
        try {
            ACL.impersonate(ACL.SYSTEM, new Runnable(){

                @Override
                public void run() {
                    Thread t;
                    WebAppMain.this.terminated = true;
                    Jenkins instance = Jenkins.getInstanceOrNull();
                    if (instance != null) {
                        instance.cleanUp();
                    }
                    if ((t = WebAppMain.this.initThread) != null && t.isAlive()) {
                        LOGGER.log(Level.INFO, "Shutting down a Jenkins instance that was still starting up", new Throwable("reason"));
                        t.interrupt();
                    }
                    Logger.getLogger("").removeHandler(WebAppMain.this.handler);
                }
            });
        }
        finally {
            JenkinsJVMAccess._setJenkinsJVM(false);
        }
    }

    private static final class JenkinsJVMAccess
    extends JenkinsJVM {
        private JenkinsJVMAccess() {
        }

        private static void _setJenkinsJVM(boolean jenkinsJVM) {
            JenkinsJVM.setJenkinsJVM(jenkinsJVM);
        }
    }

    public static class FileAndDescription {
        public final File file;
        public final String description;

        public FileAndDescription(File file, String description) {
            this.file = file;
            this.description = description;
        }
    }
}

