/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.PluginManager;
import hudson.cli.CLICommand;
import hudson.cli.Messages;
import hudson.model.UpdateSite;
import hudson.util.EditDistance;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Extension
public class InstallPluginCommand
extends CLICommand {
    @Argument(metaVar="SOURCE", required=true, usage="If this points to a local file, that file will be installed. If this is an URL, Jenkins downloads the URL and installs that as a plugin.Otherwise the name is assumed to be the short name of the plugin in the existing update center (like \"findbugs\"),and the plugin will be installed from the update center.")
    public List<String> sources = new ArrayList<String>();
    @Option(name="-name", usage="If specified, the plugin will be installed as this short name (whereas normally the name is inferred from the source name automatically).")
    public String name;
    @Option(name="-restart", usage="Restart Jenkins upon successful installation.")
    public boolean restart;
    @Option(name="-deploy", usage="Deploy plugins right away without postponing them until the reboot.")
    public boolean dynamicLoad;

    @Override
    public String getShortDescription() {
        return Messages.InstallPluginCommand_ShortDescription();
    }

    @Override
    protected int run() throws Exception {
        Jenkins h = Jenkins.getActiveInstance();
        h.checkPermission(PluginManager.UPLOAD_PLUGINS);
        PluginManager pm = h.getPluginManager();
        for (String source : this.sources) {
            FilePath f;
            if (this.channel != null && (f = new FilePath(this.channel, source)).exists()) {
                this.stdout.println(Messages.InstallPluginCommand_InstallingPluginFromLocalFile(f));
                if (this.name == null) {
                    this.name = f.getBaseName();
                }
                f.copyTo(this.getTargetFilePath());
                if (!this.dynamicLoad) continue;
                pm.dynamicLoad(this.getTargetFile());
                continue;
            }
            try {
                URL u = new URL(source);
                this.stdout.println(Messages.InstallPluginCommand_InstallingPluginFromUrl(u));
                if (this.name == null) {
                    this.name = u.getPath();
                    this.name = this.name.substring(this.name.lastIndexOf(47) + 1);
                    this.name = this.name.substring(this.name.lastIndexOf(92) + 1);
                    int idx = this.name.lastIndexOf(46);
                    if (idx > 0) {
                        this.name = this.name.substring(0, idx);
                    }
                }
                this.getTargetFilePath().copyFrom(u);
                if (!this.dynamicLoad) continue;
                pm.dynamicLoad(this.getTargetFile());
            }
            catch (MalformedURLException e) {
                UpdateSite.Plugin p = h.getUpdateCenter().getPlugin(source);
                if (p != null) {
                    this.stdout.println(Messages.InstallPluginCommand_InstallingFromUpdateCenter(source));
                    Throwable e2 = p.deploy(this.dynamicLoad).get().getError();
                    if (e2 == null) continue;
                    AbortException myException = new AbortException("Failed to install plugin " + source);
                    myException.initCause(e2);
                    throw myException;
                }
                this.stdout.println(Messages.InstallPluginCommand_NotAValidSourceName(source));
                if (!(source.contains(".") || source.contains(":") || source.contains("/") || source.contains("\\"))) {
                    if (h.getUpdateCenter().getSites().isEmpty()) {
                        this.stdout.println(Messages.InstallPluginCommand_NoUpdateCenterDefined());
                    } else {
                        HashSet<String> candidates = new HashSet<String>();
                        for (UpdateSite s : h.getUpdateCenter().getSites()) {
                            UpdateSite.Data dt = s.getData();
                            if (dt == null) {
                                this.stdout.println(Messages.InstallPluginCommand_NoUpdateDataRetrieved(s.getUrl()));
                                continue;
                            }
                            candidates.addAll(dt.plugins.keySet());
                        }
                        this.stdout.println(Messages.InstallPluginCommand_DidYouMean(source, EditDistance.findNearest(source, candidates)));
                    }
                }
                throw new AbortException("Error occurred, see previous output.");
            }
        }
        if (this.restart) {
            h.safeRestart();
        }
        return 0;
    }

    private FilePath getTargetFilePath() {
        return new FilePath(this.getTargetFile());
    }

    private File getTargetFile() {
        return new File(Jenkins.getActiveInstance().getPluginManager().rootDir, this.name + ".jpi");
    }
}

