/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.model.Computer;
import hudson.remoting.Channel;
import hudson.remoting.PingThread;
import hudson.util.ChunkedInputStream;
import hudson.util.ChunkedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.SystemProperties;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class FullDuplexHttpChannel {
    private Channel channel;
    private InputStream upload;
    private final UUID uuid;
    private final boolean restricted;
    private boolean completed;
    private static final Logger LOGGER = Logger.getLogger(FullDuplexHttpChannel.class.getName());
    @Restricted(value={NoExternalUse.class})
    public static boolean DIY_CHUNKING = SystemProperties.getBoolean("hudson.diyChunking");
    @Restricted(value={NoExternalUse.class})
    public static long CONNECTION_TIMEOUT = TimeUnit.SECONDS.toMillis(15L);

    public FullDuplexHttpChannel(UUID uuid, boolean restricted) throws IOException {
        this.uuid = uuid;
        this.restricted = restricted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void download(StaplerRequest req, StaplerResponse rsp) throws InterruptedException, IOException {
        rsp.setStatus(200);
        rsp.addHeader("Transfer-Encoding", "chunked");
        Object out = rsp.getOutputStream();
        if (DIY_CHUNKING) {
            out = new ChunkedOutputStream((OutputStream)out);
        }
        ((OutputStream)out).write("Starting HTTP duplex channel".getBytes());
        ((OutputStream)out).flush();
        long end = System.currentTimeMillis() + CONNECTION_TIMEOUT;
        while (this.upload == null && System.currentTimeMillis() < end) {
            this.wait(1000L);
        }
        if (this.upload == null) {
            throw new IOException("HTTP full-duplex channel timeout: " + this.uuid);
        }
        try {
            this.channel = new Channel("HTTP full-duplex channel " + this.uuid, Computer.threadPoolForRemoting, Channel.Mode.BINARY, this.upload, (OutputStream)out, null, this.restricted);
            PingThread ping = new PingThread(this.channel){

                @Override
                protected void onDead(Throwable diagnosis) {
                    LOGGER.log(Level.INFO, "Duplex-HTTP session " + FullDuplexHttpChannel.this.uuid + " is terminated", diagnosis);
                    try {
                        FullDuplexHttpChannel.this.upload.close();
                    }
                    catch (IOException e) {
                        throw new AssertionError((Object)e);
                    }
                }

                @Override
                protected void onDead() {
                    this.onDead(null);
                }
            };
            ping.start();
            this.main(this.channel);
            this.channel.join();
            ping.interrupt();
        }
        finally {
            this.completed = true;
            this.notify();
        }
    }

    protected abstract void main(Channel var1) throws IOException, InterruptedException;

    public synchronized void upload(StaplerRequest req, StaplerResponse rsp) throws InterruptedException, IOException {
        rsp.setStatus(200);
        Object in = req.getInputStream();
        if (DIY_CHUNKING) {
            in = new ChunkedInputStream((InputStream)in);
        }
        this.upload = in;
        this.notify();
        while (!this.completed) {
            this.wait();
        }
    }

    public Channel getChannel() {
        return this.channel;
    }
}

