/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import hudson.BulkChange;
import hudson.EnvVars;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.PermalinkList;
import hudson.Util;
import hudson.cli.declarative.CLIResolver;
import hudson.model.AbstractItem;
import hudson.model.Actionable;
import hudson.model.BallColor;
import hudson.model.Build;
import hudson.model.BuildTimelineWidget;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.EnvironmentContributor;
import hudson.model.Executor;
import hudson.model.Fingerprint;
import hudson.model.HealthReport;
import hudson.model.HealthReportingAction;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.model.Messages;
import hudson.model.Node;
import hudson.model.PermalinkProjectAction;
import hudson.model.Queue;
import hudson.model.RSS;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.ItemListener;
import hudson.search.QuickSilver;
import hudson.search.SearchIndex;
import hudson.search.SearchIndexBuilder;
import hudson.search.SearchItem;
import hudson.search.SearchItems;
import hudson.security.ACL;
import hudson.tasks.LogRotator;
import hudson.util.AlternativeUiTextProvider;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.CopyOnWriteList;
import hudson.util.DataSetBuilder;
import hudson.util.DescribableList;
import hudson.util.FormApply;
import hudson.util.Graph;
import hudson.util.QuotedStringTokenizer;
import hudson.util.RunList;
import hudson.util.ShiftedCategoryAxis;
import hudson.util.StackedAreaRenderer2;
import hudson.util.TextFile;
import hudson.widgets.HistoryWidget;
import hudson.widgets.Widget;
import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import jenkins.model.BuildDiscarder;
import jenkins.model.BuildDiscarderProperty;
import jenkins.model.DirectlyModifiableTopLevelItemGroup;
import jenkins.model.Jenkins;
import jenkins.model.ModelObjectWithChildren;
import jenkins.model.ModelObjectWithContextMenu;
import jenkins.model.ProjectNamingStrategy;
import jenkins.model.RunIdMigrator;
import jenkins.model.lazy.LazyBuildMixIn;
import jenkins.security.HexStringConfidentialKey;
import jenkins.util.io.OnMaster;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.jvnet.localizer.Localizable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.stapler.StaplerOverridable;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.interceptor.RequirePOST;

@BridgeMethodsAdded
public abstract class Job<JobT extends Job<JobT, RunT>, RunT extends Run<JobT, RunT>>
extends AbstractItem
implements ExtensionPoint,
StaplerOverridable,
ModelObjectWithChildren,
OnMaster {
    private static final Logger LOGGER = Logger.getLogger(Job.class.getName());
    protected volatile transient int nextBuildNumber = 1;
    private volatile transient boolean holdOffBuildUntilSave;
    private volatile transient boolean holdOffBuildUntilUserSave;
    private volatile BuildDiscarder logRotator;
    private transient Integer cachedBuildHealthReportsBuildNumber = null;
    private transient List<HealthReport> cachedBuildHealthReports = null;
    boolean keepDependencies;
    protected CopyOnWriteList<JobProperty<? super JobT>> properties = new CopyOnWriteList();
    @Restricted(value={NoExternalUse.class})
    public transient RunIdMigrator runIdMigrator;
    public static final HistoryWidget.Adapter<Run> HISTORY_ADAPTER = new HistoryWidget.Adapter<Run>(){

        @Override
        public int compare(Run record, String key) {
            try {
                int k = Integer.parseInt(key);
                return record.getNumber() - k;
            }
            catch (NumberFormatException nfe) {
                return String.valueOf(record.getNumber()).compareTo(key);
            }
        }

        @Override
        public String getKey(Run record) {
            return String.valueOf(record.getNumber());
        }

        @Override
        public boolean isBuilding(Run record) {
            return record.isBuilding();
        }

        @Override
        public String getNextKey(String key) {
            try {
                int k = Integer.parseInt(key);
                return String.valueOf(k + 1);
            }
            catch (NumberFormatException nfe) {
                return "-unable to determine next key-";
            }
        }
    };
    private static final HexStringConfidentialKey SERVER_COOKIE = new HexStringConfidentialKey(Job.class, "serverCookie", 16);

    protected Job(ItemGroup parent, String name) {
        super(parent, name);
    }

    @Override
    public synchronized void save() throws IOException {
        super.save();
        this.holdOffBuildUntilSave = this.holdOffBuildUntilUserSave;
    }

    @Override
    public void onCreatedFromScratch() {
        super.onCreatedFromScratch();
        this.runIdMigrator = new RunIdMigrator();
        this.runIdMigrator.created(this.getBuildDir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        block12: {
            super.onLoad(parent, name);
            File buildDir = this.getBuildDir();
            this.runIdMigrator = new RunIdMigrator();
            this.runIdMigrator.migrate(buildDir, Jenkins.getInstance().getRootDir());
            TextFile f = this.getNextBuildNumberFile();
            if (f.exists()) {
                try {
                    Job job = this;
                    synchronized (job) {
                        this.nextBuildNumber = Integer.parseInt(f.readTrim());
                    }
                }
                catch (NumberFormatException e) {
                    LOGGER.log(Level.WARNING, "Corruption in {0}: {1}", new Object[]{f, e});
                    if (this instanceof LazyBuildMixIn.LazyLoadingJob) break block12;
                    RunT lB = this.getLastBuild();
                    Job job = this;
                    synchronized (job) {
                        this.nextBuildNumber = lB != null ? ((Run)lB).getNumber() + 1 : 1;
                    }
                    this.saveNextBuildNumber();
                }
            } else {
                this.saveNextBuildNumber();
            }
        }
        if (this.properties == null) {
            this.properties = new CopyOnWriteList();
        }
        for (JobProperty<JobT> p : this.properties) {
            p.setOwner(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCopiedFrom(Item src) {
        super.onCopiedFrom(src);
        Job job = this;
        synchronized (job) {
            this.nextBuildNumber = 1;
            this.holdOffBuildUntilSave = this.holdOffBuildUntilUserSave = true;
        }
    }

    @Override
    protected void performDelete() throws IOException, InterruptedException {
        Executor e;
        RunT lb = this.getLastBuild();
        if (lb != null && (e = ((Run)lb).getExecutor()) != null) {
            e.interrupt();
        }
        super.performDelete();
    }

    TextFile getNextBuildNumberFile() {
        return new TextFile(new File(this.getRootDir(), "nextBuildNumber"));
    }

    public synchronized boolean isHoldOffBuildUntilSave() {
        return this.holdOffBuildUntilSave;
    }

    protected synchronized void saveNextBuildNumber() throws IOException {
        if (this.nextBuildNumber == 0) {
            this.nextBuildNumber = 1;
        }
        this.getNextBuildNumberFile().write(String.valueOf(this.nextBuildNumber) + '\n');
    }

    @Exported
    public boolean isInQueue() {
        return false;
    }

    @Exported
    public Queue.Item getQueueItem() {
        return null;
    }

    public boolean isBuilding() {
        RunT b = this.getLastBuild();
        return b != null && ((Run)b).isBuilding();
    }

    public boolean isLogUpdated() {
        RunT b = this.getLastBuild();
        return b != null && ((Run)b).isLogUpdated();
    }

    @Override
    public String getPronoun() {
        return AlternativeUiTextProvider.get(PRONOUN, this, Messages.Job_Pronoun());
    }

    public boolean isNameEditable() {
        return true;
    }

    @Exported
    public boolean isKeepDependencies() {
        return this.keepDependencies;
    }

    public synchronized int assignBuildNumber() throws IOException {
        int r = this.nextBuildNumber++;
        this.saveNextBuildNumber();
        return r;
    }

    @Exported
    public int getNextBuildNumber() {
        return this.nextBuildNumber;
    }

    public EnvVars getCharacteristicEnvVars() {
        EnvVars env = new EnvVars();
        env.put("JENKINS_SERVER_COOKIE", SERVER_COOKIE.get());
        env.put("HUDSON_SERVER_COOKIE", SERVER_COOKIE.get());
        env.put("JOB_NAME", this.getFullName());
        env.put("JOB_BASE_NAME", this.getName());
        return env;
    }

    @Nonnull
    public EnvVars getEnvironment(@CheckForNull Node node, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        Computer computer;
        EnvVars env = node != null ? ((computer = node.toComputer()) != null ? computer.buildEnvironment(listener) : new EnvVars()) : new EnvVars();
        env.putAll(this.getCharacteristicEnvVars());
        env.put("CLASSPATH", "");
        for (EnvironmentContributor ec : EnvironmentContributor.all().reverseView()) {
            ec.buildEnvironmentFor(this, env, listener);
        }
        return env;
    }

    public synchronized void updateNextBuildNumber(int next) throws IOException {
        RunT lb = this.getLastBuild();
        if (lb != null ? next > ((Run)lb).getNumber() : next > 0) {
            this.nextBuildNumber = next;
            this.saveNextBuildNumber();
        }
    }

    public synchronized BuildDiscarder getBuildDiscarder() {
        BuildDiscarderProperty prop = this._getProperty(BuildDiscarderProperty.class);
        return prop != null ? prop.getStrategy() : this.logRotator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setBuildDiscarder(BuildDiscarder bd) throws IOException {
        BulkChange bc = new BulkChange(this);
        try {
            this.removeProperty(BuildDiscarderProperty.class);
            if (bd != null) {
                this.addProperty(new BuildDiscarderProperty(bd));
            }
            bc.commit();
        }
        finally {
            bc.abort();
        }
    }

    @Deprecated
    public LogRotator getLogRotator() {
        BuildDiscarder buildDiscarder = this.getBuildDiscarder();
        return buildDiscarder instanceof LogRotator ? (LogRotator)buildDiscarder : null;
    }

    @Deprecated
    public void setLogRotator(LogRotator logRotator) throws IOException {
        this.setBuildDiscarder(logRotator);
    }

    public void logRotate() throws IOException, InterruptedException {
        BuildDiscarder bd = this.getBuildDiscarder();
        if (bd != null) {
            bd.perform(this);
        }
    }

    public boolean supportsLogRotator() {
        return true;
    }

    @Override
    protected SearchIndexBuilder makeSearchIndex() {
        return super.makeSearchIndex().add(new SearchIndex(){

            @Override
            public void find(String token, List<SearchItem> result) {
                try {
                    int n;
                    Object b;
                    if (token.startsWith("#")) {
                        token = token.substring(1);
                    }
                    if ((b = Job.this.getBuildByNumber(n = Integer.parseInt(token))) == null) {
                        return;
                    }
                    result.add(SearchItems.create("#" + n, "" + n, b));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }

            @Override
            public void suggest(String token, List<SearchItem> result) {
                this.find(token, result);
            }
        }).add("configure", "config", "configure");
    }

    @Override
    public Collection<? extends Job> getAllJobs() {
        return Collections.singleton(this);
    }

    public void addProperty(JobProperty<? super JobT> jobProp) throws IOException {
        jobProp.setOwner(this);
        this.properties.add(jobProp);
        this.save();
    }

    public void removeProperty(JobProperty<? super JobT> jobProp) throws IOException {
        this.properties.remove(jobProp);
        this.save();
    }

    public <T extends JobProperty> T removeProperty(Class<T> clazz) throws IOException {
        for (JobProperty<? super JobT> jobProperty : this.properties) {
            if (!clazz.isInstance(jobProperty)) continue;
            this.removeProperty(jobProperty);
            return (T)((JobProperty)clazz.cast(jobProperty));
        }
        return null;
    }

    public Map<JobPropertyDescriptor, JobProperty<? super JobT>> getProperties() {
        Map<Descriptor<JobProperty<JobT>>, JobProperty<JobT>> result = Descriptor.toMap(this.properties);
        if (this.logRotator != null) {
            result.put(Jenkins.getActiveInstance().getDescriptorByType(BuildDiscarderProperty.DescriptorImpl.class), new BuildDiscarderProperty(this.logRotator));
        }
        return result;
    }

    @Exported(name="property", inline=true)
    public List<JobProperty<? super JobT>> getAllProperties() {
        return this.properties.getView();
    }

    public <T extends JobProperty> T getProperty(Class<T> clazz) {
        if (clazz == BuildDiscarderProperty.class && this.logRotator != null) {
            return (T)((JobProperty)clazz.cast(new BuildDiscarderProperty(this.logRotator)));
        }
        return this._getProperty(clazz);
    }

    private <T extends JobProperty> T _getProperty(Class<T> clazz) {
        for (JobProperty<? super JobT> jobProperty : this.properties) {
            if (!clazz.isInstance(jobProperty)) continue;
            return (T)((JobProperty)clazz.cast(jobProperty));
        }
        return null;
    }

    public JobProperty getProperty(String className) {
        for (JobProperty<JobT> p : this.properties) {
            if (!p.getClass().getName().equals(className)) continue;
            return p;
        }
        return null;
    }

    public Collection<?> getOverrides() {
        ArrayList r = new ArrayList();
        for (JobProperty<JobT> p : this.properties) {
            r.addAll(p.getJobOverrides());
        }
        return r;
    }

    public List<Widget> getWidgets() {
        ArrayList<Widget> r = new ArrayList<Widget>();
        r.add(this.createHistoryWidget());
        return r;
    }

    protected HistoryWidget createHistoryWidget() {
        return new HistoryWidget<Job, Run>(this, this.getBuilds(), HISTORY_ADAPTER);
    }

    @Override
    public void renameTo(String newName) throws IOException {
        File oldBuildDir = this.getBuildDir();
        super.renameTo(newName);
        File newBuildDir = this.getBuildDir();
        if (oldBuildDir.isDirectory() && !newBuildDir.isDirectory()) {
            if (!newBuildDir.getParentFile().isDirectory()) {
                newBuildDir.getParentFile().mkdirs();
            }
            if (!oldBuildDir.renameTo(newBuildDir)) {
                throw new IOException("failed to rename " + oldBuildDir + " to " + newBuildDir);
            }
        }
    }

    @Override
    public void movedTo(DirectlyModifiableTopLevelItemGroup destination, AbstractItem newItem, File destDir) throws IOException {
        Job newJob = (Job)newItem;
        File oldBuildDir = this.getBuildDir();
        super.movedTo(destination, newItem, destDir);
        File newBuildDir = this.getBuildDir();
        if (oldBuildDir.isDirectory()) {
            FileUtils.moveDirectory((File)oldBuildDir, (File)newBuildDir);
        }
    }

    @Override
    public void delete() throws IOException, InterruptedException {
        super.delete();
        Util.deleteRecursive(this.getBuildDir());
    }

    @Exported
    public abstract boolean isBuildable();

    @Exported(name="allBuilds", visibility=-2)
    @WithBridgeMethods(value={List.class})
    public RunList<RunT> getBuilds() {
        return RunList.fromRuns(this._getRuns().values());
    }

    @Exported(name="builds")
    public RunList<RunT> getNewBuilds() {
        return ((RunList)this.getBuilds()).limit(100);
    }

    public synchronized List<RunT> getBuilds(Fingerprint.RangeSet rs) {
        LinkedList<RunT> builds = new LinkedList<RunT>();
        for (Fingerprint.Range r : rs.getRanges()) {
            for (RunT b = this.getNearestBuild(r.start); b != null && ((Run)b).getNumber() < r.end; b = ((Run)b).getNextBuild()) {
                builds.add(b);
            }
        }
        return builds;
    }

    public SortedMap<Integer, RunT> getBuildsAsMap() {
        return Collections.unmodifiableSortedMap(this._getRuns());
    }

    public RunT getBuild(String id) {
        for (Run r : this._getRuns().values()) {
            if (!r.getId().equals(id)) continue;
            return (RunT)r;
        }
        return null;
    }

    public RunT getBuildByNumber(int n) {
        return (RunT)((Run)this._getRuns().get(n));
    }

    @Deprecated
    @WithBridgeMethods(value={List.class})
    public RunList<RunT> getBuildsByTimestamp(long start, long end) {
        return ((RunList)this.getBuilds()).byTimestamp(start, end);
    }

    @CLIResolver
    public RunT getBuildForCLI(@Argument(required=true, metaVar="BUILD#", usage="Build number") String id) throws CmdLineException {
        try {
            int n = Integer.parseInt(id);
            RunT r = this.getBuildByNumber(n);
            if (r == null) {
                throw new CmdLineException(null, "No such build '#" + n + "' exists");
            }
            return r;
        }
        catch (NumberFormatException e) {
            throw new CmdLineException(null, id + "is not a number");
        }
    }

    public RunT getNearestBuild(int n) {
        SortedMap<Integer, RunT> m = this._getRuns().headMap(n - 1);
        if (m.isEmpty()) {
            return null;
        }
        return (RunT)((Run)m.get(m.lastKey()));
    }

    public RunT getNearestOldBuild(int n) {
        SortedMap<Integer, RunT> m = this._getRuns().tailMap(n);
        if (m.isEmpty()) {
            return null;
        }
        return (RunT)((Run)m.get(m.firstKey()));
    }

    @Override
    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        try {
            return this.getBuildByNumber(Integer.valueOf(token));
        }
        catch (NumberFormatException e) {
            for (Widget w : this.getWidgets()) {
                if (!w.getUrlName().equals(token)) continue;
                return w;
            }
            for (PermalinkProjectAction.Permalink p : this.getPermalinks()) {
                if (!p.getId().equals(token)) continue;
                return p.resolve(this);
            }
            return super.getDynamic(token, req, rsp);
        }
    }

    public File getBuildDir() {
        Jenkins j = Jenkins.getInstanceOrNull();
        if (j == null) {
            return new File(this.getRootDir(), "builds");
        }
        return j.getBuildDirFor(this);
    }

    protected abstract SortedMap<Integer, ? extends RunT> _getRuns();

    protected abstract void removeRun(RunT var1);

    @Exported
    @QuickSilver
    public RunT getLastBuild() {
        SortedMap<Integer, RunT> runs = this._getRuns();
        if (runs.isEmpty()) {
            return null;
        }
        return (RunT)((Run)runs.get(runs.firstKey()));
    }

    @Exported
    @QuickSilver
    public RunT getFirstBuild() {
        SortedMap<Integer, RunT> runs = this._getRuns();
        if (runs.isEmpty()) {
            return null;
        }
        return (RunT)((Run)runs.get(runs.lastKey()));
    }

    @Exported
    @QuickSilver
    public RunT getLastSuccessfulBuild() {
        return (RunT)PermalinkProjectAction.Permalink.LAST_SUCCESSFUL_BUILD.resolve(this);
    }

    @Exported
    @QuickSilver
    public RunT getLastUnsuccessfulBuild() {
        return (RunT)PermalinkProjectAction.Permalink.LAST_UNSUCCESSFUL_BUILD.resolve(this);
    }

    @Exported
    @QuickSilver
    public RunT getLastUnstableBuild() {
        return (RunT)PermalinkProjectAction.Permalink.LAST_UNSTABLE_BUILD.resolve(this);
    }

    @Exported
    @QuickSilver
    public RunT getLastStableBuild() {
        return (RunT)PermalinkProjectAction.Permalink.LAST_STABLE_BUILD.resolve(this);
    }

    @Exported
    @QuickSilver
    public RunT getLastFailedBuild() {
        return (RunT)PermalinkProjectAction.Permalink.LAST_FAILED_BUILD.resolve(this);
    }

    @Exported
    @QuickSilver
    public RunT getLastCompletedBuild() {
        RunT r;
        for (r = this.getLastBuild(); r != null && ((Run)r).isBuilding(); r = ((Run)r).getPreviousBuild()) {
        }
        return r;
    }

    public List<RunT> getLastBuildsOverThreshold(int numberOfBuilds, Result threshold) {
        ArrayList<RunT> result = new ArrayList<RunT>(numberOfBuilds);
        for (RunT r = this.getLastBuild(); r != null && result.size() < numberOfBuilds; r = ((Run)r).getPreviousBuild()) {
            if (((Run)r).isBuilding() || ((Run)r).getResult() == null || !((Run)r).getResult().isBetterOrEqualTo(threshold)) continue;
            result.add(r);
        }
        return result;
    }

    protected List<RunT> getEstimatedDurationCandidates() {
        ArrayList<Object> candidates = new ArrayList<Object>(3);
        RunT lastSuccessful = this.getLastSuccessfulBuild();
        int lastSuccessfulNumber = -1;
        if (lastSuccessful != null) {
            candidates.add(lastSuccessful);
            lastSuccessfulNumber = ((Run)lastSuccessful).getNumber();
        }
        int i = 0;
        ArrayList<RunT> fallbackCandidates = new ArrayList<RunT>(3);
        for (RunT r = this.getLastBuild(); r != null && candidates.size() < 3 && i < 6; ++i, r = ((Run)r).getPreviousBuild()) {
            if (((Run)r).isBuilding() || ((Run)r).getResult() == null || ((Run)r).getNumber() == lastSuccessfulNumber) continue;
            Result result = ((Run)r).getResult();
            if (result.isBetterOrEqualTo(Result.UNSTABLE)) {
                candidates.add(r);
                continue;
            }
            if (!result.isCompleteBuild()) continue;
            fallbackCandidates.add(r);
        }
        while (candidates.size() < 3 && !fallbackCandidates.isEmpty()) {
            Run run = (Run)fallbackCandidates.remove(0);
            candidates.add(run);
        }
        return candidates;
    }

    public long getEstimatedDuration() {
        List<RunT> builds = this.getEstimatedDurationCandidates();
        if (builds.isEmpty()) {
            return -1L;
        }
        long totalDuration = 0L;
        for (Run b : builds) {
            totalDuration += b.getDuration();
        }
        if (totalDuration == 0L) {
            return -1L;
        }
        return Math.round((double)totalDuration / (double)builds.size());
    }

    public PermalinkList getPermalinks() {
        PermalinkList permalinks = new PermalinkList((Collection<? extends PermalinkProjectAction.Permalink>)PermalinkProjectAction.Permalink.BUILTIN);
        for (PermalinkProjectAction ppa : this.getActions(PermalinkProjectAction.class)) {
            permalinks.addAll(ppa.getPermalinks());
        }
        return permalinks;
    }

    @Override
    public ModelObjectWithContextMenu.ContextMenu doChildrenContextMenu(StaplerRequest request, StaplerResponse response) throws Exception {
        ModelObjectWithContextMenu.ContextMenu menu = new ModelObjectWithContextMenu.ContextMenu();
        for (PermalinkProjectAction.Permalink p : this.getPermalinks()) {
            if (p.resolve(this) == null) continue;
            menu.add(p.getId(), p.getDisplayName());
        }
        return menu;
    }

    @Exported(visibility=2, name="color")
    public BallColor getIconColor() {
        RunT lastBuild;
        for (lastBuild = this.getLastBuild(); lastBuild != null && ((Run)lastBuild).hasntStartedYet(); lastBuild = ((Run)lastBuild).getPreviousBuild()) {
        }
        if (lastBuild != null) {
            return ((Run)lastBuild).getIconColor();
        }
        return BallColor.NOTBUILT;
    }

    public HealthReport getBuildHealth() {
        List<HealthReport> reports = this.getBuildHealthReports();
        return reports.isEmpty() ? new HealthReport() : reports.get(0);
    }

    @Exported(name="healthReport")
    public List<HealthReport> getBuildHealthReports() {
        ArrayList<HealthReport> reports = new ArrayList<HealthReport>();
        RunT lastBuild = this.getLastBuild();
        if (lastBuild != null && ((Run)lastBuild).isBuilding()) {
            lastBuild = ((Run)lastBuild).getPreviousBuild();
        }
        if (this.cachedBuildHealthReportsBuildNumber != null && this.cachedBuildHealthReports != null && lastBuild != null && this.cachedBuildHealthReportsBuildNumber.intValue() == ((Run)lastBuild).getNumber()) {
            reports.addAll(this.cachedBuildHealthReports);
        } else if (lastBuild != null) {
            for (HealthReportingAction healthReportingAction : ((Actionable)lastBuild).getActions(HealthReportingAction.class)) {
                HealthReport report = healthReportingAction.getBuildHealth();
                if (report == null) continue;
                if (report.isAggregateReport()) {
                    reports.addAll(report.getAggregatedReports());
                    continue;
                }
                reports.add(report);
            }
            HealthReport report = this.getBuildStabilityHealthReport();
            if (report != null) {
                if (report.isAggregateReport()) {
                    reports.addAll(report.getAggregatedReports());
                } else {
                    reports.add(report);
                }
            }
            Collections.sort(reports);
            this.cachedBuildHealthReportsBuildNumber = ((Run)lastBuild).getNumber();
            this.cachedBuildHealthReports = new ArrayList<HealthReport>(reports);
        }
        return reports;
    }

    private HealthReport getBuildStabilityHealthReport() {
        int failCount = 0;
        int totalCount = 0;
        block4: for (RunT i = this.getLastBuild(); totalCount < 5 && i != null; i = ((Run)i).getPreviousBuild()) {
            switch (((Run)i).getIconColor()) {
                case BLUE: 
                case YELLOW: {
                    ++totalCount;
                    continue block4;
                }
                case RED: {
                    ++failCount;
                    ++totalCount;
                    continue block4;
                }
            }
        }
        if (totalCount > 0) {
            int score = (int)(100.0 * (double)(totalCount - failCount) / (double)totalCount);
            Localizable description = failCount == 0 ? Messages._Job_NoRecentBuildFailed() : (totalCount == failCount ? Messages._Job_AllRecentBuildFailed() : Messages._Job_NOfMFailed(failCount, totalCount));
            return new HealthReport(score, Messages._Job_BuildStability(description));
        }
        return null;
    }

    @RequirePOST
    public synchronized void doConfigSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        this.checkPermission(CONFIGURE);
        this.description = req.getParameter("description");
        JSONObject json = req.getSubmittedForm();
        try {
            this.setDisplayName(json.optString("displayNameOrNull"));
            this.logRotator = null;
            DescribableList t = new DescribableList(NOOP, this.getAllProperties());
            JSONObject jsonProperties = json.optJSONObject("properties");
            if (jsonProperties != null) {
                t.rebuild(req, jsonProperties, JobPropertyDescriptor.getPropertyDescriptors(this.getClass()));
            } else {
                t.clear();
            }
            this.properties.clear();
            for (JobProperty p : t) {
                p.setOwner(this);
                this.properties.add(p);
            }
            this.submit(req, rsp);
            this.save();
            ItemListener.fireOnUpdated(this);
            String newName = req.getParameter("name");
            ProjectNamingStrategy namingStrategy = Jenkins.getInstance().getProjectNamingStrategy();
            if (this.validRename(this.name, newName)) {
                newName = newName.trim();
                Jenkins.checkGoodName(newName);
                namingStrategy.checkName(newName);
                if (FormApply.isApply(req)) {
                    FormApply.applyResponse("notificationBar.show(" + QuotedStringTokenizer.quote(Messages.Job_you_must_use_the_save_button_if_you_wish()) + ",notificationBar.WARNING)").generateResponse(req, rsp, null);
                } else {
                    rsp.sendRedirect("rename?newName=" + URLEncoder.encode(newName, "UTF-8"));
                }
            } else {
                if (namingStrategy.isForceExistingJobs()) {
                    namingStrategy.checkName(this.name);
                }
                FormApply.success(".").generateResponse(req, rsp, null);
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.WARNING, "failed to parse " + json, e);
            this.sendError((Exception)((Object)e), req, rsp);
        }
    }

    private boolean validRename(String oldName, String newName) {
        if (newName == null) {
            return false;
        }
        boolean noChange = oldName.equals(newName);
        boolean spaceAdded = oldName.equals(newName.trim());
        return !noChange && !spaceAdded;
    }

    protected void submit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
    }

    public void doDescription(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (req.getMethod().equals("GET")) {
            rsp.setContentType("text/plain;charset=UTF-8");
            rsp.getWriter().write(Util.fixNull(this.getDescription()));
            return;
        }
        if (req.getMethod().equals("POST")) {
            this.checkPermission(CONFIGURE);
            if (req.getParameter("description") != null) {
                this.setDescription(req.getParameter("description"));
                rsp.sendError(204);
                return;
            }
        }
        rsp.sendError(400);
    }

    public void doBuildStatus(StaplerRequest req, StaplerResponse rsp) throws IOException {
        rsp.sendRedirect2(req.getContextPath() + "/images/48x48/" + this.getBuildStatusUrl());
    }

    public String getBuildStatusUrl() {
        return this.getIconColor().getImage();
    }

    public String getBuildStatusIconClassName() {
        return this.getIconColor().getIconClassName();
    }

    public Graph getBuildTimeGraph() {
        return new Graph(this.getLastBuildTime(), 500, 400){

            @Override
            protected JFreeChart createGraph() {
                class ChartLabel
                implements Comparable<1ChartLabel> {
                    final Run run;

                    public ChartLabel(Run r) {
                        this.run = r;
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    @Override
                    public int compareTo(ChartLabel that) {
                        return this.run.number - that.run.number;
                    }

                    public boolean equals(Object o) {
                        if (o == null || !ChartLabel.class.isAssignableFrom(o.getClass())) {
                            return false;
                        }
                        ChartLabel that = (ChartLabel)o;
                        return this.run == that.run;
                    }

                    public Color getColor() {
                        Result r = this.run.getResult();
                        if (r == Result.FAILURE) {
                            return ColorPalette.RED;
                        }
                        if (r == Result.UNSTABLE) {
                            return ColorPalette.YELLOW;
                        }
                        if (r == Result.ABORTED || r == Result.NOT_BUILT) {
                            return ColorPalette.GREY;
                        }
                        return ColorPalette.BLUE;
                    }

                    public int hashCode() {
                        return this.run.hashCode();
                    }

                    public String toString() {
                        String s;
                        String l = this.run.getDisplayName();
                        if (this.run instanceof Build && (s = ((Build)this.run).getBuiltOnStr()) != null) {
                            l = l + ' ' + s;
                        }
                        return l;
                    }
                }
                DataSetBuilder<String, ChartLabel> data = new DataSetBuilder<String, ChartLabel>();
                for (Run r : Job.this.getNewBuilds()) {
                    if (r.isBuilding()) continue;
                    data.add((double)r.getDuration() / 60000.0, "min", new ChartLabel(r));
                }
                final CategoryDataset dataset = data.build();
                JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)Messages.Job_minutes(), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
                chart.setBackgroundPaint((Paint)Color.white);
                CategoryPlot plot = chart.getCategoryPlot();
                plot.setBackgroundPaint((Paint)Color.WHITE);
                plot.setOutlinePaint(null);
                plot.setForegroundAlpha(0.8f);
                plot.setRangeGridlinesVisible(true);
                plot.setRangeGridlinePaint((Paint)Color.black);
                ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
                plot.setDomainAxis((CategoryAxis)domainAxis);
                domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
                domainAxis.setLowerMargin(0.0);
                domainAxis.setUpperMargin(0.0);
                domainAxis.setCategoryMargin(0.0);
                NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
                ChartUtil.adjustChebyshev(dataset, rangeAxis);
                rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                StackedAreaRenderer2 ar = new StackedAreaRenderer2(){

                    @Override
                    public Paint getItemPaint(int row, int column) {
                        ChartLabel key = (ChartLabel)dataset.getColumnKey(column);
                        return key.getColor();
                    }

                    @Override
                    public String generateURL(CategoryDataset dataset2, int row, int column) {
                        ChartLabel label = (ChartLabel)dataset2.getColumnKey(column);
                        return String.valueOf(label.run.number);
                    }

                    @Override
                    public String generateToolTip(CategoryDataset dataset2, int row, int column) {
                        ChartLabel label = (ChartLabel)dataset2.getColumnKey(column);
                        return label.run.getDisplayName() + " : " + label.run.getDurationString();
                    }
                };
                plot.setRenderer((CategoryItemRenderer)ar);
                plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
                return chart;
            }
        };
    }

    private Calendar getLastBuildTime() {
        RunT lastBuild = this.getLastBuild();
        if (lastBuild == null) {
            GregorianCalendar neverBuiltCalendar = new GregorianCalendar();
            neverBuiltCalendar.setTimeInMillis(0L);
            return neverBuiltCalendar;
        }
        return ((Run)lastBuild).getTimestamp();
    }

    @RequirePOST
    public void doDoRename(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        if (!this.hasPermission(CONFIGURE)) {
            this.checkPermission(CREATE);
            this.checkPermission(DELETE);
        }
        String newName = req.getParameter("newName");
        Jenkins.checkGoodName(newName);
        if (this.isBuilding()) {
            rsp.sendRedirect("rename?newName=" + URLEncoder.encode(newName, "UTF-8"));
            return;
        }
        this.renameTo(newName);
        rsp.sendRedirect2("../" + newName);
    }

    public void doRssAll(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.rss(req, rsp, " all builds", (RunList)this.getBuilds());
    }

    public void doRssFailed(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.rss(req, rsp, " failed builds", ((RunList)this.getBuilds()).failureOnly());
    }

    private void rss(StaplerRequest req, StaplerResponse rsp, String suffix, RunList runs) throws IOException, ServletException {
        RSS.forwardToRss(this.getDisplayName() + suffix, this.getUrl(), runs.newBuilds(), Run.FEED_ADAPTER, req, (HttpServletResponse)rsp);
    }

    @Override
    public ACL getACL() {
        return Jenkins.getInstance().getAuthorizationStrategy().getACL(this);
    }

    public BuildTimelineWidget getTimeline() {
        return new BuildTimelineWidget((RunList<?>)this.getBuilds());
    }

    @Extension(ordinal=-1.7976931348623157E308)
    public static class LastItemListener
    extends ItemListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCopied(Item src, Item item) {
            if (item instanceof Job) {
                Job job;
                Job job2 = job = (Job)item;
                synchronized (job2) {
                    job.holdOffBuildUntilUserSave = false;
                }
            }
        }
    }
}

