/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.EnvVars;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.model.Run;
import java.util.Locale;
import org.kohsuke.stapler.DataBoundConstructor;

public class JobParameterValue
extends ParameterValue {
    public final Job job;

    @DataBoundConstructor
    public JobParameterValue(String name, Job job) {
        super(name);
        this.job = job;
    }

    @Override
    public Job getValue() {
        return this.job;
    }

    @Override
    public void buildEnvironment(Run<?, ?> build, EnvVars env) {
        env.put(this.name, this.job.toString());
        env.put(this.name.toUpperCase(Locale.ENGLISH), this.job.toString());
    }

    @Override
    public String getShortDescription() {
        return this.name + "=" + this.job.getFullDisplayName();
    }
}

