/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import com.google.common.collect.Maps;
import hudson.ExtensionPoint;
import hudson.model.Queue;
import hudson.model.queue.MappingWorksheet;
import hudson.util.ConsistentHash;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class LoadBalancer
implements ExtensionPoint {
    public static final LoadBalancer CONSISTENT_HASH;
    @Deprecated
    public static final LoadBalancer DEFAULT;

    public abstract MappingWorksheet.Mapping map(Queue.Task var1, MappingWorksheet var2);

    protected LoadBalancer sanitize() {
        final LoadBalancer base = this;
        return new LoadBalancer(){

            @Override
            public MappingWorksheet.Mapping map(Queue.Task task, MappingWorksheet worksheet) {
                if (Queue.isBlockedByShutdown(task)) {
                    return null;
                }
                return base.map(task, worksheet);
            }

            @Override
            protected LoadBalancer sanitize() {
                return this;
            }
        };
    }

    static {
        DEFAULT = CONSISTENT_HASH = new LoadBalancer(){

            @Override
            public MappingWorksheet.Mapping map(Queue.Task task, MappingWorksheet ws) {
                ArrayList<ConsistentHash<MappingWorksheet.ExecutorChunk>> hashes = new ArrayList<ConsistentHash<MappingWorksheet.ExecutorChunk>>(ws.works.size());
                for (int i = 0; i < ws.works.size(); ++i) {
                    ConsistentHash<MappingWorksheet.ExecutorChunk> hash = new ConsistentHash<MappingWorksheet.ExecutorChunk>(new ConsistentHash.Hash<MappingWorksheet.ExecutorChunk>(){

                        @Override
                        public String hash(MappingWorksheet.ExecutorChunk node) {
                            return node.getName();
                        }
                    });
                    List<MappingWorksheet.ExecutorChunk> chunks = ws.works(i).applicableExecutorChunks();
                    HashMap toAdd = Maps.newHashMapWithExpectedSize((int)chunks.size());
                    for (MappingWorksheet.ExecutorChunk ec : chunks) {
                        toAdd.put(ec, ec.size() * 100);
                    }
                    hash.addAll(toAdd);
                    hashes.add(hash);
                }
                MappingWorksheet.Mapping m = new MappingWorksheet.Mapping(ws);
                assert (m.size() == ws.works.size());
                if (this.assignGreedily(m, task, hashes, 0)) {
                    assert (m.isCompletelyValid());
                    return m;
                }
                return null;
            }

            private boolean assignGreedily(MappingWorksheet.Mapping m, Queue.Task task, List<ConsistentHash<MappingWorksheet.ExecutorChunk>> hashes, int i) {
                if (i == hashes.size()) {
                    return true;
                }
                String key = task.getFullDisplayName() + (i > 0 ? String.valueOf(i) : "");
                for (MappingWorksheet.ExecutorChunk ec : hashes.get(i).list(key)) {
                    m.assign(i, ec);
                    if (!m.isPartiallyValid() || !this.assignGreedily(m, task, hashes, i + 1)) continue;
                    return true;
                }
                m.assign(i, null);
                return false;
            }
        };
    }
}

