/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.model.Resource;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public final class ResourceList {
    private static final Logger LOGGER = Logger.getLogger(ResourceList.class.getName());
    private final Set<Resource> all = new HashSet<Resource>();
    private final Map<Resource, Integer> write = new HashMap<Resource, Integer>();
    private static final Integer MAX_INT = Integer.MAX_VALUE;
    public static final ResourceList EMPTY = new ResourceList();

    public static ResourceList union(ResourceList ... lists) {
        return ResourceList.union(Arrays.asList(lists));
    }

    public static ResourceList union(Collection<ResourceList> lists) {
        switch (lists.size()) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                return lists.iterator().next();
            }
        }
        ResourceList r = new ResourceList();
        for (ResourceList l : lists) {
            r.all.addAll(l.all);
            for (Map.Entry<Resource, Integer> e : l.write.entrySet()) {
                r.write.put(e.getKey(), ResourceList.unbox(r.write.get(e.getKey())) + e.getValue());
            }
        }
        return r;
    }

    public ResourceList r(Resource r) {
        this.all.add(r);
        return this;
    }

    public ResourceList w(Resource r) {
        this.all.add(r);
        this.write.put(r, ResourceList.unbox(this.write.get(r)) + 1);
        return this;
    }

    public boolean isCollidingWith(ResourceList that) {
        return this.getConflict(that) != null;
    }

    public Resource getConflict(ResourceList that) {
        Resource r = this._getConflict(this, that);
        if (r != null) {
            return r;
        }
        return this._getConflict(that, this);
    }

    private Resource _getConflict(ResourceList lhs, ResourceList rhs) {
        for (Map.Entry<Resource, Integer> r : lhs.write.entrySet()) {
            for (Resource l : rhs.all) {
                Integer v = rhs.write.get(l);
                v = v != null ? Integer.valueOf(v + r.getValue()) : MAX_INT;
                if (!r.getKey().isCollidingWith(l, ResourceList.unbox(v))) continue;
                LOGGER.info("Collision with " + r + " and " + l);
                return r.getKey();
            }
        }
        return null;
    }

    public String toString() {
        HashMap<Resource, String> m = new HashMap<Resource, String>();
        for (Resource resource : this.all) {
            m.put(resource, "R");
        }
        for (Map.Entry entry : this.write.entrySet()) {
            m.put((Resource)entry.getKey(), "W" + entry.getValue());
        }
        return ((Object)m).toString();
    }

    private static int unbox(Integer x) {
        return x == null ? 0 : x;
    }
}

