/*
 * Decompiled with CFR 0.152.
 */
package hudson.model.labels;

import hudson.model.Label;
import hudson.model.labels.LabelOperatorPrecedence;
import hudson.model.labels.LabelVisitor;
import hudson.util.VariableResolver;

public abstract class LabelExpression
extends Label {
    protected LabelExpression(String name) {
        super(name);
    }

    @Override
    public String getExpression() {
        return this.getDisplayName();
    }

    static String paren(LabelOperatorPrecedence op, Label l) {
        if (op.compareTo(l.precedence()) < 0) {
            return '(' + l.getExpression() + ')';
        }
        return l.getExpression();
    }

    public static final class Implies
    extends Binary {
        public Implies(Label lhs, Label rhs) {
            super(lhs, rhs, LabelOperatorPrecedence.IMPLIES);
        }

        @Override
        protected boolean op(boolean a, boolean b) {
            return !a || b;
        }

        @Override
        public <V, P> V accept(LabelVisitor<V, P> visitor, P param) {
            return visitor.onImplies(this, param);
        }

        @Override
        public LabelOperatorPrecedence precedence() {
            return LabelOperatorPrecedence.IMPLIES;
        }
    }

    public static final class Iff
    extends Binary {
        public Iff(Label lhs, Label rhs) {
            super(lhs, rhs, LabelOperatorPrecedence.IFF);
        }

        @Override
        protected boolean op(boolean a, boolean b) {
            return !(a ^ b);
        }

        @Override
        public <V, P> V accept(LabelVisitor<V, P> visitor, P param) {
            return visitor.onIff(this, param);
        }

        @Override
        public LabelOperatorPrecedence precedence() {
            return LabelOperatorPrecedence.IFF;
        }
    }

    public static final class Or
    extends Binary {
        public Or(Label lhs, Label rhs) {
            super(lhs, rhs, LabelOperatorPrecedence.OR);
        }

        @Override
        protected boolean op(boolean a, boolean b) {
            return a || b;
        }

        @Override
        public <V, P> V accept(LabelVisitor<V, P> visitor, P param) {
            return visitor.onOr(this, param);
        }

        @Override
        public LabelOperatorPrecedence precedence() {
            return LabelOperatorPrecedence.OR;
        }
    }

    public static final class And
    extends Binary {
        public And(Label lhs, Label rhs) {
            super(lhs, rhs, LabelOperatorPrecedence.AND);
        }

        @Override
        protected boolean op(boolean a, boolean b) {
            return a && b;
        }

        @Override
        public <V, P> V accept(LabelVisitor<V, P> visitor, P param) {
            return visitor.onAnd(this, param);
        }

        @Override
        public LabelOperatorPrecedence precedence() {
            return LabelOperatorPrecedence.AND;
        }
    }

    public static abstract class Binary
    extends LabelExpression {
        public final Label lhs;
        public final Label rhs;

        public Binary(Label lhs, Label rhs, LabelOperatorPrecedence op) {
            super(Binary.combine(lhs, rhs, op));
            this.lhs = lhs;
            this.rhs = rhs;
        }

        private static String combine(Label lhs, Label rhs, LabelOperatorPrecedence op) {
            return Binary.paren(op, lhs) + op.str + Binary.paren(op, rhs);
        }

        @Override
        public boolean matches(VariableResolver<Boolean> resolver) {
            return this.op(this.lhs.matches(resolver), this.rhs.matches(resolver));
        }

        protected abstract boolean op(boolean var1, boolean var2);
    }

    public static class Paren
    extends LabelExpression {
        public final Label base;

        public Paren(Label base) {
            super('(' + base.getExpression() + ')');
            this.base = base;
        }

        @Override
        public boolean matches(VariableResolver<Boolean> resolver) {
            return this.base.matches(resolver);
        }

        @Override
        public <V, P> V accept(LabelVisitor<V, P> visitor, P param) {
            return visitor.onParen(this, param);
        }

        @Override
        public LabelOperatorPrecedence precedence() {
            return LabelOperatorPrecedence.ATOM;
        }
    }

    public static class Not
    extends LabelExpression {
        public final Label base;

        public Not(Label base) {
            super('!' + Not.paren(LabelOperatorPrecedence.NOT, base));
            this.base = base;
        }

        @Override
        public boolean matches(VariableResolver<Boolean> resolver) {
            return !this.base.matches(resolver);
        }

        @Override
        public <V, P> V accept(LabelVisitor<V, P> visitor, P param) {
            return visitor.onNot(this, param);
        }

        @Override
        public LabelOperatorPrecedence precedence() {
            return LabelOperatorPrecedence.NOT;
        }
    }
}

