/*
 * Decompiled with CFR 0.152.
 */
package hudson.model.listeners;

import hudson.ExtensionList;
import hudson.ExtensionListView;
import hudson.ExtensionPoint;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Environment;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.CopyOnWriteList;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.jvnet.tiger_types.Types;

public abstract class RunListener<R extends Run>
implements ExtensionPoint {
    public final Class<R> targetType;
    @Deprecated
    public static final CopyOnWriteList<RunListener> LISTENERS = ExtensionListView.createCopyOnWriteList(RunListener.class);
    private static final Logger LOGGER = Logger.getLogger(RunListener.class.getName());

    protected RunListener(Class<R> targetType) {
        this.targetType = targetType;
    }

    protected RunListener() {
        Type type = Types.getBaseClass(this.getClass(), RunListener.class);
        if (!(type instanceof ParameterizedType)) {
            throw new IllegalStateException(this.getClass() + " uses the raw type for extending RunListener");
        }
        this.targetType = Types.erasure((Type)Types.getTypeArgument((Type)type, (int)0));
    }

    public void onCompleted(R r, @Nonnull TaskListener listener) {
    }

    public void onFinalized(R r) {
    }

    public void onStarted(R r, TaskListener listener) {
    }

    public Environment setUpEnvironment(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException, Run.RunnerAbortedException {
        return new Environment(){};
    }

    public void onDeleted(R r) {
    }

    @Deprecated
    public void register() {
        RunListener.all().add(this);
    }

    public void unregister() {
        RunListener.all().remove(this);
    }

    public static void fireCompleted(Run r, @Nonnull TaskListener listener) {
        for (RunListener l : RunListener.all()) {
            if (!l.targetType.isInstance(r)) continue;
            try {
                l.onCompleted(r, listener);
            }
            catch (Throwable e) {
                RunListener.report(e);
            }
        }
    }

    public static void fireStarted(Run r, TaskListener listener) {
        for (RunListener l : RunListener.all()) {
            if (!l.targetType.isInstance(r)) continue;
            try {
                l.onStarted(r, listener);
            }
            catch (Throwable e) {
                RunListener.report(e);
            }
        }
    }

    public static void fireFinalized(Run r) {
        if (Jenkins.getInstanceOrNull() == null) {
            return;
        }
        for (RunListener l : RunListener.all()) {
            if (!l.targetType.isInstance(r)) continue;
            try {
                l.onFinalized(r);
            }
            catch (Throwable e) {
                RunListener.report(e);
            }
        }
    }

    public static void fireDeleted(Run r) {
        for (RunListener l : RunListener.all()) {
            if (!l.targetType.isInstance(r)) continue;
            try {
                l.onDeleted(r);
            }
            catch (Throwable e) {
                RunListener.report(e);
            }
        }
    }

    public static ExtensionList<RunListener> all() {
        return ExtensionList.lookup(RunListener.class);
    }

    private static void report(Throwable e) {
        LOGGER.log(Level.WARNING, "RunListener failed", e);
    }
}

