/*
 * Decompiled with CFR 0.152.
 */
package hudson.model.queue;

import com.google.common.collect.Iterables;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.InvisibleAction;
import hudson.model.Queue;
import hudson.model.queue.FutureLoad;
import hudson.model.queue.LoadPredictor;
import hudson.model.queue.MappingWorksheet;
import hudson.model.queue.Timeline;
import hudson.model.queue.WorkUnit;
import hudson.util.TimeUnit2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;

public class BackFiller
extends LoadPredictor {
    private boolean recursion = false;

    @Override
    public Iterable<FutureLoad> predict(MappingWorksheet plan, Computer computer, long start, long end) {
        TimeRange timeRange = new TimeRange(start, end - start);
        ArrayList<FutureLoad> loads = new ArrayList<FutureLoad>();
        for (Queue.BuildableItem bi : Jenkins.getInstance().getQueue().getBuildableItems()) {
            Integer i;
            TentativePlan tp = bi.getAction(TentativePlan.class);
            if (tp == null && (tp = this.makeTentativePlan(bi)) == null) continue;
            if (tp.isStale()) {
                tp.range.shiftTo(System.currentTimeMillis());
            }
            if (plan.item == bi || !timeRange.overlapsWith(tp.range) || (i = (Integer)tp.footprint.get(computer)) == null) continue;
            return Collections.singleton(tp.range.toFutureLoad(i));
        }
        return loads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TentativePlan makeTentativePlan(Queue.BuildableItem bi) {
        if (this.recursion) {
            return null;
        }
        this.recursion = true;
        try {
            ArrayList<PseudoExecutorSlot> slots = new ArrayList<PseudoExecutorSlot>();
            for (Computer c : Jenkins.getInstance().getComputers()) {
                if (c.isOffline()) continue;
                for (Executor e : c.getExecutors()) {
                    slots.add(new PseudoExecutorSlot(e));
                }
            }
            MappingWorksheet worksheet = new MappingWorksheet(bi, slots, Collections.emptyList());
            MappingWorksheet.Mapping m = Jenkins.getInstance().getQueue().getLoadBalancer().map(bi.task, worksheet);
            if (m == null) {
                TentativePlan i$ = null;
                return i$;
            }
            HashMap<Computer, Integer> footprint = new HashMap<Computer, Integer>();
            for (Map.Entry<MappingWorksheet.WorkChunk, MappingWorksheet.ExecutorChunk> e : m.toMap().entrySet()) {
                Computer c = e.getValue().computer;
                Integer v = (Integer)footprint.get(c);
                if (v == null) {
                    v = 0;
                }
                v = v + e.getKey().size();
                footprint.put(c, v);
            }
            long d = bi.task.getEstimatedDuration();
            if (d <= 0L) {
                d = TimeUnit2.MINUTES.toMillis(5L);
            }
            TimeRange slot = new TimeRange(System.currentTimeMillis(), d);
            for (Map.Entry e : footprint.entrySet()) {
                Computer computer = (Computer)e.getKey();
                Timeline timeline = new Timeline();
                for (LoadPredictor lp : LoadPredictor.all()) {
                    for (FutureLoad fl : Iterables.limit(lp.predict(worksheet, computer, slot.start, slot.end), (int)100)) {
                        timeline.insert(fl.startTime, fl.startTime + fl.duration, fl.numExecutors);
                    }
                }
                Long x = timeline.fit(slot.start, slot.duration, computer.countExecutors() - (Integer)e.getValue());
                if (x == null) {
                    x = slot.end;
                }
                slot = slot.shiftTo(x);
            }
            TentativePlan tp = new TentativePlan(footprint, slot);
            bi.addAction(tp);
            TentativePlan tentativePlan = tp;
            return tentativePlan;
        }
        finally {
            this.recursion = false;
        }
    }

    @Extension
    public static BackFiller newInstance() {
        if (SystemProperties.getBoolean(BackFiller.class.getName())) {
            return new BackFiller();
        }
        return null;
    }

    public static final class TentativePlan
    extends InvisibleAction {
        private final Map<Computer, Integer> footprint;
        public final TimeRange range;

        public TentativePlan(Map<Computer, Integer> footprint, TimeRange range) {
            this.footprint = footprint;
            this.range = range;
        }

        public Object writeReplace() {
            return null;
        }

        public boolean isStale() {
            return this.range.end < System.currentTimeMillis();
        }
    }

    private static final class TimeRange {
        public final long start;
        public final long duration;
        public final long end;

        private TimeRange(long start, long duration) {
            this.start = start;
            this.duration = duration;
            this.end = start + duration;
        }

        public boolean overlapsWith(TimeRange that) {
            return this.start <= that.start && that.start <= this.end || that.start <= this.start && this.start <= that.end;
        }

        public FutureLoad toFutureLoad(int size) {
            return new FutureLoad(this.start, this.duration, size);
        }

        public TimeRange shiftTo(long newStart) {
            if (newStart == this.start) {
                return this;
            }
            return new TimeRange(newStart, this.duration);
        }
    }

    private static final class PseudoExecutorSlot
    extends MappingWorksheet.ExecutorSlot {
        private Executor executor;

        private PseudoExecutorSlot(Executor executor) {
            this.executor = executor;
        }

        @Override
        public Executor getExecutor() {
            return this.executor;
        }

        @Override
        public boolean isAvailable() {
            return true;
        }

        @Override
        protected void set(WorkUnit p) {
            throw new UnsupportedOperationException();
        }
    }
}

