/*
 * Decompiled with CFR 0.152.
 */
package hudson.os;

import hudson.os.PosixException;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.logging.Logger;
import jnr.constants.platform.Errno;
import jnr.posix.POSIXHandler;
import jnr.posix.util.DefaultPOSIXHandler;
import org.jruby.ext.posix.JavaPOSIX;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXFactory;
import org.jruby.ext.posix.POSIXHandler;

public class PosixAPI {
    private static jnr.posix.POSIX posix;
    private static POSIX jnaPosix;
    private static final Logger LOGGER;

    public static synchronized jnr.posix.POSIX jnr() {
        if (posix == null) {
            posix = jnr.posix.POSIXFactory.getPOSIX((POSIXHandler)new DefaultPOSIXHandler(){

                public void error(Errno error, String extraData) {
                    throw new PosixException("native error " + error.description() + " " + extraData, this.convert(error));
                }

                public void error(Errno error, String methodName, String extraData) {
                    throw new PosixException("native error calling " + methodName + ": " + error.description() + " " + extraData, this.convert(error));
                }

                private POSIX.ERRORS convert(Errno error) {
                    try {
                        return POSIX.ERRORS.valueOf((String)error.name());
                    }
                    catch (IllegalArgumentException x) {
                        return POSIX.ERRORS.EIO;
                    }
                }
            }, (boolean)true);
        }
        return posix;
    }

    @Deprecated
    public boolean isNative() {
        return PosixAPI.supportsNative();
    }

    @Deprecated
    public static boolean supportsNative() {
        return !(jnaPosix instanceof JavaPOSIX);
    }

    @Deprecated
    public static synchronized POSIX get() {
        if (jnaPosix == null) {
            jnaPosix = POSIXFactory.getPOSIX((org.jruby.ext.posix.POSIXHandler)new org.jruby.ext.posix.POSIXHandler(){

                public void error(POSIX.ERRORS errors, String s) {
                    throw new PosixException(s, errors);
                }

                public void unimplementedError(String s) {
                    throw new UnsupportedOperationException(s);
                }

                public void warn(POSIXHandler.WARNING_ID warning_id, String s, Object ... objects) {
                    LOGGER.fine(s);
                }

                public boolean isVerbose() {
                    return true;
                }

                public File getCurrentWorkingDirectory() {
                    return new File(".").getAbsoluteFile();
                }

                public String[] getEnv() {
                    Map<String, String> envs = System.getenv();
                    String[] envp = new String[envs.size()];
                    int i = 0;
                    for (Map.Entry<String, String> e : envs.entrySet()) {
                        envp[i++] = e.getKey() + '+' + e.getValue();
                    }
                    return envp;
                }

                public InputStream getInputStream() {
                    return System.in;
                }

                public PrintStream getOutputStream() {
                    return System.out;
                }

                public int getPID() {
                    return 0;
                }

                public PrintStream getErrorStream() {
                    return System.err;
                }
            }, (boolean)true);
        }
        return jnaPosix;
    }

    static {
        LOGGER = Logger.getLogger(PosixAPI.class.getName());
    }
}

