/*
 * Decompiled with CFR 0.152.
 */
package hudson.scheduler;

import antlr.ANTLRException;
import hudson.scheduler.CronTab;
import hudson.scheduler.Hash;
import hudson.scheduler.Messages;
import java.util.Calendar;
import java.util.Collection;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public final class CronTabList {
    private final Vector<CronTab> tabs;
    private static final Logger LOGGER = Logger.getLogger(CronTabList.class.getName());

    public CronTabList(Collection<CronTab> tabs) {
        this.tabs = new Vector<CronTab>(tabs);
    }

    public synchronized boolean check(Calendar cal) {
        for (CronTab tab : this.tabs) {
            if (!tab.check(cal)) continue;
            return true;
        }
        return false;
    }

    public String checkSanity() {
        for (CronTab tab : this.tabs) {
            String s = tab.checkSanity();
            if (s == null) continue;
            return s;
        }
        return null;
    }

    @CheckForNull
    public static String getValidTimezone(String timezone) {
        String[] validIDs;
        for (String str : validIDs = TimeZone.getAvailableIDs()) {
            if (str == null || !str.equals(timezone)) continue;
            return timezone;
        }
        return null;
    }

    public static CronTabList create(@Nonnull String format) throws ANTLRException {
        return CronTabList.create(format, null);
    }

    public static CronTabList create(@Nonnull String format, Hash hash) throws ANTLRException {
        Vector<CronTab> r = new Vector<CronTab>();
        int lineNumber = 0;
        String timezone = null;
        for (String line : format.split("\\r?\\n")) {
            line = line.trim();
            if (++lineNumber == 1 && line.startsWith("TZ=")) {
                timezone = CronTabList.getValidTimezone(line.replace("TZ=", ""));
                if (timezone != null) {
                    LOGGER.log(Level.CONFIG, "cron with timezone {0}", timezone);
                    continue;
                }
                LOGGER.log(Level.CONFIG, "invalid timezone {0}", line);
                continue;
            }
            if (line.length() == 0 || line.startsWith("#")) continue;
            try {
                r.add(new CronTab(line, lineNumber, hash, timezone));
            }
            catch (ANTLRException e) {
                throw new ANTLRException(Messages.CronTabList_InvalidInput(line, e.toString()), (Throwable)e);
            }
        }
        return new CronTabList(r);
    }

    @CheckForNull
    @Restricted(value={NoExternalUse.class})
    public Calendar previous() {
        Calendar nearest = null;
        for (CronTab tab : this.tabs) {
            Calendar scheduled = tab.floor(Calendar.getInstance());
            if (nearest != null && !nearest.before(scheduled)) continue;
            nearest = scheduled;
        }
        return nearest;
    }

    @CheckForNull
    @Restricted(value={NoExternalUse.class})
    public Calendar next() {
        Calendar nearest = null;
        for (CronTab tab : this.tabs) {
            Calendar scheduled = tab.ceil(Calendar.getInstance());
            if (nearest != null && !nearest.after(scheduled)) continue;
            nearest = scheduled;
        }
        return nearest;
    }
}

