/*
 * Decompiled with CFR 0.152.
 */
package hudson.search;

import hudson.search.SearchIndex;
import hudson.search.SearchItem;
import hudson.search.SearchableModelObject;
import hudson.search.UserSearchProperty;
import java.util.Collection;
import java.util.List;

public abstract class CollectionSearchIndex<SMT extends SearchableModelObject>
implements SearchIndex {
    protected abstract SearchItem get(String var1);

    protected abstract Collection<SMT> all();

    @Override
    public void find(String token, List<SearchItem> result) {
        SearchItem p = this.get(token);
        if (p != null) {
            result.add(p);
        }
    }

    @Override
    public void suggest(String token, List<SearchItem> result) {
        Collection<SMT> items = this.all();
        boolean isCaseSensitive = UserSearchProperty.isCaseInsensitive();
        if (isCaseSensitive) {
            token = token.toLowerCase();
        }
        if (items == null) {
            return;
        }
        for (SearchableModelObject o : items) {
            String name = this.getName(o);
            if (isCaseSensitive) {
                name = name.toLowerCase();
            }
            if (o == null || !name.contains(token)) continue;
            result.add(o);
        }
    }

    protected String getName(SMT o) {
        return o.getDisplayName();
    }
}

