/*
 * Decompiled with CFR 0.152.
 */
package hudson.slaves;

import hudson.Functions;
import hudson.model.User;
import hudson.slaves.Messages;
import java.util.Date;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public abstract class OfflineCause {
    protected final long timestamp = System.currentTimeMillis();

    @Exported
    public long getTimestamp() {
        return this.timestamp;
    }

    @Nonnull
    public final Date getTime() {
        return new Date(this.timestamp);
    }

    public static OfflineCause create(Localizable d) {
        if (d == null) {
            return null;
        }
        return new SimpleOfflineCause(d);
    }

    public static class IdleOfflineCause
    extends SimpleOfflineCause {
        public IdleOfflineCause() {
            super(Messages._RetentionStrategy_Demand_OfflineIdle());
        }
    }

    public static class ByCLI
    extends UserCause {
        @Exported
        public final String message;

        public ByCLI(String message) {
            super(User.current(), message);
            this.message = message;
        }
    }

    public static class UserCause
    extends SimpleOfflineCause {
        private final User user;

        public UserCause(User user, String message) {
            super(Messages._SlaveComputer_DisconnectedBy(user != null ? user.getId() : Jenkins.ANONYMOUS.getName(), message != null ? " : " + message : ""));
            this.user = user;
        }

        public User getUser() {
            return this.user;
        }
    }

    public static class LaunchFailed
    extends OfflineCause {
        public String toString() {
            return Messages.OfflineCause_LaunchFailed();
        }
    }

    public static class ChannelTermination
    extends OfflineCause {
        @Exported
        public final Exception cause;

        public ChannelTermination(Exception cause) {
            this.cause = cause;
        }

        public String getShortDescription() {
            return this.cause.toString();
        }

        public String toString() {
            return Messages.OfflineCause_connection_was_broken_(Functions.printThrowable(this.cause));
        }
    }

    public static class SimpleOfflineCause
    extends OfflineCause {
        public final Localizable description;

        protected SimpleOfflineCause(Localizable description) {
            this.description = description;
        }

        @Exported(name="description")
        public String toString() {
            return this.description.toString();
        }
    }
}

